/**
 Model interfaces

 TODO: Hand-written for now, needs to be generated from Java sources with docstrings copied over etc
 */
export declare namespace Model {
    interface WithClass {
        _class: string;
    }
    enum RunState {
        QUEUED = "QUEUED",
        RUNNING = "RUNNING",
        PAUSED = "PAUSED",
        SKIPPED = "SKIPPED",
        NOT_BUILT = "NOT_BUILT",
        FINISHED = "FINISHED",
    }
    enum RunResult {
        SUCCESS = "SUCCESS",
        UNSTABLE = "UNSTABLE",
        FAILURE = "FAILURE",
        NOT_BUILT = "NOT_BUILT",
        UNKNOWN = "UNKNOWN",
        ABORTED = "ABORTED",
    }
    interface Link {
        href: string;
    }
    interface Resource {
        link: Link;
        _links: {
            [key: string]: Link;
        };
    }
    interface Action extends WithClass {
        urlName: string;
    }
    interface PipelineItem extends Resource, WithClass {
        organization: string;
        name: string;
        displayName: string;
        fullName: string;
        fullDisplayName: string;
        actions: Array<Action>;
    }
    interface RunnableItem extends PipelineItem {
        weatherScore: number;
        latestRun: Run | null;
        estimatedDurationInMillis: number;
        parameters: Array<any>;
    }
    interface ContainerItem extends PipelineItem {
        numberOfFolders: number;
        numberOfPipelines: number;
        icon?: Resource;
        pipelineFolderNames: Array<string>;
    }
    interface MultiBranchItem extends ContainerItem {
        totalNumberOfBranches: number;
        numberOfFailingBranches: number;
        numberOfSuccessfulBranches: number;
        totalNumberOfPullRequests: number;
        numberOfFailingPullRequests: number;
        numberOfSuccessfulPullRequests: number;
        branchNames: Array<string>;
    }
    interface Run extends Resource, WithClass {
        organization: string;
        id: string;
        pipeline: string;
        name: string;
        description: string;
        changeSet: Array<Change>;
        startTime: string;
        enQueueTime: string;
        endTime: string;
        durationInMillis: number;
        estimatedDurationInMillis: number;
        state: RunState;
        result: RunResult;
        runSummary: string;
        type: string;
        artifactsZipFile: string;
        actions: Array<Action>;
        testSummary?: TestSummary;
        causes: Array<RunCause>;
        causeOfBlockage: string;
        replayable: boolean;
    }
    interface Change extends Resource, WithClass {
        author: User;
        commitId: string;
        timestamp: string;
        msg: string;
        affectedPaths: Array<string>;
        url: string;
        issues?: Array<Issue>;
    }
    interface TestSummary {
        total: number;
        skipped: number;
        failed: number;
        passed: number;
        fixed: number;
        existingFailed: number;
        regressions: number;
    }
    interface RunCause {
        shortDescription: string;
    }
    interface User extends Resource, WithClass {
        id: string;
        fullName: string;
        email?: string;
        permission: UserPermission;
        avatar: string;
    }
    interface Issue {
        id: string;
        url: string;
    }
    interface UserPermission {
        administrator: boolean;
        pipeline: {
            [key: string]: boolean;
        };
        credential: {
            [key: string]: boolean;
        };
    }
}
