'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.RunApi = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Created by cmeyers on 8/29/16.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


var _urlconfig = require('../urlconfig');

var _fetch = require('../fetch');

var _utils = require('../utils');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var RunApi = exports.RunApi = function () {
    function RunApi() {
        _classCallCheck(this, RunApi);
    }

    _createClass(RunApi, [{
        key: 'startRun',
        value: function startRun(item) {
            var path = _urlconfig.UrlConfig.getJenkinsRootURL();
            var runUrl = _utils.Utils.cleanSlashes(path + '/' + item._links.self.href + '/runs/');

            var fetchOptions = {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                }
            };

            return _fetch.Fetch.fetchJSON(runUrl, { fetchOptions: fetchOptions });
        }
    }, {
        key: 'stopRun',
        value: function stopRun(run) {
            var path = _urlconfig.UrlConfig.getJenkinsRootURL();
            var runUrl = run._links.self.href;
            var stopUrl = _utils.Utils.cleanSlashes(path + '/' + runUrl + '/stop/?blocking=true&timeOutInSecs=10');

            var fetchOptions = {
                method: 'PUT',
                headers: {
                    'Content-Type': 'application/json'
                }
            };

            return _fetch.Fetch.fetch(stopUrl, { fetchOptions: fetchOptions });
        }
    }, {
        key: 'replayRun',
        value: function replayRun(run) {
            var path = _urlconfig.UrlConfig.getJenkinsRootURL();
            var runUrl = run._links.self.href;
            var replayPipelineUrl = _utils.Utils.cleanSlashes(path + '/' + runUrl + '/replay/');

            var fetchOptions = {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                }
            };

            return _fetch.Fetch.fetchJSON(replayPipelineUrl, { fetchOptions: fetchOptions });
        }
    }, {
        key: 'restartStage',
        value: function restartStage(run, nodeId) {
            var path = _urlconfig.UrlConfig.getJenkinsRootURL();
            var runUrl = run._links.self.href;
            var restartStageUrl = _utils.Utils.cleanSlashes(path + '/' + runUrl + '/nodes/' + nodeId + '/restart');

            var fetchOptions = {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    restart: 'true'
                })
            };

            return _fetch.Fetch.fetchJSON(restartStageUrl, { fetchOptions: fetchOptions });
        }
    }]);

    return RunApi;
}();
//# sourceMappingURL=RunApi.js.map
