"use strict";
/*********************************************************************************************
 **********************************************************************************************

 General URL utility functions.

 For constructing specific URLs (such as ui links to screens, REST or classic links, etc), see
 the UrlBuilder module.

 **********************************************************************************************
 *********************************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Double encode name, feature/test#1 is encoded as feature%252Ftest%25231
 *
 * Branch names are double-encoded in REST urls due to issues on the backend on certain filesystems.
 */
function doubleUriEncode(input) {
    return input == null ? '' : encodeURIComponent(encodeURIComponent(input));
}
exports.doubleUriEncode = doubleUriEncode;
/**
 * Appended to the end of various URLs to signal you want all of a resource that is normally paged.
 */
exports.fetchAllSuffix = '?start=0';
/**
 * Append a slash to the input url if it doesn't end with one already.
 */
function ensureTrailingSlash(url) {
    if (url && url.length > 0 && url.charAt(url.length - 1) !== '/') {
        return url + "/";
    }
    return url;
}
exports.ensureTrailingSlash = ensureTrailingSlash;
exports.UrlUtils = {
    doubleUriEncode: doubleUriEncode,
    fetchAllSuffix: exports.fetchAllSuffix,
    ensureTrailingSlash: ensureTrailingSlash,
};
