'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.RestPaths = undefined;

var _jenkinsEncode = require('../utils/jenkins-encode');

/**
 * This object defines rest paths
 */
var RestPaths = exports.RestPaths = {
    _convertSlashes: function _convertSlashes(pipeline) {
        return pipeline.replace(/\//g, '/pipelines/');
    },
    apiRoot: function apiRoot() {
        return '/blue/rest';
    },
    pipelines: function pipelines(organizationName, searchText) {
        var organization = organizationName ? ';organization:' + encodeURIComponent(organizationName) : '';
        var searchTextQuery = '';

        if (searchText) {
            searchTextQuery = ('*' + searchText + '*').replace(/\//g, '*/*').replace('**', '*');
        }

        return this.apiRoot() + '/search/?q=type:pipeline' + organization + ';pipeline:' + encodeURIComponent(searchTextQuery) + ';excludedFromFlattening:jenkins.branch.MultiBranchProject,hudson.matrix.MatrixProject&filter=no-folders';
    },
    runs: function runs(organization, pipeline, branch) {
        var branchStr = branch ? '?branch=' + branch : '';
        return this.apiRoot() + '/organizations/' + encodeURIComponent(organization) + '/pipelines/' + pipeline + '/runs/' + branchStr;
    },
    run: function run(_ref) {
        var organization = _ref.organization,
            pipeline = _ref.pipeline,
            branch = _ref.branch,
            runId = _ref.runId;

        if (branch) {
            return this.pipeline(organization, pipeline) + 'branches/' + encodeURIComponent(_jenkinsEncode.JenkinsEncode.encode(branch)) + '/runs/' + runId + '/';
        }

        return this.pipeline(organization, pipeline) + 'runs/' + runId + '/';
    },
    pipeline: function pipeline(organization, _pipeline) {
        return this.apiRoot() + '/organizations/' + encodeURIComponent(organization) + '/pipelines/' + this._convertSlashes(_pipeline) + '/';
    },
    branches: function branches(organization, pipeline) {
        return this.apiRoot() + '/organizations/' + encodeURIComponent(organization) + '/pipelines/' + pipeline + '/branches/?filter=origin';
    },
    pullRequests: function pullRequests(organization, pipeline) {
        return this.apiRoot() + '/organizations/' + encodeURIComponent(organization) + '/pipelines/' + pipeline + '/branches/?filter=pull-requests';
    }
};
//# sourceMappingURL=rest.js.map
