'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.capable = exports.capabilityAugmenter = exports.capabilityStore = undefined;

var _Capable = require('./Capable');

Object.defineProperty(exports, 'capable', {
  enumerable: true,
  get: function get() {
    return _Capable.capable;
  }
});

var _CapabilityApi = require('./CapabilityApi');

var _CapabilityStore = require('./CapabilityStore');

var _CapabilityAugmenter = require('./CapabilityAugmenter');

var api = new _CapabilityApi.CapabilityApi(); /**
                                               * Created by cmeyers on 9/8/16.
                                               */

var store = new _CapabilityStore.CapabilityStore(api);
var augmenter = new _CapabilityAugmenter.CapabilityAugmenter(store);

// export as named singletons
exports.capabilityStore = store;
exports.capabilityAugmenter = augmenter;
//# sourceMappingURL=index.js.map
