'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TestUtils = undefined;

var _fetch2 = require('./fetch');

// default impls
var fetchJSON = _fetch2.Fetch.fetchJSON;
var fetch = _fetch2.Fetch.fetch;

var TestUtils = exports.TestUtils = {
    /**
     * Switches fetch functions with arbitrary replacements.
     * Useful for test spies.
     *
     * @param _fetchJSON
     * @param _fetch
     */
    patchFetch: function patchFetch(_fetchJSON, _fetch) {
        _fetch2.Fetch.fetchJSON = _fetchJSON;
        _fetch2.Fetch.fetch = _fetch;
    },


    /**
     * Switches fetch functions for ones that dont use JWT. Needed
     * for running tests.
     */
    patchFetchNoJWT: function patchFetchNoJWT() {
        _fetch2.Fetch.fetchJSON = _fetch2.FetchFunctions.rawFetchJSON;
        _fetch2.Fetch.fetch = _fetch2.FetchFunctions.rawFetch;
    },


    /**
     * Restores original fetch functions.
     */
    restoreFetch: function restoreFetch() {
        _fetch2.Fetch.fetchJSON = fetchJSON;
        _fetch2.Fetch.fetch = fetch;
    },


    /**
     * Patches fetch functions with a resolved promise. This will make all fetch calls return
     * this data.
     *
     * Usage
     *
     * TestUtils.patchFetchWithData((url, options) => {
     *      assert.equals(url,"someurl")
     *      return { mydata: 5 }
     * })
     */
    patchFetchWithData: function patchFetchWithData(dataFn) {
        _fetch2.Fetch.fetchJSON = _fetch2.Fetch.fetch = function (url, options) {
            var _ref = options || {},
                onSuccess = _ref.onSuccess,
                onError = _ref.onError;

            var data = Promise.resolve(dataFn(url, options));

            if (onSuccess) {
                return data.then(onSuccess).catch(_fetch2.FetchFunctions.onError(onError));
            }

            return data;
        };
    }
};
//# sourceMappingURL=testutils.js.map
