'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.ParametersRender = ParametersRender;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _designLanguage = require('@jenkins-cd/design-language');

var _i18n = require('../../i18n/i18n');

var _index = require('../index');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Translate function
 */
var translate = (0, _i18n.i18nTranslator)('blueocean-web');

function ParametersRender(properties) {
    var _this = this;

    var parameters = properties.parameters,
        _properties$onChange = properties.onChange,
        onChange = _properties$onChange === undefined ? function () {} : _properties$onChange;

    var renderedParameters = parameters.map(function (parameter, index) {
        var type = parameter.type;

        var returnValue = _index.supportedInputTypesMapping[type];
        if (returnValue) {
            return _react2.default.createElement(returnValue, _extends({}, parameter, {
                key: index,
                onChange: onChange.bind(_this, index)
            }));
        }
        // error case - returning an error alert
        var alertCaption = translate('parameter.error.message', { 0: type });
        var alertTitle = translate('parameter.error.title');
        return _react2.default.createElement(_designLanguage.Alerts, { message: alertCaption, type: 'Error', title: alertTitle });
    });

    return _react2.default.createElement(
        'div',
        null,
        renderedParameters
    );
}
//# sourceMappingURL=ParametersRender.js.map
