import * as Promise from 'bluebird';
import 'isomorphic-fetch';
export declare namespace FetchFunctions {
    interface RawFetchOpts {
        onSuccess?: <A, B>(success: A) => B;
        onError?: <A, B>(error: A) => B;
        fetchOptions?: RequestInit;
        disableDedupe?: boolean;
        disableLoadingIndicator?: boolean;
        ignoreRefreshHeader?: boolean;
    }
}
export declare namespace Fetch {
    interface FetchOpts {
        onSuccess?: <A, B>(success: A) => B;
        onError?: <A, B>(error: A) => B;
        fetchOptions?: RequestInit;
        disableCapabilities?: boolean;
        disableLoadingIndicator?: boolean;
        ignoreRefreshHeader?: boolean;
    }
}
export declare class FetchFunctions {
    /**
     * Ensures the URL starts with jenkins path if not an absolute URL.
     * @param url
     * @returns {string}
     */
    static prefixUrl(url: string): string;
    static checkRefreshHeader(response: Response): Response;
    /**
     * This method checks for for 2XX http codes. Throws error it it is not.
     * This should only be used if not using fetch or fetchJson.
     */
    static checkStatus(response: Response): Response;
    static stopLoadingIndicator(response: Response): Response;
    /**
     * Adds same-origin option to the fetch.
     */
    static sameOriginFetchOption(options?: RequestInit): RequestInit;
    /**
     * Enhances the fetchOptions with the JWT bearer token. Will only be needed
     * if not using fetch or fetchJson.
     */
    static jwtFetchOption(token: string, options?: RequestInit): RequestInit;
    /**
     * REturns the json body from the response. It is only needed if
     * you are using FetchUtils.fetch
     *
     * Usage:
     * FetchUtils.fetch(..).then(FetchUtils.parseJSON)
     */
    static parseJSON<T>(response: Response): Promise<T>;
    /**
     * Parses the response body for the error generated in checkStatus.
     */
    static parseErrorJson(error: any): any;
    /**
     * Error function helper to log errors to console.
     *
     * Usage;
     * fetchJson(..).catch(FetchUtils.consoleError)
     */
    static consoleError(error: any): void;
    /**
     * Error function helper to call a callback on a rejected promise.
     * if callback is null, log to console). Use .catch() if you know it
     * will not be null though.
     *
     * Usage;
     * fetchJson(..).catch(FetchUtils.onError(error => //do something)
     */
    static onError(errorFunc: (any) => any): (any) => void;
    /**
     * Raw fetch that returns the json body.
     *
     * This method is semi-private, under normal conditions it should not be
     * used as it does not include the JWT bearer token
     *
     * @param {string} url - The URL to fetch from.
     * @param {Object} [options]
     * @param {function} [options.onSuccess] - Optional callback success function.
     * @param {function} [options.onError] - Optional error callback.
     * @param {Object} [options.fetchOptions] - Optional isomorphic-fetch options.
     * @param {boolean} [options.disableDedupe] - Optional flag to disable dedupe for this request.
     * @param {boolean} [options.disableLoadingIndicator] - Optional flag to disable loading indicator for this request.
     * @returns JSON body
     */
    static rawFetchJSON(url: any, {onSuccess, onError, fetchOptions, disableDedupe, disableLoadingIndicator, ignoreRefreshHeader}?: FetchFunctions.RawFetchOpts): any;
    /**
     * Raw fetch.
     *
     * This method is semi-private, under normal conditions it should not be
     * used as it does not include the JWT bearer token
     *
     * @param {string} url - The URL to fetch from.
     * @param {Object} [options]
     * @param {function} [options.onSuccess] - Optional callback success function.
     * @param {function} [options.onError] - Optional error callback.
     * @param {Object} [options.fetchOptions] - Optional isomorphic-fetch options.
     * @param {boolean} [options.disableDedupe] - Optional flag to disable dedupe for this request.
     * @param {boolean} [options.disableLoadingIndicator] - Optional flag to disable loading indicator for this request.
     * @returns fetch response
     */
    static rawFetch(url: any, {onSuccess, onError, fetchOptions, disableDedupe, disableLoadingIndicator, ignoreRefreshHeader}?: FetchFunctions.RawFetchOpts): any;
}
export declare class Fetch {
    /**
     * Fetch JSON data.
     * <p>
     * Utility function that can be mocked for testing.
     *
     * @param {string} url - The URL to fetch from.
     * @param {Object} [options]
     * @param {function} [options.onSuccess] - Optional callback success function.
     * @param {function} [options.onError] - Optional error callback.
     * @param {Object} [options.fetchOptions] - Optional isomorphic-fetch options.
     * @returns JSON body.
     */
    static fetchJSON(url: any, {onSuccess, onError, fetchOptions, disableCapabilities, disableLoadingIndicator, ignoreRefreshHeader}?: Fetch.FetchOpts): any;
    /**
     * Fetch data.
     * <p>
     * Utility function that can be mocked for testing.
     *
     * @param {string} url - The URL to fetch from.
     * @param {Object} [options]
     * @param {function} [options.onSuccess] - Optional callback success function.
     * @param {function} [options.onError] - Optional error callback.
     * @param {Object} [options.fetchOptions] - Optional isomorphic-fetch options.
     * @returns fetch body.
     */
    static fetch(url: any, {onSuccess, onError, fetchOptions, disableLoadingIndicator, ignoreRefreshHeader}?: Fetch.FetchOpts): any;
}
