export declare type RunDetailsWithSelfLink = {
    _links: {
        self: {
            href: string;
        };
    };
};
/**
 * Builds a run details view url from a RunDetails object
 */
export declare function buildRunUrlForDetails(runDetails: RunDetailsWithSelfLink): string;
/**
 * Builds a run details view url from a run's REST link URL
 */
export declare function buildRunUrlForRestUrl(restUrl: string): string;
/**
 * Builds a run details view url from identifiers
 */
export declare function buildRunUrl(organizationName: any, pipelineFullName: any, branchOrPipelineName: any, runId: any, tabName?: string): string;
/**
 * Build a root-relative URL to the organization's pipeline list screen.
 * @param organization
 */
export declare function buildOrganizationUrl(organization: any): string;
/**
 * Build a root-relative URL to the pipeline details screen.
 * @param organizationName
 * @param pipelineFullName
 * @param tabName
 * @returns {string}
 */
export declare function buildPipelineUrl(organizationName: any, pipelineFullName: any, tabName: any): string;
/**
 * Gives classic jenkins job path prefix.
 * For organization group '/folder1/org1', job prefix is: /job/folder1/job/org1
 * For root organization group '/', there is no prefix: ''.
 * @param organizationGroupName organization group
 * @returns {string}
 */
export declare function classicOrganizationRoot(organizationGroupName: any): string;
/**
 * The root of a classic URL for a specific pipeline using the default org group
 * @param pipelineFullName
 * @returns {string}
 */
export declare function classicJobRoot(pipelineFullName: any): string;
/**
 * URL to "create job" page in classic
 */
export declare function buildClassicCreateJobUrl(): string;
/**
 * URL to the pipeline configuration screen in classic
 */
export declare function buildClassicConfigUrl(pipelineDetails: any): string | null;
/**
 * URL to the classic input sceen for a specific run
 */
export declare function buildClassicInputUrl(pipelineDetails: any, branchName: any, runId: any): string | null;
/**
 * URL to classic to trigger a build
 *
 * example: http://localhost:8080/jenkins/job/scherler/job/Jenkins-40617-params/build?delay=0sec
 */
export declare function buildClassicBuildUrl(pipelineDetails: any): string | null;
/**
 * Check is the current Blue ocean page a pipeline page and if so,
 * decode it to the corresponding classic Jenkins Job page.
 * @returns {string|undefined} The classic job page, or undefined if
 * it was unable to decode the page URL.
 */
export declare function toClassicJobPage(currentPageUrl: any, isMultibranch?: boolean): string;
/**
 * Build a REST resource URL from component identifiers.
 *
 * @param organizationName the name of the owning organisation, including org folders
 * @param pipelineFullName (optional) the full name of a pipeline, including folders
 * @param branchName (optional) branch name for multibranch projects
 * @param runId (optional) identifies an individual run
 * @returns a URL string
 */
export declare function buildRestUrl(organizationName: string, pipelineFullName?: string, branchName?: string, runId?: string): string;
