/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.service.scan.srm;

import hudson.EnvVars;
import hudson.model.TaskListener;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.Utility;
import io.jenkins.plugins.security.scan.global.enums.SecurityProduct;
import io.jenkins.plugins.security.scan.input.project.Project;
import io.jenkins.plugins.security.scan.input.srm.Branch;
import io.jenkins.plugins.security.scan.input.srm.SRM;
import io.jenkins.plugins.security.scan.service.scm.RepositoryDetailsHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SRMParametersService {
    private final LoggerWrapper logger;
    private final EnvVars envVars;

    public SRMParametersService(TaskListener listener, EnvVars envVars) {
        this.logger = new LoggerWrapper(listener);
        this.envVars = envVars;
    }

    public boolean hasAllMandatorySrmParams(Map<String, Object> srmParameters) {
        if (srmParameters == null || srmParameters.isEmpty()) {
            return false;
        }
        List<String> missingMandatoryParams = this.getSrmMissingMandatoryParams(srmParameters);
        if (missingMandatoryParams.isEmpty()) {
            this.logger.info("SRM parameters are validated successfully", new Object[0]);
            return true;
        }
        this.logger.error("%s - required parameters for %s is missing", missingMandatoryParams.toString(), SecurityProduct.SRM.name());
        return false;
    }

    private List<String> getSrmMissingMandatoryParams(Map<String, Object> srmParameters) {
        ArrayList<String> missingMandatoryParams = new ArrayList<String>();
        Arrays.asList("srm_url", "srm_apikey", "srm_assessment_types").forEach(key -> {
            boolean isKeyValid;
            boolean bl = isKeyValid = srmParameters.containsKey(key) && srmParameters.get(key) != null && !srmParameters.get(key).toString().isEmpty();
            if (!isKeyValid) {
                missingMandatoryParams.add((String)key);
            }
        });
        String jobType = Utility.jenkinsJobType(this.envVars);
        if (!jobType.equalsIgnoreCase("WorkflowMultiBranchProject")) {
            boolean isProjectIdValid;
            boolean isProjectNameValid = srmParameters.containsKey("srm_project_name") && srmParameters.get("srm_project_name") != null && !srmParameters.get("srm_project_name").toString().isEmpty();
            boolean bl = isProjectIdValid = srmParameters.containsKey("srm_project_id") && srmParameters.get("srm_project_id") != null && !srmParameters.get("srm_project_id").toString().isEmpty();
            if (!isProjectNameValid && !isProjectIdValid) {
                this.logger.error("One of %s or %s must be present.", "srm_project_name", "srm_project_id");
                missingMandatoryParams.add("srm_project_id");
            }
        }
        this.showErrorMessageForJobType(missingMandatoryParams, jobType);
        return missingMandatoryParams;
    }

    private void showErrorMessageForJobType(List<String> missingMandatoryParams, String jobType) {
        if (!missingMandatoryParams.isEmpty()) {
            String jobTypeName = jobType.equalsIgnoreCase("FreeStyleProject") ? "FreeStyle" : (jobType.equalsIgnoreCase("WorkflowMultiBranchProject") ? "Multibranch Pipeline" : "Pipeline");
            this.logger.error("%s - required parameters for %s job type is missing", missingMandatoryParams, jobTypeName);
        }
    }

    public SRM prepareSrmObjectForBridge(Map<String, Object> srmParameters) {
        SRM srm = new SRM();
        Branch branch = new Branch();
        this.setUrl(srmParameters, srm);
        this.setApiKey(srmParameters, srm);
        this.setAssessmentTypes(srmParameters, srm);
        this.setProjectName(srmParameters, srm);
        this.setProjectId(srmParameters, srm);
        this.setBranchName(srmParameters, branch, srm);
        this.setBranchParent(srmParameters, branch, srm);
        this.setWaitForScan(srmParameters, srm);
        return srm;
    }

    private void setUrl(Map<String, Object> srmParameters, SRM srm) {
        if (srmParameters.containsKey("srm_url")) {
            srm.setUrl(srmParameters.get("srm_url").toString().trim());
        }
    }

    private void setApiKey(Map<String, Object> srmParameters, SRM srm) {
        if (srmParameters.containsKey("srm_apikey")) {
            srm.setApikey(srmParameters.get("srm_apikey").toString().trim());
        }
    }

    private void setProjectName(Map<String, Object> srmParameters, SRM srm) {
        if (srmParameters.containsKey("srm_project_name")) {
            srm.getSrmProject().setName(srmParameters.get("srm_project_name").toString().trim());
        } else if (!srmParameters.containsKey("srm_project_id")) {
            String repoName = RepositoryDetailsHolder.getRepositoryName();
            srm.getSrmProject().setName(repoName);
            this.logger.info("SRM Project Name: " + repoName, new Object[0]);
        }
    }

    private void setProjectId(Map<String, Object> srmParameters, SRM srm) {
        if (srmParameters.containsKey("srm_project_id")) {
            srm.getSrmProject().setId(srmParameters.get("srm_project_id").toString().trim());
        }
    }

    private void setBranchName(Map<String, Object> srmParameters, Branch branch, SRM srm) {
        if (srmParameters.containsKey("srm_branch_name")) {
            branch.setName(srmParameters.get("srm_branch_name").toString().trim());
            srm.setBranch(branch);
        }
    }

    private void setBranchParent(Map<String, Object> srmParameters, Branch branch, SRM srm) {
        if (srmParameters.containsKey("srm_branch_parent")) {
            branch.setParent(srmParameters.get("srm_branch_parent").toString().trim());
            srm.setBranch(branch);
        }
    }

    private void setAssessmentTypes(Map<String, Object> srmParameters, SRM srm) {
        String assessmentTypesValue;
        if (srmParameters.containsKey("srm_assessment_types") && !(assessmentTypesValue = srmParameters.get("srm_assessment_types").toString().trim()).isEmpty()) {
            List<String> assessmentTypes = Stream.of(assessmentTypesValue.toUpperCase().split(",")).map(String::trim).collect(Collectors.toList());
            srm.getAssessmentTypes().setTypes(assessmentTypes);
        }
    }

    private void setWaitForScan(Map<String, Object> srmParameters, SRM srm) {
        String value;
        if (srmParameters.containsKey("srm_waitForScan") && ((value = srmParameters.get("srm_waitForScan").toString().trim()).equals("true") || value.equals("false"))) {
            srm.setWaitForScan(Boolean.parseBoolean(value));
        }
    }

    public Project prepareProjectObjectForBridge(Map<String, Object> srmParameters) {
        Project project = null;
        if (srmParameters.containsKey("project_directory")) {
            project = new Project();
            String projectDirectory = srmParameters.get("project_directory").toString().trim();
            project.setDirectory(projectDirectory);
        }
        return project;
    }
}

