/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.service.scan.polaris;

import hudson.EnvVars;
import hudson.model.TaskListener;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.Utility;
import io.jenkins.plugins.security.scan.global.enums.SecurityProduct;
import io.jenkins.plugins.security.scan.input.polaris.Parent;
import io.jenkins.plugins.security.scan.input.polaris.Polaris;
import io.jenkins.plugins.security.scan.input.polaris.Prcomment;
import io.jenkins.plugins.security.scan.input.polaris.Sast;
import io.jenkins.plugins.security.scan.input.polaris.Sca;
import io.jenkins.plugins.security.scan.input.polaris.Test;
import io.jenkins.plugins.security.scan.input.project.Project;
import io.jenkins.plugins.security.scan.input.project.Source;
import io.jenkins.plugins.security.scan.input.report.File;
import io.jenkins.plugins.security.scan.input.report.Issue;
import io.jenkins.plugins.security.scan.input.report.Reports;
import io.jenkins.plugins.security.scan.input.report.Sarif;
import io.jenkins.plugins.security.scan.service.scm.RepositoryDetailsHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PolarisParametersService {
    private final LoggerWrapper logger;
    private final EnvVars envVars;

    public PolarisParametersService(TaskListener listener, EnvVars envVars) {
        this.logger = new LoggerWrapper(listener);
        this.envVars = envVars;
    }

    public boolean hasAllMandatoryCoverityParams(Map<String, Object> polarisParameters) {
        if (polarisParameters == null || polarisParameters.isEmpty()) {
            return false;
        }
        List<String> missingMandatoryParams = this.getPolarisMissingMandatoryParams(polarisParameters);
        if (missingMandatoryParams.isEmpty()) {
            this.logger.info("Polaris parameters are validated successfully", new Object[0]);
            return true;
        }
        this.logger.error("%s - required parameters for %s is missing", missingMandatoryParams.toString(), SecurityProduct.POLARIS.getProductLabel());
        return false;
    }

    private List<String> getPolarisMissingMandatoryParams(Map<String, Object> polarisParameters) {
        ArrayList<String> missingMandatoryParams = new ArrayList<String>();
        Arrays.asList("polaris_server_url", "polaris_access_token", "polaris_assessment_types").forEach(key -> {
            boolean isKeyValid;
            boolean bl = isKeyValid = polarisParameters.containsKey(key) && polarisParameters.get(key) != null && !polarisParameters.get(key).toString().isEmpty();
            if (!isKeyValid) {
                missingMandatoryParams.add((String)key);
            }
        });
        String jobType = Utility.jenkinsJobType(this.envVars);
        if (!jobType.equalsIgnoreCase("WorkflowMultiBranchProject")) {
            missingMandatoryParams.addAll(this.getPolarisMissingMandatoryParamsForFreeStyleAndPipeline(polarisParameters));
        }
        this.showErrorMessageForJobType(missingMandatoryParams, jobType);
        return missingMandatoryParams;
    }

    private void showErrorMessageForJobType(List<String> missingMandatoryParams, String jobType) {
        if (!missingMandatoryParams.isEmpty()) {
            String jobTypeName = jobType.equalsIgnoreCase("FreeStyleProject") ? "FreeStyle" : (jobType.equalsIgnoreCase("WorkflowMultiBranchProject") ? "Multibranch Pipeline" : "Pipeline");
            this.logger.error("%s - required parameters for %s job type is missing", missingMandatoryParams, jobTypeName);
        }
    }

    private List<String> getPolarisMissingMandatoryParamsForFreeStyleAndPipeline(Map<String, Object> polarisParameters) {
        ArrayList<String> missingParamsForFreeStyleAndPipeline = new ArrayList<String>();
        Arrays.asList("polaris_application_name", "polaris_project_name", "polaris_branch_name").forEach(key -> {
            boolean isKeyValid;
            boolean bl = isKeyValid = polarisParameters.containsKey(key) && polarisParameters.get(key) != null && !polarisParameters.get(key).toString().isEmpty();
            if (!isKeyValid) {
                missingParamsForFreeStyleAndPipeline.add((String)key);
            }
        });
        return missingParamsForFreeStyleAndPipeline;
    }

    public Polaris preparePolarisObjectForBridge(Map<String, Object> polarisParameters) {
        Polaris polaris = new Polaris();
        Prcomment prcomment = new Prcomment();
        this.setServerUrl(polarisParameters, polaris);
        this.setAccessToken(polarisParameters, polaris);
        this.setAssessmentTypes(polarisParameters, polaris);
        this.setApplicationName(polarisParameters, polaris);
        this.setProjectName(polarisParameters, polaris);
        this.setBranchName(polarisParameters, polaris);
        this.setTestScaTypeAndSastType(polarisParameters, polaris);
        this.setTestScaTypeLocationAndSastTypeLocation(polarisParameters, polaris);
        this.setPolarisPrCommentInputs(polarisParameters, prcomment, polaris);
        this.setAssessmentMode(polarisParameters, polaris);
        this.setWaitForScan(polarisParameters, polaris);
        this.setSarif(polarisParameters, polaris);
        return polaris;
    }

    private void setServerUrl(Map<String, Object> polarisParameters, Polaris polaris) {
        if (polarisParameters.containsKey("polaris_server_url")) {
            polaris.setServerUrl(polarisParameters.get("polaris_server_url").toString().trim());
        }
    }

    private void setAccessToken(Map<String, Object> polarisParameters, Polaris polaris) {
        if (polarisParameters.containsKey("polaris_access_token")) {
            polaris.setAccessToken(polarisParameters.get("polaris_access_token").toString().trim());
        }
    }

    private void setAssessmentTypes(Map<String, Object> polarisParameters, Polaris polaris) {
        String assessmentTypesValue;
        if (polarisParameters.containsKey("polaris_assessment_types") && !(assessmentTypesValue = polarisParameters.get("polaris_assessment_types").toString().trim()).isEmpty()) {
            List<String> assessmentTypes = Stream.of(assessmentTypesValue.toUpperCase().split(",")).map(String::trim).collect(Collectors.toList());
            polaris.getAssessmentTypes().setTypes(assessmentTypes);
        }
    }

    private void setApplicationName(Map<String, Object> polarisParameters, Polaris polaris) {
        if (polarisParameters.containsKey("polaris_application_name")) {
            polaris.getApplicationName().setName(polarisParameters.get("polaris_application_name").toString().trim());
        } else {
            String repoName = RepositoryDetailsHolder.getRepositoryName();
            polaris.getApplicationName().setName(repoName);
            this.logger.info("Polaris Application Name: " + repoName, new Object[0]);
        }
    }

    private void setProjectName(Map<String, Object> polarisParameters, Polaris polaris) {
        if (polarisParameters.containsKey("polaris_project_name")) {
            polaris.getPolarisProject().setName(polarisParameters.get("polaris_project_name").toString().trim());
        } else {
            String repoName = RepositoryDetailsHolder.getRepositoryName();
            polaris.getPolarisProject().setName(repoName);
            this.logger.info("Polaris Project Name: " + repoName, new Object[0]);
        }
    }

    private void setBranchName(Map<String, Object> polarisParameters, Polaris polaris) {
        if (polarisParameters.containsKey("polaris_branch_name")) {
            polaris.getBranch().setName(polarisParameters.get("polaris_branch_name").toString().trim());
        } else {
            boolean isPullRequest = this.envVars.get((Object)"CHANGE_ID") != null;
            String branchName = isPullRequest ? (String)this.envVars.get((Object)"CHANGE_BRANCH") : (String)this.envVars.get((Object)"BRANCH_NAME");
            polaris.getBranch().setName(branchName);
            this.logger.info("Polaris Branch Name: " + branchName, new Object[0]);
        }
    }

    private void setTestScaTypeAndSastType(Map<String, Object> polarisParameters, Polaris polaris) {
        Test test = new Test();
        if (polarisParameters.containsKey("polaris_test_sca_type")) {
            Sca sca = new Sca();
            sca.setType(polarisParameters.get("polaris_test_sca_type").toString().trim());
            test.setSca(sca);
            polaris.setTest(test);
        }
        if (polarisParameters.containsKey("polaris_test_sast_type")) {
            Sast sast = new Sast();
            String testSastTypeValue = polarisParameters.get("polaris_test_sast_type").toString().trim();
            if (!testSastTypeValue.isEmpty()) {
                List<String> testSastType = Stream.of(testSastTypeValue.toUpperCase().split(",")).map(String::trim).collect(Collectors.toList());
                sast.setType(testSastType);
                test.setSast(sast);
                polaris.setTest(test);
            }
        }
    }

    private void setTestScaTypeLocationAndSastTypeLocation(Map<String, Object> polarisParameters, Polaris polaris) {
        Test test = polaris.getTest() != null ? polaris.getTest() : new Test();
        boolean scaSet = this.setScaTypeAndLocation(polarisParameters, test);
        boolean sastSet = this.setSastTypeAndLocation(polarisParameters, test);
        if (scaSet || sastSet) {
            polaris.setTest(test);
        }
    }

    private boolean setScaTypeAndLocation(Map<String, Object> polarisParameters, Test test) {
        boolean hasScaType = polarisParameters.containsKey("polaris_test_sca_type");
        boolean hasScaLocation = polarisParameters.containsKey("polaris_test_sca_location");
        if (hasScaType || hasScaLocation) {
            String testScaLocationValue;
            String testScaTypeValue;
            Sca sca;
            Sca sca2 = sca = test.getSca() != null ? test.getSca() : new Sca();
            if (hasScaType && !(testScaTypeValue = polarisParameters.get("polaris_test_sca_type").toString().trim()).isEmpty()) {
                sca.setType(testScaTypeValue);
            }
            if (hasScaLocation && !(testScaLocationValue = polarisParameters.get("polaris_test_sca_location").toString().trim()).isEmpty()) {
                sca.setLocation(testScaLocationValue);
            }
            test.setSca(sca);
            return true;
        }
        return false;
    }

    private boolean setSastTypeAndLocation(Map<String, Object> polarisParameters, Test test) {
        boolean hasSastType = polarisParameters.containsKey("polaris_test_sast_type");
        boolean hasSastLocation = polarisParameters.containsKey("polaris_test_sast_location");
        if (hasSastType || hasSastLocation) {
            String testSastLocationValue;
            String testSastTypeValue;
            Sast sast;
            Sast sast2 = sast = test.getSast() != null ? test.getSast() : new Sast();
            if (hasSastType && !(testSastTypeValue = polarisParameters.get("polaris_test_sast_type").toString().trim()).isEmpty()) {
                List<String> testSastType = Stream.of(testSastTypeValue.toUpperCase().split(",")).map(String::trim).collect(Collectors.toList());
                sast.setType(testSastType);
            }
            if (hasSastLocation && !(testSastLocationValue = polarisParameters.get("polaris_test_sast_location").toString().trim()).isEmpty()) {
                sast.setLocation(testSastLocationValue);
            }
            test.setSast(sast);
            return true;
        }
        return false;
    }

    private void setSarif(Map<String, Object> polarisParameters, Polaris polaris) {
        if (polarisParameters.containsKey("polaris_reports_sarif_create") && this.envVars.get((Object)"CHANGE_ID") == null) {
            Sarif sarif = this.prepareSarifObject(polarisParameters);
            polaris.setReports(new Reports());
            polaris.getReports().setSarif(sarif);
        }
    }

    private void setAssessmentMode(Map<String, Object> polarisParameters, Polaris polaris) {
        String assessmentModeValue;
        if (polarisParameters.containsKey("polaris_assessment_mode") && !(assessmentModeValue = polarisParameters.get("polaris_assessment_mode").toString().trim()).isEmpty()) {
            polaris.getAssessmentTypes().setMode(assessmentModeValue);
        }
    }

    private void setPolarisPrCommentInputs(Map<String, Object> polarisParameters, Prcomment prcomment, Polaris polaris) {
        String isEnabled;
        if (polarisParameters.containsKey("polaris_prComment_enabled") && (isEnabled = polarisParameters.get("polaris_prComment_enabled").toString().trim()).equals("true")) {
            boolean isPullRequestEvent = Utility.isPullRequestEvent(this.envVars);
            if (isPullRequestEvent) {
                prcomment.setEnabled(true);
                PolarisParametersService.handlePrCommentSeverities(polarisParameters, prcomment);
                polaris.setPrcomment(prcomment);
                PolarisParametersService.setBranchParent(polarisParameters, polaris);
            } else {
                this.logger.info("Polaris PR Comment is ignored for non pull request scan", new Object[0]);
            }
        }
    }

    private static void handlePrCommentSeverities(Map<String, Object> polarisParameters, Prcomment prcomment) {
        String prCommentSeveritiesValue;
        if (polarisParameters.containsKey("polaris_prComment_severities") && !(prCommentSeveritiesValue = polarisParameters.get("polaris_prComment_severities").toString().trim()).isEmpty()) {
            List<String> prCommentSeverities = Arrays.stream(prCommentSeveritiesValue.toUpperCase().split(",")).map(String::trim).collect(Collectors.toList());
            prcomment.setSeverities(prCommentSeverities);
        }
    }

    private static void setBranchParent(Map<String, Object> polarisParameters, Polaris polaris) {
        String parentName;
        if (polarisParameters.containsKey("polaris_branch_parent_name") && !(parentName = polarisParameters.get("polaris_branch_parent_name").toString().trim()).isEmpty()) {
            Parent parent = new Parent();
            parent.setName(parentName);
            polaris.getBranch().setParent(parent);
        }
    }

    private void setWaitForScan(Map<String, Object> polarisParameters, Polaris polaris) {
        String value;
        if (polarisParameters.containsKey("polaris_waitForScan") && ((value = polarisParameters.get("polaris_waitForScan").toString().trim()).equals("true") || value.equals("false"))) {
            polaris.setWaitForScan(Boolean.parseBoolean(value));
        }
    }

    public Project prepareProjectObjectForBridge(Map<String, Object> polarisParameters) {
        Project project = null;
        Source source = null;
        boolean hasProjectDirectory = polarisParameters.containsKey("project_directory");
        boolean hasSourceArchive = polarisParameters.containsKey("project_source_archive");
        boolean hasPreserveSymLinks = polarisParameters.containsKey("project_source_preserveSymLinks");
        boolean hasSourceExcludes = polarisParameters.containsKey("project_source_excludes");
        if (hasProjectDirectory || hasSourceArchive || hasPreserveSymLinks || hasSourceExcludes) {
            String sourceExcludesValue;
            project = new Project();
            source = new Source();
            if (hasProjectDirectory) {
                String projectDirectory = polarisParameters.get("project_directory").toString().trim();
                project.setDirectory(projectDirectory);
            }
            if (hasSourceArchive) {
                String archive = polarisParameters.get("project_source_archive").toString().trim();
                source.setArchive(archive);
                project.setSource(source);
            }
            if (hasPreserveSymLinks) {
                Boolean preserveSymLinks = (Boolean)polarisParameters.get("project_source_preserveSymLinks");
                source.setPreserveSymLinks(preserveSymLinks);
                project.setSource(source);
            }
            if (hasSourceExcludes && !(sourceExcludesValue = polarisParameters.get("project_source_excludes").toString().trim()).isEmpty()) {
                List<String> sourceExcludes = Stream.of(sourceExcludesValue.split(",")).map(String::trim).collect(Collectors.toList());
                source.setExcludes(sourceExcludes);
                project.setSource(source);
            }
        }
        return project;
    }

    public Sarif prepareSarifObject(Map<String, Object> sarifParameters) {
        String reports_sarif_issue_types;
        String[] reports_sarif_issue_typesInput;
        List<String> issueTypes;
        String reports_sarif_severities;
        String[] reports_sarif_severitiesInput;
        List<String> severities;
        String reports_sarif_file_path;
        boolean shouldCreateSarifInDefaultPath;
        Sarif sarif = new Sarif();
        boolean bl = shouldCreateSarifInDefaultPath = sarifParameters.containsKey("polaris_reports_sarif_create") && !sarifParameters.containsKey("polaris_reports_sarif_file_path");
        if (sarifParameters.containsKey("polaris_reports_sarif_create")) {
            Boolean isReports_sarif_create = (Boolean)sarifParameters.get("polaris_reports_sarif_create");
            sarif.setCreate(isReports_sarif_create);
        }
        if (sarifParameters.containsKey("polaris_reports_sarif_file_path") && (reports_sarif_file_path = (String)sarifParameters.get("polaris_reports_sarif_file_path")) != null) {
            sarif.setFile(new File());
            sarif.getFile().setPath(reports_sarif_file_path);
        }
        if (shouldCreateSarifInDefaultPath) {
            sarif.setFile(new File());
            sarif.getFile().setPath(".blackduck/integrations/polaris/sarif/report.sarif.json");
        }
        if (sarifParameters.containsKey("polaris_reports_sarif_severities") && !(severities = Arrays.stream(reports_sarif_severitiesInput = (reports_sarif_severities = (String)sarifParameters.get("polaris_reports_sarif_severities")).toUpperCase().split(",")).map(String::trim).collect(Collectors.toList())).isEmpty()) {
            sarif.setSeverities(severities);
        }
        if (sarifParameters.containsKey("polaris_reports_sarif_groupSCAIssues")) {
            Boolean reports_sarif_groupSCAIssues = (Boolean)sarifParameters.get("polaris_reports_sarif_groupSCAIssues");
            sarif.setGroupSCAIssues(reports_sarif_groupSCAIssues);
        }
        if (sarifParameters.containsKey("polaris_reports_sarif_issue_types") && !(issueTypes = Arrays.stream(reports_sarif_issue_typesInput = (reports_sarif_issue_types = (String)sarifParameters.get("polaris_reports_sarif_issue_types")).toUpperCase().split(",")).map(String::trim).collect(Collectors.toList())).isEmpty()) {
            sarif.setIssue(new Issue());
            sarif.getIssue().setTypes(issueTypes);
        }
        return sarif;
    }
}

