/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.service.scan.blackducksca;

import io.jenkins.plugins.security.scan.global.enums.SecurityProduct;
import io.jenkins.plugins.security.scan.input.blackducksca.Install;
import io.jenkins.plugins.security.scan.input.detect.Config;
import io.jenkins.plugins.security.scan.input.detect.Detect;
import io.jenkins.plugins.security.scan.input.detect.Download;
import io.jenkins.plugins.security.scan.input.detect.Execution;
import io.jenkins.plugins.security.scan.input.detect.Search;
import java.util.Map;

public class DetectParametersService {
    public Detect prepareDetectObject(Map<String, Object> detectParameters) {
        Detect detect = null;
        String securityPlatform = (String)detectParameters.get("product");
        detect = this.setInstallDirectory(detectParameters, detect);
        detect = this.setDownloadUrl(detectParameters, detect);
        detect = this.setSearchDepth(detectParameters, detect);
        detect = this.setConfigPath(detectParameters, detect);
        detect = this.setBlackDuckArgs(detectParameters, detect);
        if (SecurityProduct.SRM.name().equalsIgnoreCase(securityPlatform)) {
            detect = this.setExecutionPath(detectParameters, detect);
        }
        return detect;
    }

    private Detect setInstallDirectory(Map<String, Object> scanParameters, Detect detect) {
        String value;
        if (scanParameters.containsKey("detect_install_directory") && !(value = scanParameters.get("detect_install_directory").toString().trim()).isBlank()) {
            if (detect == null) {
                detect = new Detect();
            }
            Install install = new Install();
            install.setDirectory(value);
            detect.setInstall(install);
        }
        return detect;
    }

    private Detect setDownloadUrl(Map<String, Object> scanParameters, Detect detect) {
        String value;
        if (scanParameters.containsKey("detect_download_url") && !(value = scanParameters.get("detect_download_url").toString().trim()).isBlank()) {
            if (detect == null) {
                detect = new Detect();
            }
            Download download = new Download();
            download.setUrl(value);
            detect.setDownload(download);
        }
        return detect;
    }

    private Detect setSearchDepth(Map<String, Object> scanParameters, Detect detect) {
        String searchDepth;
        if (scanParameters.containsKey("detect_search_depth") && !(searchDepth = scanParameters.get("detect_search_depth").toString().trim()).isBlank()) {
            if (detect == null) {
                detect = new Detect();
            }
            Search search = new Search();
            search.setDepth(Integer.parseInt(searchDepth));
            detect.setSearch(search);
        }
        return detect;
    }

    private Detect setConfigPath(Map<String, Object> scanParameters, Detect detect) {
        String configPath;
        if (scanParameters.containsKey("detect_config_path") && !(configPath = scanParameters.get("detect_config_path").toString().trim()).isBlank()) {
            if (detect == null) {
                detect = new Detect();
            }
            Config config = new Config();
            config.setPath(configPath);
            detect.setConfig(config);
        }
        return detect;
    }

    private Detect setBlackDuckArgs(Map<String, Object> scanParameters, Detect detect) {
        String detectArgs;
        if (scanParameters.containsKey("detect_args") && !(detectArgs = scanParameters.get("detect_args").toString().trim()).isBlank()) {
            if (detect == null) {
                detect = new Detect();
            }
            detect.setArgs(detectArgs);
        }
        return detect;
    }

    private Detect setExecutionPath(Map<String, Object> scanParameters, Detect detect) {
        String installationPath;
        if (scanParameters.containsKey("detect_execution_path") && !(installationPath = scanParameters.get("detect_execution_path").toString().trim()).isBlank()) {
            if (detect == null) {
                detect = new Detect();
            }
            Execution execution = new Execution();
            execution.setPath(installationPath);
            detect.setExecution(execution);
        }
        return detect;
    }
}

