/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.service.scan;

import hudson.EnvVars;
import hudson.model.TaskListener;
import io.jenkins.plugins.security.scan.exception.PluginExceptionHandler;
import io.jenkins.plugins.security.scan.global.enums.SecurityProduct;
import io.jenkins.plugins.security.scan.service.scan.blackducksca.BlackDuckSCAParametersService;
import io.jenkins.plugins.security.scan.service.scan.coverity.CoverityParametersService;
import io.jenkins.plugins.security.scan.service.scan.polaris.PolarisParametersService;
import io.jenkins.plugins.security.scan.service.scan.srm.SRMParametersService;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ScanParametersService {
    private final TaskListener listener;

    public ScanParametersService(TaskListener listener) {
        this.listener = listener;
    }

    public boolean performScanParameterValidation(Map<String, Object> scanParameters, EnvVars envVars) throws PluginExceptionHandler {
        SRMParametersService srmParametersService;
        PolarisParametersService polarisParametersService;
        CoverityParametersService coverityParametersService;
        BlackDuckSCAParametersService blackDuckSCAParametersService;
        Set<String> securityProducts = this.getSecurityProducts(scanParameters);
        if ((securityProducts.contains(SecurityProduct.BLACKDUCK.name()) || securityProducts.contains(SecurityProduct.BLACKDUCKSCA.name())) && !(blackDuckSCAParametersService = new BlackDuckSCAParametersService(this.listener, envVars)).hasAllMandatoryBlackduckSCAParams(scanParameters)) {
            throw new PluginExceptionHandler(102);
        }
        if (securityProducts.contains(SecurityProduct.COVERITY.name()) && !(coverityParametersService = new CoverityParametersService(this.listener, envVars)).hasAllMandatoryCoverityParams(scanParameters)) {
            throw new PluginExceptionHandler(103);
        }
        if (securityProducts.contains(SecurityProduct.POLARIS.name()) && !(polarisParametersService = new PolarisParametersService(this.listener, envVars)).hasAllMandatoryCoverityParams(scanParameters)) {
            throw new PluginExceptionHandler(104);
        }
        if (securityProducts.contains(SecurityProduct.SRM.name()) && !(srmParametersService = new SRMParametersService(this.listener, envVars)).hasAllMandatorySrmParams(scanParameters)) {
            throw new PluginExceptionHandler(116);
        }
        return true;
    }

    public Set<String> getSecurityProducts(Map<String, Object> scanParameters) {
        String securityPlatform = (String)scanParameters.get("product");
        return Arrays.stream(securityPlatform.split(",")).map(String::trim).map(String::toUpperCase).collect(Collectors.toSet());
    }
}

