/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.service.diagnostics;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.enums.ReportType;

public class UploadReportService {
    private final Run<?, ?> run;
    private final TaskListener listener;
    private final LoggerWrapper logger;
    private final Launcher launcher;
    private final EnvVars envVars;
    private final ArtifactArchiver artifactArchiver;

    public UploadReportService(Run<?, ?> run, TaskListener listener, Launcher launcher, EnvVars envVars, ArtifactArchiver artifactArchiver) {
        this.run = run;
        this.listener = listener;
        this.logger = new LoggerWrapper(listener);
        this.launcher = launcher;
        this.envVars = envVars;
        this.artifactArchiver = artifactArchiver;
    }

    public void archiveReports(FilePath reportsPath, ReportType reportType) {
        block3: {
            try {
                FilePath path;
                FilePath filePath = path = reportType == ReportType.SARIF ? reportsPath.getParent() : reportsPath;
                if (path == null) break block3;
                if (path.exists()) {
                    this.logger.info("Archiving " + reportType.name() + " jenkins artifact from: " + reportsPath.getRemote(), new Object[0]);
                    this.artifactArchiver.perform(this.run, path, this.envVars, this.launcher, this.listener);
                    break block3;
                }
                this.logger.error("Archiving %s failed as %s path not found at: %s", reportType.name(), reportType.name(), path.getRemote());
                return;
            }
            catch (Exception e) {
                this.logger.error("An exception occurred while archiving %s in jenkins artifact: %s", reportType.name(), e.getMessage());
                Thread.currentThread().interrupt();
                return;
            }
        }
        this.logger.info(reportType.name() + " archived successfully in jenkins artifact", new Object[0]);
    }
}

