/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.global;

import com.cloudbees.hudson.plugins.folder.Folder;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.cli.NoCheckTrustManager;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.OsArchTask;
import io.jenkins.plugins.security.scan.global.OsNameTask;
import io.jenkins.plugins.security.scan.global.enums.BuildStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import jenkins.model.Jenkins;

public class Utility {
    public static String getDirectorySeparator(FilePath workspace, TaskListener listener) {
        String os = Utility.getAgentOs(workspace, listener);
        if (os != null && os.contains("win")) {
            return "\\";
        }
        return "/";
    }

    public static String getAgentOs(FilePath workspace, TaskListener listener) {
        String os = null;
        LoggerWrapper logger = new LoggerWrapper(listener);
        if (workspace.isRemote()) {
            try {
                os = (String)workspace.act((FilePath.FileCallable)new OsNameTask());
            }
            catch (IOException | InterruptedException e) {
                logger.error("An exception occurred while fetching the OS information for the agent node: %s", e.getMessage());
                Thread.currentThread().interrupt();
            }
        } else {
            os = System.getProperty("os.name").toLowerCase();
        }
        return os;
    }

    public static String getAgentOsArch(FilePath workspace, TaskListener listener) {
        String arch = null;
        LoggerWrapper logger = new LoggerWrapper(listener);
        if (workspace.isRemote()) {
            try {
                arch = (String)workspace.act((FilePath.FileCallable)new OsArchTask());
            }
            catch (IOException | InterruptedException e) {
                logger.error("An exception occurred while fetching the OS architecture information for the agent node: %s", e.getMessage());
                Thread.currentThread().interrupt();
            }
        } else {
            arch = System.getProperty("os.arch").toLowerCase();
        }
        return arch;
    }

    public static void removeFile(String filePath, FilePath workspace, TaskListener listener) {
        LoggerWrapper logger = new LoggerWrapper(listener);
        try {
            FilePath file = new FilePath(workspace.getChannel(), filePath);
            file = file.absolutize();
            if (file.exists()) {
                file.delete();
            }
        }
        catch (IOException | InterruptedException e) {
            logger.error("An exception occurred while deleting file: %s", e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    public static boolean isStringNullOrBlank(String str) {
        return str == null || str.isBlank() || str.equals("null");
    }

    public static HttpURLConnection getHttpURLConnection(URL url, EnvVars envVars, LoggerWrapper logger, Map<String, Object> scanParameters) {
        try {
            if (scanParameters.containsKey("network_ssl_trustAll") && ((Boolean)scanParameters.get("network_ssl_trustAll")).booleanValue()) {
                return Utility.createTrustAllConnection(url, envVars, logger);
            }
            if (scanParameters.containsKey("network_ssl_cert_file")) {
                return Utility.createCertFileConnection(url, envVars, logger, scanParameters);
            }
            return Utility.createDefaultConnection(url, envVars, logger);
        }
        catch (Exception e) {
            logger.error("An exception occurred while getting HttpURLConnection: %s", e.getMessage());
            return null;
        }
    }

    public static HttpURLConnection createTrustAllConnection(URL url, EnvVars envVars, LoggerWrapper logger) throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new NoCheckTrustManager()};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        String proxy = Utility.getProxy(url, envVars, logger);
        if (proxy.equals("NO_PROXY")) {
            return (HttpsURLConnection)url.openConnection(Proxy.NO_PROXY);
        }
        URL proxyURL = new URL(proxy);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyURL.getHost(), proxyURL.getPort())));
        Utility.setDefaultProxyAuthenticator(proxyURL.getUserInfo());
        return connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpURLConnection createCertFileConnection(URL url, EnvVars envVars, LoggerWrapper logger, Map<String, Object> scanParameters) throws Exception {
        String certFilePath = (String)scanParameters.get("network_ssl_cert_file");
        if (Utility.isStringNullOrBlank(certFilePath)) return null;
        File crtFile = new File(certFilePath);
        try (FileInputStream fileInputStream = new FileInputStream(crtFile);){
            Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(fileInputStream);
            TrustManagerFactory defaultTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            defaultTrustManagerFactory.init((KeyStore)null);
            KeyStore customKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            customKeyStore.load(null, null);
            customKeyStore.setCertificateEntry("custom_certificate", certificate);
            TrustManagerFactory customTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            customTrustManagerFactory.init(customKeyStore);
            X509TrustManager combinedTrustManager = Utility.getCombinedTrustManager(defaultTrustManagerFactory, customTrustManagerFactory);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{combinedTrustManager}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            String proxy = Utility.getProxy(url, envVars, logger);
            if (proxy.equals("NO_PROXY")) {
                HttpsURLConnection connection;
                HttpsURLConnection httpsURLConnection = connection = (HttpsURLConnection)url.openConnection(Proxy.NO_PROXY);
                return httpsURLConnection;
            }
            URL proxyURL = new URL(proxy);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyURL.getHost(), proxyURL.getPort())));
            connection.setSSLSocketFactory(sslContext.getSocketFactory());
            Utility.setDefaultProxyAuthenticator(proxyURL.getUserInfo());
            HttpsURLConnection httpsURLConnection = connection;
            return httpsURLConnection;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static X509TrustManager getCombinedTrustManager(TrustManagerFactory defaultTrustManagerFactory, TrustManagerFactory customTrustManagerFactory) {
        final X509TrustManager defaultTrustManager = (X509TrustManager)defaultTrustManagerFactory.getTrustManagers()[0];
        final X509TrustManager customTrustManager = (X509TrustManager)customTrustManagerFactory.getTrustManagers()[0];
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                try {
                    defaultTrustManager.checkClientTrusted(chain, authType);
                }
                catch (CertificateException e) {
                    customTrustManager.checkClientTrusted(chain, authType);
                }
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                try {
                    defaultTrustManager.checkServerTrusted(chain, authType);
                }
                catch (CertificateException e) {
                    customTrustManager.checkServerTrusted(chain, authType);
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                X509Certificate[] defaultIssuers = defaultTrustManager.getAcceptedIssuers();
                X509Certificate[] customIssuers = customTrustManager.getAcceptedIssuers();
                X509Certificate[] allIssuers = new X509Certificate[defaultIssuers.length + customIssuers.length];
                System.arraycopy(defaultIssuers, 0, allIssuers, 0, defaultIssuers.length);
                System.arraycopy(customIssuers, 0, allIssuers, defaultIssuers.length, customIssuers.length);
                return allIssuers;
            }
        };
    }

    public static HttpURLConnection createDefaultConnection(URL url, EnvVars envVars, LoggerWrapper logger) throws IOException {
        String proxy = Utility.getProxy(url, envVars, logger);
        if (proxy.equals("NO_PROXY")) {
            return (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
        }
        URL proxyURL = new URL(proxy);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyURL.getHost(), proxyURL.getPort())));
        Utility.setDefaultProxyAuthenticator(proxyURL.getUserInfo());
        return connection;
    }

    public static String getProxy(URL url, EnvVars envVars, LoggerWrapper logger) throws IOException {
        String noProxy = Utility.getEnvOrSystemProxyDetails("NO_PROXY", envVars);
        if (!Utility.isStringNullOrBlank(noProxy)) {
            String[] noProxies;
            logger.info("Found NO_PROXY configuration - " + noProxy, new Object[0]);
            for (String noProxyHost : noProxies = noProxy.split(",")) {
                if (noProxyHost.startsWith("*") && noProxyHost.length() == 1) {
                    return "NO_PROXY";
                }
                if (!noProxyHost.startsWith("*") || noProxyHost.length() <= 2) continue;
                noProxyHost = noProxyHost.substring(2);
                if (!url.toString().contains(noProxyHost)) continue;
                return "NO_PROXY";
            }
        }
        return Utility.getProxyValue(envVars, logger);
    }

    public static String getProxyValue(EnvVars envVars, LoggerWrapper logger) throws MalformedURLException {
        String httpsProxy = Utility.getEnvOrSystemProxyDetails("HTTPS_PROXY", envVars);
        if (!Utility.isStringNullOrBlank(httpsProxy)) {
            logger.info("Found HTTPS_PROXY configuration - " + Utility.getMaskedProxyUrl(httpsProxy), new Object[0]);
            return httpsProxy;
        }
        String httpProxy = Utility.getEnvOrSystemProxyDetails("HTTP_PROXY", envVars);
        if (!Utility.isStringNullOrBlank(httpProxy)) {
            logger.info("Found HTTP_PROXY configuration - " + Utility.getMaskedProxyUrl(httpProxy), new Object[0]);
            return httpProxy;
        }
        return "NO_PROXY";
    }

    public static String getEnvOrSystemProxyDetails(String proxyType, EnvVars envVars) {
        String proxyDetails = (String)envVars.get((Object)proxyType);
        if (Utility.isStringNullOrBlank(proxyDetails)) {
            proxyDetails = (String)envVars.get((Object)proxyType.toLowerCase());
        }
        if (Utility.isStringNullOrBlank(proxyDetails)) {
            proxyDetails = System.getenv(proxyType);
        }
        if (Utility.isStringNullOrBlank(proxyDetails)) {
            proxyDetails = System.getenv(proxyType.toLowerCase());
        }
        return proxyDetails;
    }

    public static void setDefaultProxyAuthenticator(String userInfo) {
        String[] userInfoArray;
        if (!Utility.isStringNullOrBlank(userInfo) && (userInfoArray = userInfo.split(":")).length == 2) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(userInfoArray[0], userInfoArray[1].toCharArray());
                }
            });
        }
    }

    private static String getMaskedProxyUrl(String proxyUrlString) throws MalformedURLException {
        URL proxyUrl = new URL(proxyUrlString);
        String userInfo = proxyUrl.getUserInfo();
        if (!Utility.isStringNullOrBlank(userInfo) && userInfo.split(":").length > 1) {
            return proxyUrlString.replace(userInfo.split(":")[1], "*****");
        }
        return proxyUrlString;
    }

    public static Map<String, Boolean> installedBranchSourceDependencies() {
        HashMap<String, Boolean> installedBranchSourceDependencies = new HashMap<String, Boolean>();
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            if (jenkins.getPlugin("cloudbees-bitbucket-branch-source") != null) {
                installedBranchSourceDependencies.put("cloudbees-bitbucket-branch-source", true);
            }
            if (jenkins.getPlugin("github-branch-source") != null) {
                installedBranchSourceDependencies.put("github-branch-source", true);
            }
            if (jenkins.getPlugin("gitlab-branch-source") != null) {
                installedBranchSourceDependencies.put("gitlab-branch-source", true);
            }
        }
        return installedBranchSourceDependencies;
    }

    public static String jenkinsJobType(EnvVars envVars) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        String jobName = (String)envVars.get((Object)"JOB_NAME");
        if (jobName != null) {
            TopLevelItem actualItem;
            TopLevelItem item;
            String jobNameForMultibranchProject = jobName.contains("/") ? jobName.substring(0, jobName.lastIndexOf(47)) : jobName;
            TopLevelItem topLevelItem = item = jenkins != null ? (TopLevelItem)jenkins.getItemByFullName(jobNameForMultibranchProject, TopLevelItem.class) : null;
            if (item instanceof Folder && jenkins != null && (actualItem = (TopLevelItem)jenkins.getItemByFullName(jobName, TopLevelItem.class)) != null) {
                item = actualItem;
            }
            if (item != null) {
                return item.getClass().getSimpleName();
            }
        }
        return "UnknownJobType";
    }

    public static String getCustomSarifReportFilePath(Map<String, Object> scanParams, boolean isBlackDuckScan, boolean isPolarisScan) {
        return isBlackDuckScan ? (String)scanParams.get("blackducksca_reports_sarif_file_path") : (isPolarisScan ? (String)scanParams.get("polaris_reports_sarif_file_path") : "");
    }

    public static String getDefaultSarifReportFilePath(boolean isBlackDuckScan, boolean isPolarisScan) {
        String filePath = isBlackDuckScan ? ".blackduck/integrations/blackducksca/sarif/" : (isPolarisScan ? ".blackduck/integrations/polaris/sarif/" : "");
        return filePath + "report.sarif.json";
    }

    public static String determineSARIFReportFilePath(String customSarifReportFilePath, String defaultSarifReportFilePath) {
        return customSarifReportFilePath != null ? customSarifReportFilePath : defaultSarifReportFilePath;
    }

    public static String determineSARIFReportFileName(String customSarifReportFilePath) {
        return customSarifReportFilePath != null ? new File(customSarifReportFilePath).getName() : "report.sarif.json";
    }

    public static boolean isPullRequestEvent(EnvVars envVars) {
        return envVars.get((Object)"CHANGE_ID") != null;
    }

    public static Result getMappedResultForBuildStatus(BuildStatus buildStatus) {
        if (buildStatus.equals((Object)BuildStatus.FAILURE)) {
            return Result.FAILURE;
        }
        if (buildStatus.equals((Object)BuildStatus.UNSTABLE)) {
            return Result.UNSTABLE;
        }
        if (buildStatus.equals((Object)BuildStatus.SUCCESS)) {
            return Result.SUCCESS;
        }
        return null;
    }

    public static String extractVersionFromUrl(String url) {
        if (url == null || url.isEmpty()) {
            return "NA";
        }
        String regex = String.format("/(%s)/", "[0-9.]+[a-zA-Z0-9]*");
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(url);
        String version = matcher.find() ? matcher.group(1) : "NA";
        return version;
    }

    public static JsonNode parseJsonFile(String jsonString) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.readTree(jsonString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isBoolean(String value) {
        return value.equals("true") || value.equals("false");
    }

    public static String resolveSarifReportFilePath(Map<String, Object> scanParams, FilePath workspace, boolean isBlackDuckScan, boolean isPolarisScan, LoggerWrapper logger) {
        String customPath = Utility.getCustomSarifReportFilePath(scanParams, isBlackDuckScan, isPolarisScan);
        if (!Utility.isStringNullOrBlank(customPath)) {
            return customPath;
        }
        return Utility.getDefaultSarifReportFilePath(isBlackDuckScan, isPolarisScan);
    }

    public static boolean isVersionCompatible(String version, String minCompatibleBridgeVersion) {
        Version minCompatibleArmVersion;
        if (version.equals("latest")) {
            return true;
        }
        String numericVersion = Utility.extractNumericVersion(version);
        String numericMinVersion = Utility.extractNumericVersion(minCompatibleBridgeVersion);
        String[] inputVersionSplits = numericVersion.split("\\.");
        String[] minCompatibleArmVersionSplits = numericMinVersion.split("\\.");
        if (inputVersionSplits.length != 3 || minCompatibleArmVersionSplits.length != 3) {
            return false;
        }
        Version inputVersion = new Version(Integer.parseInt(inputVersionSplits[0]), Integer.parseInt(inputVersionSplits[1]), Integer.parseInt(inputVersionSplits[2]), null, null, null);
        return inputVersion.compareTo(minCompatibleArmVersion = new Version(Integer.parseInt(minCompatibleArmVersionSplits[0]), Integer.parseInt(minCompatibleArmVersionSplits[1]), Integer.parseInt(minCompatibleArmVersionSplits[2]), null, null, null)) >= 0;
    }

    public static String extractNumericVersion(String version) {
        Pattern pattern = Pattern.compile("([0-9.]+)");
        Matcher matcher = pattern.matcher(version);
        return matcher.find() ? matcher.group(1) : version;
    }
}

