/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.global;

import hudson.model.TaskListener;

public class LoggerWrapper {
    private final TaskListener listener;

    public LoggerWrapper(TaskListener listener) {
        this.listener = listener;
    }

    private void printMessage(String message) {
        this.listener.getLogger().println("[Security Scan] " + message);
    }

    public void info(String format, Object ... args) {
        String message = args.length == 0 ? format : String.format(format, args);
        this.printMessage("INFO: " + message);
    }

    public void warn(String format, Object ... args) {
        String message = args.length == 0 ? format : String.format(format, args);
        this.printMessage("WARN: " + message);
    }

    public void error(String format, Object ... args) {
        String message = args.length == 0 ? format : String.format(format, args);
        this.printMessage("ERROR: " + message);
    }

    public void println(String format, Object ... args) {
        String message = args.length == 0 ? format : String.format(format, args);
        this.listener.getLogger().println(message);
    }

    public void println() {
        this.listener.getLogger().println();
    }
}

