/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.global;

import java.util.HashMap;
import java.util.Map;

public class ExceptionMessages {
    public static final String NULL_WORKSPACE = "Detect cannot be executed when the workspace is null";

    public static Map<Integer, String> getExitCodeToMessageMap() {
        HashMap<Integer, String> exitCodeToMessage = new HashMap<Integer, String>();
        exitCodeToMessage.put(0, "Security Scan execution is successful");
        exitCodeToMessage.put(1, "Undefined error, check error logs");
        exitCodeToMessage.put(2, "Error from adapter");
        exitCodeToMessage.put(3, "Failed to shutdown the Bridge");
        exitCodeToMessage.put(8, "The config option 'bridge.break' has been set to true");
        exitCodeToMessage.put(9, "Bridge initialization failed");
        exitCodeToMessage.put(101, "Invalid Security Product");
        exitCodeToMessage.put(102, "Invalid Black Duck SCA parameters");
        exitCodeToMessage.put(103, "Invalid Coverity parameters");
        exitCodeToMessage.put(104, "Invalid Polaris parameters");
        exitCodeToMessage.put(116, "Invalid SRM parameters");
        exitCodeToMessage.put(105, "Bridge download parameters are not valid");
        exitCodeToMessage.put(106, "Bridge CLI download failed");
        exitCodeToMessage.put(107, "Bridge CLI download failed and will not retry to download");
        exitCodeToMessage.put(108, "Bridge CLI unzipping failed");
        exitCodeToMessage.put(109, "Bridge CLI could not be found in provided path");
        exitCodeToMessage.put(110, "No Bitbucket token found");
        exitCodeToMessage.put(111, "No GitHub token found");
        exitCodeToMessage.put(112, "No GitLab token found");
        exitCodeToMessage.put(113, "Invalid GitHub repository URL");
        exitCodeToMessage.put(114, "Invalid GitLab repository URL");
        exitCodeToMessage.put(117, "Both network_ssl_cert_file and network_ssl_trustAll are set. Only one of these resources should be set at a time.");
        exitCodeToMessage.put(999, "Undefined plugin error");
        exitCodeToMessage.put(115, "Necessary 'Branch Source Plugin' is not installed in Jenkins instance");
        return exitCodeToMessage;
    }

    public static String getErrorMessage(int exitCode, String undefinedErrorMessage) {
        Object errorMessage = null;
        Map<Integer, String> exitCodeToMessage = ExceptionMessages.getExitCodeToMessageMap();
        if (exitCodeToMessage.containsKey(exitCode)) {
            errorMessage = exitCode == 0 ? exitCodeToMessage.get(exitCode) : (exitCode == 999 ? "Workflow failed! Exit code " + exitCode + ": " + exitCodeToMessage.get(exitCode) + " - " + undefinedErrorMessage : "Workflow failed! Exit code " + exitCode + ": " + exitCodeToMessage.get(exitCode));
        }
        return errorMessage;
    }
}

