/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.extension.global;

import io.jenkins.plugins.security.scan.global.ScanCredentialsHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class AuthenticationSupport {
    private final ScanCredentialsHelper scanCredentialsHelper = new ScanCredentialsHelper();

    public final HttpResponse attemptBlackDuckSCAAuthentication(String blackDuckSCAUrl, String blackDuckSCACredentialsId, int timeoutInSeconds) {
        String blackDuckSCAAuthApi = blackDuckSCAUrl.endsWith("/") ? blackDuckSCAUrl.concat("api/tokens/authenticate") : blackDuckSCAUrl.concat("/").concat("api/tokens/authenticate");
        String blackDuckSCAApiToken = this.scanCredentialsHelper.getApiTokenByCredentialsId(blackDuckSCACredentialsId).orElse(null);
        HttpPost httpPost = new HttpPost(blackDuckSCAAuthApi);
        httpPost.setHeader("Authorization", (Object)("token " + blackDuckSCAApiToken));
        return this.executeRequest((HttpUriRequest)httpPost, timeoutInSeconds);
    }

    public final HttpResponse attemptPolarisAuthentication(String polarisServerUrl, String polarisCredentialsId, int timeoutInSeconds) {
        String polarisAuthApi = polarisServerUrl.endsWith("/") ? polarisServerUrl.concat("api/portfolio/portfolios") : polarisServerUrl.concat("/").concat("api/portfolio/portfolios");
        String polarisAccessToken = this.scanCredentialsHelper.getApiTokenByCredentialsId(polarisCredentialsId).orElse(null);
        HttpGet httpGet = new HttpGet(polarisAuthApi);
        httpGet.setHeader("Api-token", (Object)polarisAccessToken);
        return this.executeRequest((HttpUriRequest)httpGet, timeoutInSeconds);
    }

    public final HttpResponse attemptCoverityAuthentication(String coverityConnectUrl, String coverityCredentialsId, int timeoutInSeconds) {
        String coverityAuthApi = coverityConnectUrl.endsWith("/") ? coverityConnectUrl.concat("api/v2/locales") : coverityConnectUrl.concat("/").concat("api/v2/locales");
        String username = this.scanCredentialsHelper.getUsernameByCredentialsId(coverityCredentialsId).orElse(null);
        String password = this.scanCredentialsHelper.getPasswordByCredentialsId(coverityCredentialsId).orElse(null);
        HttpGet httpGet = new HttpGet(coverityAuthApi);
        if (username != null && password != null) {
            String auth = username + ":" + password;
            String encodedAuth = Base64.encodeBase64String((byte[])auth.getBytes(StandardCharsets.UTF_8));
            httpGet.setHeader("Authorization", (Object)("Basic " + encodedAuth));
        }
        return this.executeRequest((HttpUriRequest)httpGet, timeoutInSeconds);
    }

    public final HttpResponse attemptSrmAuthentication(String srmUrl, String srmCredentialsId, int timeoutInSeconds) {
        String srmAuthApi = srmUrl.endsWith("/") ? srmUrl.concat("srm/api/system-info") : srmUrl.concat("/").concat("srm/api/system-info");
        String srmApiKey = this.scanCredentialsHelper.getApiTokenByCredentialsId(srmCredentialsId).orElse(null);
        HttpGet httpGet = new HttpGet(srmAuthApi);
        httpGet.setHeader("API-Key", (Object)srmApiKey);
        return this.executeRequest((HttpUriRequest)httpGet, timeoutInSeconds);
    }

    public HttpResponse executeRequest(HttpUriRequest httpUriRequest, int timeoutInSeconds) {
        try {
            RequestConfig requestConfig = this.getRequestConfig(timeoutInSeconds);
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
            return httpClient.execute((ClassicHttpRequest)httpUriRequest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RequestConfig getRequestConfig(int timeoutInSeconds) {
        return RequestConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)timeoutInSeconds)).setResponseTimeout(Timeout.ofSeconds((long)timeoutInSeconds)).setConnectionRequestTimeout(Timeout.ofSeconds((long)timeoutInSeconds)).setConnectionKeepAlive((TimeValue)Timeout.ofSeconds((long)timeoutInSeconds)).build();
    }
}

