/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.bridge;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.TaskListener;
import io.jenkins.plugins.security.scan.bridge.BridgeDownloadManager;
import io.jenkins.plugins.security.scan.bridge.BridgeDownloadParameters;
import io.jenkins.plugins.security.scan.exception.PluginExceptionHandler;
import io.jenkins.plugins.security.scan.global.HomeDirectoryTask;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.Utility;
import java.io.IOException;
import java.util.Map;
import jenkins.model.Jenkins;

public class BridgeInstall {
    private final LoggerWrapper logger;
    private final FilePath workspace;
    private final TaskListener listener;
    private final EnvVars envVars;
    private final Map<String, Object> scanParameters;

    public BridgeInstall(FilePath workspace, TaskListener listener, EnvVars envVars, Map<String, Object> scanParameters) {
        this.workspace = workspace;
        this.logger = new LoggerWrapper(listener);
        this.listener = listener;
        this.envVars = envVars;
        this.scanParameters = scanParameters;
    }

    public void installBridgeCLI(FilePath bridgeZipPath, BridgeDownloadParameters bridgeDownloadParameters, Map<String, Object> scanParameters) throws PluginExceptionHandler {
        String bridgeInstallationPath = bridgeDownloadParameters.getBridgeInstallationPath();
        String separator = Utility.getDirectorySeparator(this.workspace, this.listener);
        int lastIndex = bridgeDownloadParameters.getBridgeInstallationPath().lastIndexOf(separator);
        String subFolderName = "";
        if (lastIndex != -1) {
            subFolderName = bridgeInstallationPath.substring(lastIndex + 1);
            bridgeInstallationPath = bridgeInstallationPath.substring(0, lastIndex);
        }
        FilePath bridgeInstallationFilePath = new FilePath(this.workspace.getChannel(), bridgeInstallationPath);
        String osType = subFolderName.substring(subFolderName.lastIndexOf("-") + 1);
        String bridgeCLIDownloadVersion = bridgeDownloadParameters.getBridgeDownloadVersion();
        try {
            if (bridgeZipPath != null && bridgeInstallationFilePath.isDirectory()) {
                FilePath targetFolder = new FilePath(bridgeInstallationFilePath, subFolderName);
                this.handleExistingFolder(targetFolder);
                this.logger.info("Unzipping Bridge CLI zip file from: %s", bridgeZipPath.getRemote());
                bridgeZipPath.unzip(bridgeInstallationFilePath);
                this.logger.info("Bridge CLI installed successfully in: %s", bridgeInstallationFilePath.getRemote());
                this.handlePostUnzipping(targetFolder, bridgeInstallationFilePath, osType, bridgeCLIDownloadVersion, bridgeDownloadParameters);
            }
        }
        catch (IOException | InterruptedException e) {
            this.logger.error("An exception occurred while unzipping Bridge CLI Bundle zip file: %s", e.getMessage());
            Thread.currentThread().interrupt();
            throw new PluginExceptionHandler(108);
        }
        try {
            if (bridgeZipPath != null) {
                bridgeZipPath.delete();
            }
        }
        catch (IOException | InterruptedException e) {
            this.logger.warn("An exception occurred while deleting Bridge CLI Bundle zip file: %s", e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    private void handleExistingFolder(FilePath targetFolder) throws IOException, InterruptedException {
        if (targetFolder.exists()) {
            this.logger.info("Deleting previous Bridge CLI folder: %s", targetFolder.getRemote());
            targetFolder.deleteRecursive();
        }
    }

    private void handlePostUnzipping(FilePath targetFolder, FilePath bridgeInstallationFilePath, String osType, String bridgeCLIDownloadVersion, BridgeDownloadParameters bridgeDownloadParameters) throws IOException, InterruptedException {
        if (!bridgeCLIDownloadVersion.equals("latest")) {
            String expectedFolderName = "bridge-cli-bundle-" + bridgeCLIDownloadVersion + "-" + osType;
            FilePath unzippedFolder = new FilePath(bridgeInstallationFilePath, expectedFolderName);
            if (unzippedFolder.exists()) {
                if (!targetFolder.exists()) {
                    this.logger.info("Renaming folder %s to %s", unzippedFolder.getRemote(), targetFolder.getRemote());
                    unzippedFolder.renameTo(targetFolder);
                }
            } else {
                this.logger.warn("Expected folder '%s' not found after unzipping.", expectedFolderName);
            }
        } else {
            String installedBridgeVersionFilePath = osType.contains("win") ? String.join((CharSequence)"\\", targetFolder.getRemote(), "versions.txt") : String.join((CharSequence)"/", targetFolder.getRemote(), "versions.txt");
            BridgeDownloadManager bridgeDownloadManager = new BridgeDownloadManager(this.workspace, this.listener, this.envVars, this.scanParameters);
            String installedBridgeVersion = bridgeDownloadManager.getBridgeVersionFromVersionFile(installedBridgeVersionFilePath);
            bridgeDownloadParameters.setBridgeDownloadVersion(installedBridgeVersion);
        }
    }

    public String defaultBridgeInstallationPath(FilePath workspace, TaskListener listener) {
        this.logger.println("-------------------------------- Connection to node --------------------------------", new Object[0]);
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        String separator = Utility.getDirectorySeparator(workspace, listener);
        String defaultInstallationPath = null;
        if (jenkins != null && workspace.isRemote()) {
            this.logger.info("Jenkins job is running on agent node remotely", new Object[0]);
        } else {
            this.logger.info("Jenkins job is running on master node", new Object[0]);
        }
        try {
            defaultInstallationPath = (String)workspace.act((FilePath.FileCallable)new HomeDirectoryTask(separator));
        }
        catch (IOException | InterruptedException e) {
            this.logger.error("Failed to fetch plugin's default installation path: %s", e.getMessage());
            Thread.currentThread().interrupt();
        }
        return defaultInstallationPath;
    }

    public void verifyAndCreateInstallationPath(String bridgeInstallationPath) {
        FilePath directory = new FilePath(this.workspace.getChannel(), bridgeInstallationPath);
        try {
            if (!directory.exists()) {
                directory.mkdirs();
                this.logger.info("Created bridge installation directory at: " + directory.getRemote(), new Object[0]);
            }
        }
        catch (IOException | InterruptedException e) {
            this.logger.error("Failed to create default installation directory: %s", directory.getRemote());
            Thread.currentThread().interrupt();
        }
    }
}

