/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.bridge;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.TaskListener;
import io.jenkins.plugins.security.scan.bridge.BridgeDownload;
import io.jenkins.plugins.security.scan.bridge.BridgeDownloadParameters;
import io.jenkins.plugins.security.scan.bridge.BridgeInstall;
import io.jenkins.plugins.security.scan.exception.PluginExceptionHandler;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BridgeDownloadManager {
    private final TaskListener listener;
    private final FilePath workspace;
    private final LoggerWrapper logger;
    private final EnvVars envVars;
    private final Map<String, Object> scanParameters;

    public BridgeDownloadManager(FilePath workspace, TaskListener listener, EnvVars envVars, Map<String, Object> scanParameters) {
        this.workspace = workspace;
        this.listener = listener;
        this.logger = new LoggerWrapper(listener);
        this.envVars = envVars;
        this.scanParameters = scanParameters;
    }

    public void initiateBridgeDownloadAndUnzip(BridgeDownloadParameters bridgeDownloadParams) throws PluginExceptionHandler {
        String separator;
        BridgeDownload bridgeDownload = new BridgeDownload(this.workspace, this.listener, this.envVars, this.scanParameters);
        BridgeInstall bridgeInstall = new BridgeInstall(this.workspace, this.listener, this.envVars, this.scanParameters);
        String bridgeDownloadUrl = bridgeDownloadParams.getBridgeDownloadUrl();
        String bridgeInstallationPath = bridgeDownloadParams.getBridgeInstallationPath();
        int lastIndex = bridgeInstallationPath.lastIndexOf(separator = Utility.getDirectorySeparator(this.workspace, this.listener));
        if (lastIndex != -1) {
            bridgeInstallationPath = bridgeInstallationPath.substring(0, lastIndex);
        }
        bridgeInstall.verifyAndCreateInstallationPath(bridgeInstallationPath);
        FilePath bridgeZipPath = bridgeDownload.downloadBridgeCLI(bridgeDownloadUrl, bridgeInstallationPath);
        bridgeInstall.installBridgeCLI(bridgeZipPath, bridgeDownloadParams, this.scanParameters);
    }

    public boolean isBridgeDownloadRequired(BridgeDownloadParameters bridgeDownloadParameters) {
        String bridgeDownloadUrl = bridgeDownloadParameters.getBridgeDownloadUrl();
        String bridgeInstallationPath = bridgeDownloadParameters.getBridgeInstallationPath();
        String os = Utility.getAgentOs(this.workspace, this.listener);
        String installedBridgeVersionFilePath = os.contains("win") ? String.join((CharSequence)"\\", bridgeInstallationPath, "versions.txt") : String.join((CharSequence)"/", bridgeInstallationPath, "versions.txt");
        String installedBridgeVersion = this.getBridgeVersionFromVersionFile(installedBridgeVersionFilePath);
        String latestBridgeVersion = this.getLatestBridgeVersionFromArtifactory(bridgeDownloadUrl);
        return !Objects.equals(installedBridgeVersion, latestBridgeVersion);
    }

    public boolean checkIfBridgeInstalled(String bridgeInstallationPath) {
        try {
            FilePath installationDirectory = new FilePath(this.workspace.getChannel(), bridgeInstallationPath);
            if (installationDirectory.exists() && installationDirectory.isDirectory()) {
                FilePath bridgeBinaryFile = installationDirectory.child("bridge-cli");
                FilePath bridgeBinaryFileWindows = installationDirectory.child("bridge-cli.exe");
                FilePath versionFile = installationDirectory.child("versions.txt");
                return (bridgeBinaryFile.exists() || bridgeBinaryFileWindows.exists()) && versionFile.exists();
            }
        }
        catch (IOException | InterruptedException e) {
            this.logger.error("An exception occurred while checking if the bridge is installed: %s", e.getMessage());
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public String getBridgeVersionFromVersionFile(String versionFilePath) {
        try {
            FilePath file = new FilePath(this.workspace.getChannel(), versionFilePath);
            if (file.exists()) {
                String versionsFileContent = file.readToString();
                String versionPattern = String.format("bridge-cli-bundle: (%s)", "[0-9.]+[a-zA-Z0-9]*");
                Matcher matcher = Pattern.compile(versionPattern).matcher(versionsFileContent);
                if (matcher.find()) {
                    return matcher.group(1);
                }
            }
        }
        catch (IOException | InterruptedException e) {
            this.logger.error("An exception occurred while extracting bridge-version from the 'versions.txt': %s", e.getMessage());
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public String getLatestBridgeVersionFromArtifactory(String bridgeDownloadUrl) {
        if (Utility.isStringNullOrBlank(bridgeDownloadUrl)) {
            return "NA";
        }
        String extractedVersionNumber = Utility.extractVersionFromUrl(bridgeDownloadUrl);
        if (extractedVersionNumber.equals("NA")) {
            String directoryUrl = this.getDirectoryUrl(bridgeDownloadUrl);
            if (this.isVersionFileAvailableInArtifactory(directoryUrl)) {
                String versionFilePath = this.downloadVersionFileFromArtifactory(directoryUrl);
                String latestVersion = this.getBridgeVersionFromVersionFile(versionFilePath);
                Utility.removeFile(versionFilePath, this.workspace, this.listener);
                return latestVersion;
            }
            return "NA";
        }
        return extractedVersionNumber;
    }

    public String downloadVersionFileFromArtifactory(String directoryUrl) {
        String tempVersionFilePath;
        block8: {
            String versionFileUrl = String.join((CharSequence)"/", directoryUrl, "versions.txt");
            tempVersionFilePath = null;
            try {
                FilePath tempFilePath = this.workspace.createTempFile("versions", ".txt");
                URL url = new URL(versionFileUrl);
                HttpURLConnection connection = Utility.getHttpURLConnection(url, this.envVars, this.logger, this.scanParameters);
                if (connection == null) break block8;
                try (InputStream inputStream = connection.getInputStream();){
                    tempFilePath.copyFrom(inputStream);
                }
                tempVersionFilePath = tempFilePath.getRemote();
            }
            catch (IOException | InterruptedException e) {
                this.logger.error("An exception occurred while downloading 'versions.txt': %s", e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
        return tempVersionFilePath;
    }

    public boolean isVersionFileAvailableInArtifactory(String directoryUrl) {
        try {
            URL url = new URL(String.join((CharSequence)"/", directoryUrl, "versions.txt"));
            HttpURLConnection connection = Utility.getHttpURLConnection(url, this.envVars, this.logger, this.scanParameters);
            if (connection != null) {
                connection.setRequestMethod("HEAD");
                return connection.getResponseCode() >= 200 && connection.getResponseCode() < 300;
            }
        }
        catch (IOException e) {
            this.logger.warn("An exception occurred while checking if 'versions.txt' is available or not in the URL: %s", e.getMessage());
        }
        return false;
    }

    public String getDirectoryUrl(String downloadUrl) {
        String directoryUrl = null;
        try {
            URI uri = new URI(downloadUrl);
            String path = uri.getPath();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            String directoryPath = path.substring(0, path.lastIndexOf(47));
            directoryUrl = uri.getScheme().concat("://").concat(uri.getAuthority()).concat(directoryPath);
        }
        catch (URISyntaxException e) {
            this.logger.warn("An exception occurred while getting directoryUrl from downloadUrl: %s", e.getMessage());
        }
        return directoryUrl;
    }
}

