/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.action;

import hudson.model.Action;
import java.util.HashMap;
import java.util.Map;

public class IssueAction
implements Action {
    private final String product;
    private final int defectCount;
    private final String issueViewUrl;
    private static final Map<String, String> PRODUCT_NAME_MAP = new HashMap<String, String>();

    public IssueAction(String product, int defectCount, String issueViewUrl) {
        this.product = product;
        this.defectCount = defectCount;
        this.issueViewUrl = issueViewUrl;
    }

    public String getIconFileName() {
        return "/plugin/blackduck-security-scan/icons/blackduck.png";
    }

    public String getDisplayName() {
        return String.format("See %d issues in %s", this.defectCount, this.getDisplayNameForProduct(this.product));
    }

    public String getUrlName() {
        return this.issueViewUrl;
    }

    private String getDisplayNameForProduct(String product) {
        return PRODUCT_NAME_MAP.getOrDefault(product.toLowerCase(), product);
    }

    static {
        PRODUCT_NAME_MAP.put("blackducksca", "Black Duck SCA");
        PRODUCT_NAME_MAP.put("polaris", "Polaris");
        PRODUCT_NAME_MAP.put("srm", "SRM");
        PRODUCT_NAME_MAP.put("coverity", "Coverity");
    }
}

