/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.service.scm.gitlab;

import hudson.model.TaskListener;
import io.jenkins.plugins.security.scan.exception.PluginExceptionHandler;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.Utility;
import io.jenkins.plugins.security.scan.input.scm.common.Pull;
import io.jenkins.plugins.security.scan.input.scm.gitlab.Api;
import io.jenkins.plugins.security.scan.input.scm.gitlab.Gitlab;
import io.jenkins.plugins.security.scan.service.ToolsParameterService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class GitlabRepositoryService {
    private final LoggerWrapper logger;
    public static final String GITLAB_CLOUD_HOST_URL = "https://gitlab.com/";
    private String INVALID_GITLAB_REPO_URL = "Invalid Gitlab repository URL";

    public GitlabRepositoryService(TaskListener listener) {
        this.logger = new LoggerWrapper(listener);
    }

    public Gitlab createGitlabObject(Map<String, Object> scanParameters, String repositoryName, Integer projectRepositoryPullNumber, String branchName, String repositoryUrl) throws PluginExceptionHandler {
        String gitlabToken = (String)scanParameters.get("gitlab_token");
        boolean isPrCommentSet = ToolsParameterService.isPrCommentValueSet(scanParameters);
        boolean isFixPrValueSet = ToolsParameterService.isFixPrValueSet(scanParameters);
        if (isPrCommentSet && Utility.isStringNullOrBlank(gitlabToken)) {
            this.logger.error("PrComment is set true but no %s token found!", "GitLab");
            throw new PluginExceptionHandler(112);
        }
        if (isFixPrValueSet && Utility.isStringNullOrBlank(gitlabToken)) {
            this.logger.error("FixPr is set true but no %s token found!", "GitLab");
            throw new PluginExceptionHandler(112);
        }
        Gitlab gitlab = new Gitlab();
        gitlab.getUser().setToken(gitlabToken);
        gitlab.getRepository().setName(repositoryName);
        gitlab.getRepository().getBranch().setName(branchName);
        Pull pull = new Pull();
        pull.setNumber(projectRepositoryPullNumber);
        gitlab.getRepository().setPull(pull);
        String gitlabHostUrl = this.extractGitlabHost(repositoryUrl);
        if (projectRepositoryPullNumber != null || isFixPrValueSet) {
            this.logger.info("Gitlab repositoryName: " + repositoryName, new Object[0]);
            if (projectRepositoryPullNumber != null) {
                this.logger.info("Gitlab projectRepositoryPullNumber: " + projectRepositoryPullNumber, new Object[0]);
            }
            this.logger.info("Gitlab branchName: " + branchName, new Object[0]);
            this.logger.info("Gitlab gitlabHostUrl: " + gitlabHostUrl, new Object[0]);
        }
        if (gitlabHostUrl.equals(this.INVALID_GITLAB_REPO_URL)) {
            this.logger.error(this.INVALID_GITLAB_REPO_URL, new Object[0]);
            throw new PluginExceptionHandler(114);
        }
        if (!gitlabHostUrl.startsWith(GITLAB_CLOUD_HOST_URL)) {
            gitlab.setApi(new Api());
            gitlab.getApi().setUrl(gitlabHostUrl);
        }
        return gitlab;
    }

    public String extractGitlabHost(String url) {
        try {
            URL gitlabUrl = new URL(url);
            int port = gitlabUrl.getPort();
            return String.format("%s://%s%s/", gitlabUrl.getProtocol(), gitlabUrl.getHost(), port == -1 ? "" : ":" + port);
        }
        catch (MalformedURLException e) {
            return this.INVALID_GITLAB_REPO_URL;
        }
    }
}

