/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.service.scm.github;

import hudson.model.TaskListener;
import io.jenkins.plugins.security.scan.exception.PluginExceptionHandler;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.Utility;
import io.jenkins.plugins.security.scan.input.scm.common.Pull;
import io.jenkins.plugins.security.scan.input.scm.github.Github;
import io.jenkins.plugins.security.scan.input.scm.github.Host;
import io.jenkins.plugins.security.scan.service.ToolsParameterService;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class GithubRepositoryService {
    private final LoggerWrapper logger;
    public static final String GITHUB_CLOUD_HOST_URL = "https://github.com/";
    public static final String GITHUB_CLOUD_API_URI = "https://api.github.com";
    private String INVALID_GITHUB_REPO_URL = "Invalid Github repository URL";

    public GithubRepositoryService(TaskListener listener) {
        this.logger = new LoggerWrapper(listener);
    }

    public Github createGithubObject(Map<String, Object> scanParameters, String repositoryName, String repositoryOwner, Integer projectRepositoryPullNumber, String branchName, String githubApiUri) throws PluginExceptionHandler {
        String githubToken = (String)scanParameters.get("github_token");
        boolean isPrCommentSet = ToolsParameterService.isPrCommentValueSet(scanParameters);
        boolean isFixPrValueSet = ToolsParameterService.isFixPrValueSet(scanParameters);
        if (isPrCommentSet && Utility.isStringNullOrBlank(githubToken)) {
            this.logger.error("PrComment is set true but no %s token found!", "GitHub");
            throw new PluginExceptionHandler(111);
        }
        if (isFixPrValueSet && Utility.isStringNullOrBlank(githubToken)) {
            this.logger.error("FixPr is set true but no %s token found!", "GitHub");
            throw new PluginExceptionHandler(111);
        }
        Github github = new Github();
        github.getUser().setToken(githubToken);
        github.getRepository().setName(repositoryName);
        github.getRepository().getOwner().setName(repositoryOwner);
        Pull pull = new Pull();
        pull.setNumber(projectRepositoryPullNumber);
        github.getRepository().setPull(pull);
        github.getRepository().getBranch().setName(branchName);
        String githubHostUrl = this.extractGitHubHost(githubApiUri);
        if (projectRepositoryPullNumber != null || isFixPrValueSet) {
            this.logger.info("Github repositoryName: " + repositoryName, new Object[0]);
            this.logger.info("Github repositoryOwner: " + repositoryOwner, new Object[0]);
            if (projectRepositoryPullNumber != null) {
                this.logger.info("Github projectRepositoryPullNumber: " + projectRepositoryPullNumber, new Object[0]);
            }
            this.logger.info("Github branchName: " + branchName, new Object[0]);
            this.logger.info("Github githubHostUrl: " + githubHostUrl, new Object[0]);
        }
        if (githubHostUrl.equals(this.INVALID_GITHUB_REPO_URL)) {
            this.logger.error(this.INVALID_GITHUB_REPO_URL, new Object[0]);
            throw new PluginExceptionHandler(113);
        }
        if (!githubHostUrl.startsWith(GITHUB_CLOUD_HOST_URL)) {
            github.setHost(new Host());
            github.getHost().setUrl(githubHostUrl);
        }
        return github;
    }

    public String extractGitHubHost(String githubApiUri) {
        try {
            return GITHUB_CLOUD_API_URI.equals(githubApiUri) ? GITHUB_CLOUD_HOST_URL : String.format("%s", StringUtils.removeEnd((String)githubApiUri, (String)"api/v3"));
        }
        catch (Exception e) {
            return this.INVALID_GITHUB_REPO_URL;
        }
    }
}

