/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.service.scm;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import hudson.EnvVars;
import hudson.model.TaskListener;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.security.scan.exception.PluginExceptionHandler;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.enums.InvokedFrom;
import io.jenkins.plugins.security.scan.input.scm.bitbucket.Bitbucket;
import io.jenkins.plugins.security.scan.input.scm.github.Github;
import io.jenkins.plugins.security.scan.input.scm.gitlab.Gitlab;
import io.jenkins.plugins.security.scan.service.scm.RepositoryDetailsHolder;
import io.jenkins.plugins.security.scan.service.scm.bitbucket.BitbucketRepositoryService;
import io.jenkins.plugins.security.scan.service.scm.github.GithubRepositoryService;
import io.jenkins.plugins.security.scan.service.scm.gitlab.GitlabRepositoryService;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;

public class SCMRepositoryService {
    private final TaskListener listener;
    private final EnvVars envVars;
    private final LoggerWrapper logger;
    private static final String BITBUCKET_CLOUD_URL_PATTERN = "https://.*@?bitbucket\\.org.*";

    public SCMRepositoryService(TaskListener listener, EnvVars envVars) {
        this.listener = listener;
        this.envVars = envVars;
        this.logger = new LoggerWrapper(listener);
    }

    public Object fetchSCMRepositoryDetails(Map<String, Boolean> installedBranchSourceDependencies, Map<String, Object> scanParameters) throws PluginExceptionHandler {
        String pullRequestNumber = (String)this.envVars.get((Object)"CHANGE_ID");
        Integer projectRepositoryPullNumber = pullRequestNumber != null ? Integer.valueOf(Integer.parseInt(pullRequestNumber)) : null;
        String branchName = (String)this.envVars.get((Object)"BRANCH_NAME");
        Object scmObject = null;
        SCMSource scmSource = this.findSCMSource();
        if (installedBranchSourceDependencies.getOrDefault("cloudbees-bitbucket-branch-source", false).booleanValue() && scmSource instanceof BitbucketSCMSource) {
            BitbucketRepositoryService bitbucketRepositoryService = new BitbucketRepositoryService(this.listener);
            BitbucketSCMSource bitbucketSCMSource = (BitbucketSCMSource)scmSource;
            scmObject = bitbucketRepositoryService.fetchBitbucketRepositoryDetails(scanParameters, bitbucketSCMSource, projectRepositoryPullNumber, branchName);
        } else if (installedBranchSourceDependencies.getOrDefault("github-branch-source", false).booleanValue() && scmSource instanceof GitHubSCMSource) {
            GithubRepositoryService githubRepositoryService = new GithubRepositoryService(this.listener);
            GitHubSCMSource gitHubSCMSource = (GitHubSCMSource)scmSource;
            String repositoryOwner = gitHubSCMSource.getRepoOwner();
            String repositoryName = gitHubSCMSource.getRepository();
            String apiUri = gitHubSCMSource.getApiUri();
            scmObject = githubRepositoryService.createGithubObject(scanParameters, repositoryName, repositoryOwner, projectRepositoryPullNumber, branchName, apiUri);
        } else if (installedBranchSourceDependencies.getOrDefault("gitlab-branch-source", false).booleanValue() && scmSource instanceof GitLabSCMSource) {
            GitlabRepositoryService gitlabRepositoryService = new GitlabRepositoryService(this.listener);
            GitLabSCMSource gitLabSCMSource = (GitLabSCMSource)scmSource;
            String repositoryUrl = gitLabSCMSource.getHttpRemote();
            String repositoryName = gitLabSCMSource.getProjectPath();
            scmObject = gitlabRepositoryService.createGitlabObject(scanParameters, repositoryName, projectRepositoryPullNumber, branchName, repositoryUrl);
        }
        this.setRepositoryName(scmObject);
        return scmObject;
    }

    public SCMSource findSCMSource() {
        SCMSourceOwner owner;
        String jobName = (String)this.envVars.get((Object)"JOB_NAME");
        jobName = jobName.contains("/") ? jobName.substring(0, jobName.lastIndexOf(47)) : jobName;
        this.logger.info("Jenkins Job name: " + jobName, new Object[0]);
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        SCMSourceOwner sCMSourceOwner = owner = jenkins != null ? (SCMSourceOwner)jenkins.getItemByFullName(jobName, SCMSourceOwner.class) : null;
        if (owner != null) {
            for (SCMSource scmSource : owner.getSCMSources()) {
                if (owner.getSCMSource(scmSource.getId()) == null) continue;
                return scmSource;
            }
        }
        return null;
    }

    public void setRepositoryName(Object scmObject) {
        String repositoryName = null;
        if (scmObject instanceof Bitbucket) {
            Bitbucket bitbucket = (Bitbucket)scmObject;
            repositoryName = bitbucket.getProject().getRepository().getName();
        } else if (scmObject instanceof Github) {
            Github github = (Github)scmObject;
            repositoryName = github.getRepository().getName();
        } else if (scmObject instanceof Gitlab) {
            Gitlab gitlab = (Gitlab)scmObject;
            String fullName = gitlab.getRepository().getName();
            repositoryName = SCMRepositoryService.extractLastPart(fullName);
        }
        RepositoryDetailsHolder.setRepositoryName(repositoryName);
    }

    private static String extractLastPart(String fullRepoName) {
        int lastSlashIndex;
        if (fullRepoName != null && !fullRepoName.isEmpty() && (lastSlashIndex = fullRepoName.lastIndexOf(47)) != -1 && lastSlashIndex < fullRepoName.length() - 1) {
            return fullRepoName.substring(lastSlashIndex + 1);
        }
        return fullRepoName;
    }

    public InvokedFrom getInvokedFrom(Map<String, Boolean> installedBranchSourceDependencies, String jobType, SCMSource scmSource) {
        InvokedFrom invokedFrom = jobType.equalsIgnoreCase("WorkflowMultiBranchProject") ? this.getInvokedFromForMultiBranchJob(installedBranchSourceDependencies, scmSource) : (jobType.equalsIgnoreCase("FreeStyleProject") ? InvokedFrom.INT_JENKINS_FREESTYLE : InvokedFrom.INT_JENKINS_PIPELINE);
        return invokedFrom;
    }

    private InvokedFrom getInvokedFromForMultiBranchJob(Map<String, Boolean> installedBranchSourceDependencies, SCMSource scmSource) {
        String gitURL = (String)this.envVars.get((Object)"GIT_URL");
        if (this.isBitbucketSource(installedBranchSourceDependencies, scmSource)) {
            return this.determineBitbucketType(gitURL);
        }
        if (this.isGithubSource(installedBranchSourceDependencies, scmSource)) {
            return this.determineGithubType(gitURL);
        }
        if (this.isGitlabSource(installedBranchSourceDependencies, scmSource)) {
            return this.determineGitlabType(gitURL);
        }
        return null;
    }

    private boolean isBitbucketSource(Map<String, Boolean> installedBranchSourceDependencies, SCMSource scmSource) {
        return installedBranchSourceDependencies.getOrDefault("cloudbees-bitbucket-branch-source", false) != false && scmSource instanceof BitbucketSCMSource;
    }

    private InvokedFrom determineBitbucketType(String gitURL) {
        if (gitURL != null && gitURL.matches(BITBUCKET_CLOUD_URL_PATTERN)) {
            return InvokedFrom.INT_BITBUCKET_CLOUD;
        }
        return InvokedFrom.INT_BITBUCKET_EE;
    }

    private boolean isGithubSource(Map<String, Boolean> installedBranchSourceDependencies, SCMSource scmSource) {
        return installedBranchSourceDependencies.getOrDefault("github-branch-source", false) != false && scmSource instanceof GitHubSCMSource;
    }

    private InvokedFrom determineGithubType(String gitURL) {
        if (gitURL != null && gitURL.startsWith("https://github.com/")) {
            return InvokedFrom.INT_GITHUB_CLOUD;
        }
        return InvokedFrom.INT_GITHUB_EE;
    }

    private boolean isGitlabSource(Map<String, Boolean> installedBranchSourceDependencies, SCMSource scmSource) {
        return installedBranchSourceDependencies.getOrDefault("gitlab-branch-source", false) != false && scmSource instanceof GitLabSCMSource;
    }

    private InvokedFrom determineGitlabType(String gitURL) {
        if (gitURL != null && gitURL.startsWith("https://gitlab.com/")) {
            return InvokedFrom.INT_GITLAB_CLOUD;
        }
        return InvokedFrom.INT_GITLAB_EE;
    }
}

