/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.service.scan.coverity;

import hudson.EnvVars;
import hudson.model.TaskListener;
import io.jenkins.plugins.security.scan.bridge.BridgeDownloadParameters;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.Utility;
import io.jenkins.plugins.security.scan.global.enums.SecurityProduct;
import io.jenkins.plugins.security.scan.input.blackducksca.Install;
import io.jenkins.plugins.security.scan.input.coverity.Automation;
import io.jenkins.plugins.security.scan.input.coverity.Build;
import io.jenkins.plugins.security.scan.input.coverity.Clean;
import io.jenkins.plugins.security.scan.input.coverity.Connect;
import io.jenkins.plugins.security.scan.input.coverity.Coverity;
import io.jenkins.plugins.security.scan.input.coverity.Policy;
import io.jenkins.plugins.security.scan.input.coverity.PrComment;
import io.jenkins.plugins.security.scan.input.detect.Config;
import io.jenkins.plugins.security.scan.input.detect.Execution;
import io.jenkins.plugins.security.scan.input.project.Project;
import io.jenkins.plugins.security.scan.service.scm.RepositoryDetailsHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CoverityParametersService {
    private final LoggerWrapper logger;
    private final EnvVars envVars;
    private BridgeDownloadParameters bridgeDownloadParameters;

    public CoverityParametersService(TaskListener listener, EnvVars envVars) {
        this.logger = new LoggerWrapper(listener);
        this.envVars = envVars;
    }

    public CoverityParametersService(TaskListener listener, EnvVars envVars, BridgeDownloadParameters bridgeDownloadParameters) {
        this.logger = new LoggerWrapper(listener);
        this.envVars = envVars;
        this.bridgeDownloadParameters = bridgeDownloadParameters;
    }

    public boolean hasAllMandatoryCoverityParams(Map<String, Object> coverityParameters) {
        if (coverityParameters == null || coverityParameters.isEmpty()) {
            return false;
        }
        List<String> missingMandatoryParams = this.getCoverityMissingMandatoryParams(coverityParameters);
        if (missingMandatoryParams.isEmpty()) {
            this.logger.info("Coverity parameters are validated successfully", new Object[0]);
            return true;
        }
        this.logger.error("%s - required parameters for %s is missing", missingMandatoryParams.toString(), SecurityProduct.COVERITY.getProductLabel());
        return false;
    }

    private List<String> getCoverityMissingMandatoryParams(Map<String, Object> coverityParameters) {
        ArrayList<String> missingMandatoryParams = new ArrayList<String>();
        Arrays.asList("coverity_url", "coverity_user", "coverity_passphrase").forEach(key -> {
            boolean isKeyValid;
            boolean bl = isKeyValid = coverityParameters.containsKey(key) && coverityParameters.get(key) != null && !coverityParameters.get(key).toString().isEmpty();
            if (!isKeyValid) {
                missingMandatoryParams.add((String)key);
            }
        });
        String jobType = Utility.jenkinsJobType(this.envVars);
        if (!jobType.equalsIgnoreCase("WorkflowMultiBranchProject")) {
            missingMandatoryParams.addAll(this.getCoverityMissingMandatoryParamsForFreeStyleAndPipeline(coverityParameters));
        }
        this.showErrorMessageForJobType(missingMandatoryParams, jobType);
        return missingMandatoryParams;
    }

    private void showErrorMessageForJobType(List<String> missingMandatoryParams, String jobType) {
        if (!missingMandatoryParams.isEmpty()) {
            String jobTypeName = jobType.equalsIgnoreCase("FreeStyleProject") ? "FreeStyle" : (jobType.equalsIgnoreCase("WorkflowMultiBranchProject") ? "Multibranch Pipeline" : "Pipeline");
            this.logger.error("%s - required parameters for %s job type is missing", missingMandatoryParams, jobTypeName);
        }
    }

    private List<String> getCoverityMissingMandatoryParamsForFreeStyleAndPipeline(Map<String, Object> coverityParameters) {
        ArrayList<String> missingParamsForFreeStyleAndPipeline = new ArrayList<String>();
        Arrays.asList("coverity_project_name", "coverity_stream_name").forEach(key -> {
            boolean isKeyValid;
            boolean bl = isKeyValid = coverityParameters.containsKey(key) && coverityParameters.get(key) != null && !coverityParameters.get(key).toString().isEmpty();
            if (!isKeyValid) {
                missingParamsForFreeStyleAndPipeline.add((String)key);
            }
        });
        return missingParamsForFreeStyleAndPipeline;
    }

    public Coverity prepareCoverityObjectForBridge(Map<String, Object> coverityParameters) {
        Coverity coverity = new Coverity();
        coverity.setConnect(new Connect());
        this.setUrl(coverityParameters, coverity);
        this.setUser(coverityParameters, coverity);
        this.setPassPhrase(coverityParameters, coverity);
        this.setProjectName(coverityParameters, coverity);
        this.setStreamName(coverityParameters, coverity);
        this.setCoverityPolicyView(coverityParameters, coverity);
        this.setCoverityInstallDirectory(coverityParameters, coverity);
        this.setCoverityPrComment(coverityParameters, coverity);
        this.setVersion(coverityParameters, coverity);
        this.setCoverityLocal(coverityParameters, coverity);
        this.setWaitForScan(coverityParameters, coverity);
        this.setArbitaryInputs(coverityParameters, coverity);
        return coverity;
    }

    private void setProjectName(Map<String, Object> coverityParameters, Coverity coverity) {
        if (coverityParameters.containsKey("coverity_project_name")) {
            coverity.getConnect().getCoverityProject().setName(coverityParameters.get("coverity_project_name").toString().trim());
        } else {
            String repositoryName = RepositoryDetailsHolder.getRepositoryName();
            coverity.getConnect().getCoverityProject().setName(repositoryName);
            this.logger.info("Coverity Project Name: " + repositoryName, new Object[0]);
        }
    }

    private void setStreamName(Map<String, Object> coverityParameters, Coverity coverity) {
        if (coverityParameters.containsKey("coverity_stream_name")) {
            coverity.getConnect().getStream().setName(coverityParameters.get("coverity_stream_name").toString().trim());
        } else {
            String defaultStreamName;
            String repositoryName = RepositoryDetailsHolder.getRepositoryName();
            String branchName = (String)this.envVars.get((Object)"BRANCH_NAME");
            String targetBranchName = (String)this.envVars.get((Object)"CHANGE_TARGET");
            boolean isPullRequest = this.envVars.get((Object)"CHANGE_ID") != null;
            String string = defaultStreamName = isPullRequest ? targetBranchName : branchName;
            if (repositoryName != null && defaultStreamName != null) {
                String coveritySteamName = repositoryName.concat("-").concat(defaultStreamName);
                coverity.getConnect().getStream().setName(coveritySteamName);
                this.logger.info("Coverity Stream Name: " + coveritySteamName, new Object[0]);
            }
        }
    }

    private void setPassPhrase(Map<String, Object> coverityParameters, Coverity coverity) {
        if (coverityParameters.containsKey("coverity_passphrase")) {
            coverity.getConnect().getUser().setPassword(coverityParameters.get("coverity_passphrase").toString().trim());
        }
    }

    private void setUser(Map<String, Object> coverityParameters, Coverity coverity) {
        if (coverityParameters.containsKey("coverity_user")) {
            coverity.getConnect().getUser().setName(coverityParameters.get("coverity_user").toString().trim());
        }
    }

    private void setUrl(Map<String, Object> coverityParameters, Coverity coverity) {
        if (coverityParameters.containsKey("coverity_url")) {
            coverity.getConnect().setUrl(coverityParameters.get("coverity_url").toString().trim());
        }
    }

    private void setVersion(Map<String, Object> coverityParameters, Coverity coverity) {
        if (coverityParameters.containsKey("coverity_version")) {
            coverity.setVersion(coverityParameters.get("coverity_version").toString().trim());
        }
    }

    public Coverity setArbitaryInputs(Map<String, Object> coverityParameters, Coverity coverity) {
        String securityPlatform = (String)coverityParameters.get("product");
        coverity = this.setBuildCommand(coverityParameters, coverity);
        coverity = this.setCleanCommand(coverityParameters, coverity);
        coverity = this.setConfigCommand(coverityParameters, coverity);
        coverity = this.setArgs(coverityParameters, coverity);
        if (SecurityProduct.SRM.name().equalsIgnoreCase(securityPlatform)) {
            coverity = this.setExecutionPath(coverityParameters, coverity);
        }
        return coverity;
    }

    private void setCoverityLocal(Map<String, Object> coverityParameters, Coverity coverity) {
        String value;
        if (coverityParameters.containsKey("coverity_local") && ((value = coverityParameters.get("coverity_local").toString().trim()).equals("true") || value.equals("false"))) {
            coverity.setLocal(Boolean.parseBoolean(value));
        }
    }

    private void setCoverityPrComment(Map<String, Object> coverityParameters, Coverity coverity) {
        String isEnabled;
        if (coverityParameters.containsKey("coverity_prComment_enabled") && (isEnabled = coverityParameters.get("coverity_prComment_enabled").toString().trim()).equals("true")) {
            boolean isPullRequestEvent = Utility.isPullRequestEvent(this.envVars);
            if (isPullRequestEvent) {
                if (Utility.isVersionCompatible(this.bridgeDownloadParameters.getBridgeDownloadVersion(), "3.9.0")) {
                    PrComment prComment = new PrComment();
                    prComment.setEnabled(true);
                    CoverityParametersService.handlePrCommentImpacts(coverityParameters, prComment);
                    coverity.setPrComment(prComment);
                } else {
                    this.logger.info(String.format("Bridge CLI version %s < %s, converting to legacy automation format.", this.bridgeDownloadParameters.getBridgeDownloadVersion(), "3.9.0"), new Object[0]);
                    Automation automation = new Automation();
                    automation.setPrComment(true);
                    coverity.setAutomation(automation);
                    this.logger.info(String.format("Converted Coverity PR comment configuration to legacy format for compatibility with Bridge CLI < %s.", "3.9.0"), new Object[0]);
                }
            } else {
                this.logger.info("Coverity PR Comment is ignored for non pull request scan", new Object[0]);
            }
        }
    }

    private static void handlePrCommentImpacts(Map<String, Object> coverityParameters, PrComment prcomment) {
        String prCommentImpactsValue;
        if (coverityParameters.containsKey("coverity_prComment_impacts") && !(prCommentImpactsValue = coverityParameters.get("coverity_prComment_impacts").toString().trim()).isEmpty()) {
            List<String> prCommentImpacts = Arrays.stream(prCommentImpactsValue.toUpperCase().split(",")).map(String::trim).collect(Collectors.toList());
            prcomment.setImpacts(prCommentImpacts);
        }
    }

    private void setCoverityInstallDirectory(Map<String, Object> coverityParameters, Coverity coverity) {
        String value;
        if (coverityParameters.containsKey("coverity_install_directory") && !(value = coverityParameters.get("coverity_install_directory").toString().trim()).isBlank()) {
            Install install = new Install();
            install.setDirectory(value);
            coverity.setInstall(install);
        }
    }

    private void setCoverityPolicyView(Map<String, Object> coverityParameters, Coverity coverity) {
        String value;
        if (coverityParameters.containsKey("coverity_policy_view") && !(value = coverityParameters.get("coverity_policy_view").toString().trim()).isBlank()) {
            Policy policy = new Policy();
            policy.setView(value);
            coverity.getConnect().setPolicy(policy);
        }
    }

    private void setWaitForScan(Map<String, Object> coverityParameters, Coverity coverity) {
        String value;
        if (coverityParameters.containsKey("coverity_waitForScan") && ((value = coverityParameters.get("coverity_waitForScan").toString().trim()).equals("true") || value.equals("false"))) {
            coverity.setWaitForScan(Boolean.parseBoolean(value));
        }
    }

    private Coverity setBuildCommand(Map<String, Object> coverityParameters, Coverity coverity) {
        String value;
        if (coverityParameters.containsKey("coverity_build_command") && !(value = coverityParameters.get("coverity_build_command").toString().trim()).isBlank()) {
            if (coverity == null) {
                coverity = new Coverity();
            }
            Build build = new Build();
            build.setCommand(value);
            coverity.setBuild(build);
        }
        return coverity;
    }

    private Coverity setCleanCommand(Map<String, Object> coverityParameters, Coverity coverity) {
        String value;
        if (coverityParameters.containsKey("coverity_clean_command") && !(value = coverityParameters.get("coverity_clean_command").toString().trim()).isBlank()) {
            if (coverity == null) {
                coverity = new Coverity();
            }
            Clean clean = new Clean();
            clean.setCommand(value);
            coverity.setClean(clean);
        }
        return coverity;
    }

    private Coverity setConfigCommand(Map<String, Object> coverityParameters, Coverity coverity) {
        String value;
        if (coverityParameters.containsKey("coverity_config_path") && !(value = coverityParameters.get("coverity_config_path").toString().trim()).isBlank()) {
            if (coverity == null) {
                coverity = new Coverity();
            }
            Config config = new Config();
            config.setPath(value);
            coverity.setConfig(config);
        }
        return coverity;
    }

    private Coverity setArgs(Map<String, Object> coverityParameters, Coverity coverity) {
        if (coverityParameters.containsKey("coverity_args")) {
            if (coverity == null) {
                coverity = new Coverity();
            }
            coverity.setArgs(coverityParameters.get("coverity_args").toString().trim());
        }
        return coverity;
    }

    private Coverity setExecutionPath(Map<String, Object> scanParameters, Coverity coverity) {
        String installationPath;
        if (scanParameters.containsKey("coverity_execution_path") && !(installationPath = scanParameters.get("coverity_execution_path").toString().trim()).isBlank()) {
            if (coverity == null) {
                coverity = new Coverity();
            }
            Execution execution = new Execution();
            execution.setPath(installationPath);
            coverity.setExecution(execution);
        }
        return coverity;
    }

    public Project prepareProjectObjectForBridge(Map<String, Object> coverityParameters) {
        Project project = null;
        if (coverityParameters.containsKey("project_directory")) {
            project = new Project();
            String projectDirectory = coverityParameters.get("project_directory").toString().trim();
            project.setDirectory(projectDirectory);
        }
        return project;
    }
}

