/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.service.scan.blackducksca;

import hudson.EnvVars;
import hudson.model.TaskListener;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.Utility;
import io.jenkins.plugins.security.scan.global.enums.SecurityProduct;
import io.jenkins.plugins.security.scan.input.blackducksca.Automation;
import io.jenkins.plugins.security.scan.input.blackducksca.BlackDuckSCA;
import io.jenkins.plugins.security.scan.input.blackducksca.Failure;
import io.jenkins.plugins.security.scan.input.blackducksca.Filter;
import io.jenkins.plugins.security.scan.input.blackducksca.FixPr;
import io.jenkins.plugins.security.scan.input.blackducksca.Scan;
import io.jenkins.plugins.security.scan.input.project.Project;
import io.jenkins.plugins.security.scan.input.report.File;
import io.jenkins.plugins.security.scan.input.report.Reports;
import io.jenkins.plugins.security.scan.input.report.Sarif;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BlackDuckSCAParametersService {
    private final LoggerWrapper logger;
    private final EnvVars envVars;

    public BlackDuckSCAParametersService(TaskListener listener, EnvVars envVars) {
        this.logger = new LoggerWrapper(listener);
        this.envVars = envVars;
    }

    public boolean hasAllMandatoryBlackduckSCAParams(Map<String, Object> blackDuckSCAParameters) {
        if (blackDuckSCAParameters == null || blackDuckSCAParameters.isEmpty()) {
            return false;
        }
        List<String> missingMandatoryParams = this.getBlackDuckSCAMissingMandatoryParams(blackDuckSCAParameters);
        if (missingMandatoryParams.isEmpty()) {
            this.logger.info("Black Duck SCA parameters are validated successfully", new Object[0]);
            return true;
        }
        this.logger.error("%s - required parameters for %s is missing", missingMandatoryParams.toString(), SecurityProduct.BLACKDUCKSCA.getProductLabel());
        return false;
    }

    private List<String> getBlackDuckSCAMissingMandatoryParams(Map<String, Object> blackDuckSCAParameters) {
        ArrayList<String> missingMandatoryParams = new ArrayList<String>();
        Arrays.asList("blackducksca_url", "blackducksca_token").forEach(key -> {
            boolean isKeyValid;
            boolean bl = isKeyValid = blackDuckSCAParameters.containsKey(key) && blackDuckSCAParameters.get(key) != null && !blackDuckSCAParameters.get(key).toString().isEmpty();
            if (!isKeyValid) {
                missingMandatoryParams.add((String)key);
            }
        });
        String jobType = Utility.jenkinsJobType(this.envVars);
        this.showErrorMessageForJobType(missingMandatoryParams, jobType);
        return missingMandatoryParams;
    }

    private void showErrorMessageForJobType(List<String> missingMandatoryParams, String jobType) {
        if (!missingMandatoryParams.isEmpty()) {
            String jobTypeName = jobType.equalsIgnoreCase("FreeStyleProject") ? "FreeStyle" : (jobType.equalsIgnoreCase("WorkflowMultiBranchProject") ? "Multibranch Pipeline" : "Pipeline");
            this.logger.error("%s - required parameters for %s job type is missing", missingMandatoryParams, jobTypeName);
        }
    }

    public BlackDuckSCA prepareBlackDuckSCAObjectForBridge(Map<String, Object> blackDuckSCAParameters) {
        BlackDuckSCA blackDuckSCA = new BlackDuckSCA();
        Automation automation = new Automation();
        Scan scan = new Scan();
        this.setUrl(blackDuckSCAParameters, blackDuckSCA);
        this.setToken(blackDuckSCAParameters, blackDuckSCA);
        this.setScanFull(blackDuckSCAParameters, blackDuckSCA, scan);
        this.setScanFailureSeverities(blackDuckSCAParameters, blackDuckSCA, scan);
        this.setAutomationPrComment(blackDuckSCAParameters, automation, blackDuckSCA);
        this.setFixPr(blackDuckSCAParameters, blackDuckSCA);
        this.setSarif(blackDuckSCAParameters, blackDuckSCA);
        this.setWaitForScan(blackDuckSCAParameters, blackDuckSCA);
        return blackDuckSCA;
    }

    private void setUrl(Map<String, Object> blackDuckSCAParameters, BlackDuckSCA blackDuckSCA) {
        if (blackDuckSCAParameters.containsKey("blackducksca_url")) {
            blackDuckSCA.setUrl(blackDuckSCAParameters.get("blackducksca_url").toString().trim());
        }
    }

    private void setToken(Map<String, Object> blackDuckSCAParameters, BlackDuckSCA blackDuckSCA) {
        if (blackDuckSCAParameters.containsKey("blackducksca_token")) {
            blackDuckSCA.setToken(blackDuckSCAParameters.get("blackducksca_token").toString().trim());
        }
    }

    private void setScanFailureSeverities(Map<String, Object> blackDuckSCAParameters, BlackDuckSCA blackDuckSCA, Scan scan) {
        String value;
        if (blackDuckSCAParameters.containsKey("blackducksca_scan_failure_severities") && !(value = blackDuckSCAParameters.get("blackducksca_scan_failure_severities").toString().trim()).isBlank()) {
            String[] failureSeveritiesInput;
            ArrayList<String> failureSeverities = new ArrayList<String>();
            for (String input : failureSeveritiesInput = value.toUpperCase().split(",")) {
                failureSeverities.add(input.trim());
            }
            if (!failureSeverities.isEmpty()) {
                Failure failure = new Failure();
                failure.setSeverities(failureSeverities);
                scan.setFailure(failure);
                blackDuckSCA.setScan(scan);
            }
        }
    }

    private void setAutomationPrComment(Map<String, Object> blackDuckSCAParameters, Automation automation, BlackDuckSCA blackDuckSCA) {
        String value;
        if (blackDuckSCAParameters.containsKey("blackducksca_prComment_enabled") && (value = blackDuckSCAParameters.get("blackducksca_prComment_enabled").toString().trim()).equals("true")) {
            boolean isPullRequestEvent = Utility.isPullRequestEvent(this.envVars);
            if (isPullRequestEvent) {
                automation.setPrComment(true);
                blackDuckSCA.setAutomation(automation);
            } else {
                this.logger.info("Black Duck SCA PR Comment is ignored for non pull request scan", new Object[0]);
            }
        }
    }

    private void setFixPr(Map<String, Object> blackDuckSCAParameters, BlackDuckSCA blackDuckSCA) {
        String value;
        if (blackDuckSCAParameters.containsKey("blackducksca_fixpr_enabled") && (value = blackDuckSCAParameters.get("blackducksca_fixpr_enabled").toString().trim()).equals("true")) {
            boolean isPullRequestEvent = Utility.isPullRequestEvent(this.envVars);
            if (isPullRequestEvent) {
                this.logger.info("Black Duck SCA Fix PR ignored for pull request scan", new Object[0]);
            } else {
                FixPr fixPr = this.prepareFixPrObject(blackDuckSCAParameters);
                blackDuckSCA.setFixPr(fixPr);
            }
        }
    }

    private void setScanFull(Map<String, Object> scanParameters, BlackDuckSCA blackDuckSCA, Scan scan) {
        String value;
        String product;
        if (scanParameters.containsKey("blackducksca_scan_full") && ((product = scanParameters.get("product").toString().trim().toUpperCase()).contains(SecurityProduct.BLACKDUCK.name()) || product.contains(SecurityProduct.BLACKDUCKSCA.name())) && Utility.isBoolean(value = scanParameters.get("blackducksca_scan_full").toString().trim())) {
            scan.setFull(Boolean.parseBoolean(value));
            blackDuckSCA.setScan(scan);
        }
    }

    private void setSarif(Map<String, Object> blackDuckSCAParameters, BlackDuckSCA blackDuckSCA) {
        if (blackDuckSCAParameters.containsKey("blackducksca_reports_sarif_create") && this.envVars.get((Object)"CHANGE_ID") == null) {
            Sarif sarif = this.prepareSarifObject(blackDuckSCAParameters);
            blackDuckSCA.setReports(new Reports());
            blackDuckSCA.getReports().setSarif(sarif);
        }
    }

    private void setWaitForScan(Map<String, Object> blackDuckSCAParameters, BlackDuckSCA blackDuckSCA) {
        String value;
        if (blackDuckSCAParameters.containsKey("blackducksca_waitForScan") && ((value = blackDuckSCAParameters.get("blackducksca_waitForScan").toString().trim()).equals("true") || value.equals("false"))) {
            blackDuckSCA.setWaitForScan(Boolean.parseBoolean(value));
        }
    }

    public Project prepareProjectObjectForBridge(Map<String, Object> blackDuckSCAParameters) {
        Project project = null;
        if (blackDuckSCAParameters.containsKey("project_directory")) {
            project = new Project();
            String projectDirectory = blackDuckSCAParameters.get("project_directory").toString().trim();
            project.setDirectory(projectDirectory);
        }
        return project;
    }

    public Sarif prepareSarifObject(Map<String, Object> sarifParameters) {
        String reports_sarif_severities;
        String[] reports_sarif_severitiesInput;
        List<String> severities;
        String reports_sarif_file_path;
        boolean shouldCreateSarifInDefaultPath;
        Sarif sarif = new Sarif();
        boolean bl = shouldCreateSarifInDefaultPath = sarifParameters.containsKey("blackducksca_reports_sarif_create") && !sarifParameters.containsKey("blackducksca_reports_sarif_file_path");
        if (sarifParameters.containsKey("blackducksca_reports_sarif_create")) {
            Boolean isReports_sarif_create = (Boolean)sarifParameters.get("blackducksca_reports_sarif_create");
            sarif.setCreate(isReports_sarif_create);
        }
        if (sarifParameters.containsKey("blackducksca_reports_sarif_file_path") && (reports_sarif_file_path = (String)sarifParameters.get("blackducksca_reports_sarif_file_path")) != null) {
            sarif.setFile(new File());
            sarif.getFile().setPath(reports_sarif_file_path);
        }
        if (shouldCreateSarifInDefaultPath) {
            sarif.setFile(new File());
            sarif.getFile().setPath(".blackduck/integrations/blackducksca/sarif/report.sarif.json");
        }
        if (sarifParameters.containsKey("blackducksca_reports_sarif_severities") && !(severities = Arrays.stream(reports_sarif_severitiesInput = (reports_sarif_severities = (String)sarifParameters.get("blackducksca_reports_sarif_severities")).toUpperCase().split(",")).map(String::trim).collect(Collectors.toList())).isEmpty()) {
            sarif.setSeverities(severities);
        }
        if (sarifParameters.containsKey("blackducksca_reports_sarif_groupSCAIssues")) {
            Boolean reports_sarif_groupSCAIssues = (Boolean)sarifParameters.get("blackducksca_reports_sarif_groupSCAIssues");
            sarif.setGroupSCAIssues(reports_sarif_groupSCAIssues);
        }
        return sarif;
    }

    public FixPr prepareFixPrObject(Map<String, Object> fixPrParameters) {
        String fixPR_UseUpgradeGuidance;
        String[] fixPR_UseUpgradeGuidanceInput;
        List<String> guidance;
        String fixPR_filter_severities;
        String[] fixPR_filter_severitiesInput;
        List<String> severities;
        FixPr fixPr = new FixPr();
        fixPr.setEnabled(true);
        if (fixPrParameters.containsKey("blackducksca_fixpr_maxcount")) {
            Integer blackducksca_fixpr_maxCount = (Integer)fixPrParameters.get("blackducksca_fixpr_maxcount");
            fixPr.setMaxCount(blackducksca_fixpr_maxCount);
        }
        if (fixPrParameters.containsKey("blackducksca_fixpr_filter_severities") && !(severities = Arrays.stream(fixPR_filter_severitiesInput = (fixPR_filter_severities = (String)fixPrParameters.get("blackducksca_fixpr_filter_severities")).toUpperCase().split(",")).map(String::trim).collect(Collectors.toList())).isEmpty()) {
            Filter filter = new Filter();
            filter.setSeverities(severities);
            fixPr.setFilter(filter);
        }
        if (fixPrParameters.containsKey("blackducksca_fixpr_useUpgradeGuidance") && !(guidance = Arrays.stream(fixPR_UseUpgradeGuidanceInput = (fixPR_UseUpgradeGuidance = (String)fixPrParameters.get("blackducksca_fixpr_useUpgradeGuidance")).toUpperCase().split(",")).map(String::trim).collect(Collectors.toList())).isEmpty()) {
            fixPr.setUseUpgradeGuidance(guidance);
        }
        return fixPr;
    }
}

