/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.service;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.TaskListener;
import io.jenkins.plugins.security.scan.bridge.BridgeDownloadParameters;
import io.jenkins.plugins.security.scan.exception.PluginExceptionHandler;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.Utility;
import io.jenkins.plugins.security.scan.global.enums.InvokedFrom;
import io.jenkins.plugins.security.scan.global.enums.SecurityProduct;
import io.jenkins.plugins.security.scan.input.Bridge;
import io.jenkins.plugins.security.scan.input.BridgeInput;
import io.jenkins.plugins.security.scan.input.Invoked;
import io.jenkins.plugins.security.scan.input.blackducksca.BlackDuckSCA;
import io.jenkins.plugins.security.scan.input.coverity.Coverity;
import io.jenkins.plugins.security.scan.input.detect.Detect;
import io.jenkins.plugins.security.scan.input.network.Cert;
import io.jenkins.plugins.security.scan.input.network.Network;
import io.jenkins.plugins.security.scan.input.network.SSL;
import io.jenkins.plugins.security.scan.input.polaris.Parent;
import io.jenkins.plugins.security.scan.input.polaris.Polaris;
import io.jenkins.plugins.security.scan.input.project.Project;
import io.jenkins.plugins.security.scan.input.scm.bitbucket.Bitbucket;
import io.jenkins.plugins.security.scan.input.scm.github.Github;
import io.jenkins.plugins.security.scan.input.scm.gitlab.Gitlab;
import io.jenkins.plugins.security.scan.input.srm.SRM;
import io.jenkins.plugins.security.scan.service.scan.ScanParametersService;
import io.jenkins.plugins.security.scan.service.scan.blackducksca.BlackDuckSCAParametersService;
import io.jenkins.plugins.security.scan.service.scan.blackducksca.DetectParametersService;
import io.jenkins.plugins.security.scan.service.scan.coverity.CoverityParametersService;
import io.jenkins.plugins.security.scan.service.scan.polaris.PolarisParametersService;
import io.jenkins.plugins.security.scan.service.scan.srm.SRMParametersService;
import io.jenkins.plugins.security.scan.service.scm.SCMRepositoryService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ToolsParameterService {
    private final TaskListener listener;
    private final EnvVars envVars;
    private final FilePath workspace;
    private static final String DATA_KEY = "data";
    private final LoggerWrapper logger;

    public ToolsParameterService(TaskListener listener, EnvVars envVars, FilePath workspace) {
        this.listener = listener;
        this.envVars = envVars;
        this.workspace = workspace;
        this.logger = new LoggerWrapper(listener);
    }

    public List<String> getCommandLineArgs(Map<String, Object> scanParameters, FilePath bridgeInstallationPath, BridgeDownloadParameters bridgeDownloadParams) throws PluginExceptionHandler {
        ArrayList<String> commandLineArgs = new ArrayList<String>();
        commandLineArgs.add(this.getBridgeRunCommand(bridgeInstallationPath));
        commandLineArgs.addAll(this.getSecurityProductSpecificCommands(scanParameters, bridgeDownloadParams));
        if (Objects.equals(scanParameters.get("include_diagnostics"), true)) {
            commandLineArgs.add("--diagnostics");
        }
        return commandLineArgs;
    }

    private String getBridgeRunCommand(FilePath bridgeInstallationPath) {
        String os = Utility.getAgentOs(this.workspace, this.listener);
        if (os.contains("win")) {
            return bridgeInstallationPath.child("bridge-cli.exe").getRemote();
        }
        return bridgeInstallationPath.child("bridge-cli").getRemote();
    }

    private List<String> getSecurityProductSpecificCommands(Map<String, Object> scanParameters, BridgeDownloadParameters bridgeDownloadParams) throws PluginExceptionHandler {
        ScanParametersService scanParametersService = new ScanParametersService(this.listener);
        Set<String> securityProducts = scanParametersService.getSecurityProducts(scanParameters);
        ArrayList<String> scanCommands = new ArrayList<String>();
        Object scmObject = this.getScmObject(scanParameters);
        this.setBlackDuckScaCommands(scanParameters, securityProducts, scanCommands, scmObject);
        this.setCoverityCommands(scanParameters, securityProducts, scanCommands, scmObject, bridgeDownloadParams);
        this.setPolarisCommands(scanParameters, securityProducts, scanCommands, scmObject);
        this.setSrmCommands(scanParameters, securityProducts, scanCommands, scmObject);
        return scanCommands;
    }

    private void setBlackDuckScaCommands(Map<String, Object> scanParameters, Set<String> securityProducts, List<String> scanCommands, Object scmObject) {
        if (securityProducts.contains(SecurityProduct.BLACKDUCK.name()) || securityProducts.contains(SecurityProduct.BLACKDUCKSCA.name())) {
            BlackDuckSCAParametersService blackDuckSCAParametersService = new BlackDuckSCAParametersService(this.listener, this.envVars);
            BlackDuckSCA blackDuckSCA = blackDuckSCAParametersService.prepareBlackDuckSCAObjectForBridge(scanParameters);
            Project project = blackDuckSCAParametersService.prepareProjectObjectForBridge(scanParameters);
            scanCommands.add("--stage");
            scanCommands.add("blackducksca");
            scanCommands.add("--input");
            scanCommands.add(this.prepareBridgeInputJson(scanParameters, blackDuckSCA, scmObject, "blackducksca_input", project));
            scanCommands.add("--out");
            scanCommands.add(".bridge/output/scan_info_out.json");
        }
    }

    private void setCoverityCommands(Map<String, Object> scanParameters, Set<String> securityProducts, List<String> scanCommands, Object scmObject, BridgeDownloadParameters bridgeDownloadParams) {
        if (securityProducts.contains(SecurityProduct.COVERITY.name())) {
            CoverityParametersService coverityParametersService = new CoverityParametersService(this.listener, this.envVars, bridgeDownloadParams);
            Coverity coverity = coverityParametersService.prepareCoverityObjectForBridge(scanParameters);
            Project project = coverityParametersService.prepareProjectObjectForBridge(scanParameters);
            scanCommands.add("--stage");
            scanCommands.add("connect");
            scanCommands.add("--input");
            scanCommands.add(this.prepareBridgeInputJson(scanParameters, coverity, scmObject, "coverity_input", project));
            scanCommands.add("--out");
            scanCommands.add(".bridge/output/scan_info_out.json");
        }
    }

    private void setPolarisCommands(Map<String, Object> scanParameters, Set<String> securityProducts, List<String> scanCommands, Object scmObject) {
        if (securityProducts.contains(SecurityProduct.POLARIS.name())) {
            String defaultParentBranchName;
            PolarisParametersService polarisParametersService = new PolarisParametersService(this.listener, this.envVars);
            Polaris polaris = polarisParametersService.preparePolarisObjectForBridge(scanParameters);
            Project project = polarisParametersService.prepareProjectObjectForBridge(scanParameters);
            if (polaris.getBranch().getParent() == null && (defaultParentBranchName = (String)this.envVars.get((Object)"CHANGE_TARGET")) != null) {
                this.logger.info("Polaris Branch Parent Name: " + defaultParentBranchName, new Object[0]);
                Parent parent = new Parent();
                parent.setName(defaultParentBranchName);
                polaris.getBranch().setParent(parent);
            }
            scanCommands.add("--stage");
            scanCommands.add("polaris");
            scanCommands.add("--input");
            scanCommands.add(this.prepareBridgeInputJson(scanParameters, polaris, scmObject, "polaris_input", project));
            scanCommands.add("--out");
            scanCommands.add(".bridge/output/scan_info_out.json");
        }
    }

    private void setSrmCommands(Map<String, Object> scanParameters, Set<String> securityProducts, List<String> scanCommands, Object scmObject) {
        if (securityProducts.contains(SecurityProduct.SRM.name())) {
            SRMParametersService srmParametersService = new SRMParametersService(this.listener, this.envVars);
            SRM srm = srmParametersService.prepareSrmObjectForBridge(scanParameters);
            Project project = srmParametersService.prepareProjectObjectForBridge(scanParameters);
            scanCommands.add("--stage");
            scanCommands.add("srm");
            scanCommands.add("--input");
            scanCommands.add(this.prepareBridgeInputJson(scanParameters, srm, scmObject, "srm_input", project));
            scanCommands.add("--out");
            scanCommands.add(".bridge/output/scan_info_out.json");
        }
    }

    public String prepareBridgeInputJson(Map<String, Object> scanParameters, Object scanObject, Object scmObject, String jsonPrefix, Project project) {
        BridgeInput bridgeInput = new BridgeInput();
        this.setScanObject(bridgeInput, scanObject, scanParameters);
        this.setProjectObject(bridgeInput, project);
        this.setScmObject(bridgeInput, scmObject, scanParameters);
        this.setInvokedFrom(bridgeInput);
        this.setNetworkObject(bridgeInput, scanParameters);
        this.setDetectObject(scanParameters, bridgeInput);
        String inputJson = this.createBridgeInputJson(bridgeInput);
        return this.writeInputJsonToFile(inputJson, jsonPrefix);
    }

    private String createBridgeInputJson(BridgeInput bridgeInput) {
        HashMap<String, BridgeInput> inputJsonMap = new HashMap<String, BridgeInput>();
        inputJsonMap.put(DATA_KEY, bridgeInput);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        try {
            return mapper.writeValueAsString(inputJsonMap);
        }
        catch (Exception e) {
            this.logger.error("An exception occurred while creating input.json file: %s", e.getMessage());
            return null;
        }
    }

    private void setDetectObject(Map<String, Object> scanParameters, BridgeInput bridgeInput) {
        DetectParametersService detectParametersService = new DetectParametersService();
        Detect detect = detectParametersService.prepareDetectObject(scanParameters);
        if (detect != null) {
            bridgeInput.setDetect(detect);
        }
    }

    private void setNetworkObject(BridgeInput bridgeInput, Map<String, Object> scanParameters) {
        Network network = new Network();
        SSL ssl = new SSL();
        if (scanParameters.containsKey("network_airgap")) {
            Boolean isNetworkAirGap = (Boolean)scanParameters.get("network_airgap");
            network.setAirgap(isNetworkAirGap);
            bridgeInput.setNetwork(network);
        }
        if (scanParameters.containsKey("network_ssl_cert_file")) {
            String sslCertFile = (String)scanParameters.get("network_ssl_cert_file");
            Cert cert = new Cert();
            cert.setFile(sslCertFile);
            ssl.setCert(cert);
            network.setSsl(ssl);
            bridgeInput.setNetwork(network);
        }
        if (scanParameters.containsKey("network_ssl_trustAll")) {
            Boolean isSslTrustAll = (Boolean)scanParameters.get("network_ssl_trustAll");
            ssl.setTrustAll(isSslTrustAll);
            network.setSsl(ssl);
            bridgeInput.setNetwork(network);
        }
    }

    private Object getScmObject(Map<String, Object> scanParameters) throws PluginExceptionHandler {
        SCMRepositoryService scmRepositoryService = new SCMRepositoryService(this.listener, this.envVars);
        Object scmObject = null;
        String jobType = Utility.jenkinsJobType(this.envVars);
        if (jobType.equalsIgnoreCase("WorkflowMultiBranchProject")) {
            scmObject = scmRepositoryService.fetchSCMRepositoryDetails(Utility.installedBranchSourceDependencies(), scanParameters);
        }
        return scmObject;
    }

    private void setScmObject(BridgeInput bridgeInput, Object scmObject, Map<String, Object> scanParameters) {
        boolean isPrCommentSet = ToolsParameterService.isPrCommentValueSet(scanParameters);
        boolean isFixPrSet = ToolsParameterService.isFixPrValueSet(scanParameters);
        boolean isPullRequestEvent = Utility.isPullRequestEvent(this.envVars);
        if (isPrCommentSet && isPullRequestEvent || isFixPrSet && !isPullRequestEvent) {
            if (scmObject instanceof Bitbucket) {
                bridgeInput.setBitbucket((Bitbucket)scmObject);
            } else if (scmObject instanceof Github) {
                bridgeInput.setGithub((Github)scmObject);
            } else if (scmObject instanceof Gitlab) {
                bridgeInput.setGitlab((Gitlab)scmObject);
            }
        }
    }

    private void setInvokedFrom(BridgeInput bridgeInput) {
        SCMRepositoryService scmRepositoryService = new SCMRepositoryService(this.listener, this.envVars);
        InvokedFrom invokedFrom = scmRepositoryService.getInvokedFrom(Utility.installedBranchSourceDependencies(), Utility.jenkinsJobType(this.envVars), scmRepositoryService.findSCMSource());
        if (invokedFrom != null) {
            Bridge bridge = new Bridge();
            Invoked invoked = new Invoked();
            invoked.setFrom(invokedFrom.getValue());
            bridge.setInvoked(invoked);
            bridgeInput.setBridge(bridge);
        }
    }

    private void setScanObject(BridgeInput bridgeInput, Object scanObject, Map<String, Object> scanParameters) {
        if (scanObject instanceof BlackDuckSCA) {
            BlackDuckSCA blackDuckSCA = (BlackDuckSCA)scanObject;
            bridgeInput.setBlackDuckSCA(blackDuckSCA);
        } else if (scanObject instanceof Coverity) {
            Coverity coverity = (Coverity)scanObject;
            bridgeInput.setCoverity(coverity);
        } else if (scanObject instanceof Polaris) {
            Polaris polaris = (Polaris)scanObject;
            bridgeInput.setPolaris(polaris);
            this.setSastArbitaryInputs(bridgeInput, scanParameters);
        } else if (scanObject instanceof SRM) {
            SRM srm = (SRM)scanObject;
            bridgeInput.setSrm(srm);
            this.setSastArbitaryInputs(bridgeInput, scanParameters);
        }
    }

    private void setProjectObject(BridgeInput bridgeInput, Project project) {
        if (project != null) {
            bridgeInput.setProject(project);
        }
    }

    private void setSastArbitaryInputs(BridgeInput bridgeInput, Map<String, Object> scanParameters) {
        CoverityParametersService coverityParametersService = new CoverityParametersService(this.listener, this.envVars);
        Coverity coverity = coverityParametersService.setArbitaryInputs(scanParameters, null);
        if (coverity != null) {
            bridgeInput.setCoverity(coverity);
        }
    }

    public String writeInputJsonToFile(String inputJson, String jsonPrefix) {
        String inputJsonPath = null;
        try {
            FilePath parentWorkspacePath = this.workspace.getParent();
            if (parentWorkspacePath != null) {
                FilePath tempFile = parentWorkspacePath.createTempFile(jsonPrefix, ".json");
                tempFile.write(inputJson, StandardCharsets.UTF_8.name());
                inputJsonPath = tempFile.getRemote();
            } else {
                this.logger.error("Failed to create json file in workspace parent path", new Object[0]);
            }
        }
        catch (Exception e) {
            this.logger.error("An exception occurred while writing into json file: %s", e.getMessage());
            Thread.currentThread().interrupt();
        }
        return inputJsonPath;
    }

    public static boolean isPrCommentValueSet(Map<String, Object> scanParameters) {
        if (scanParameters.containsKey("blackducksca_prComment_enabled") && Objects.equals(scanParameters.get("blackducksca_prComment_enabled"), true)) {
            return true;
        }
        if (scanParameters.containsKey("coverity_prComment_enabled") && Objects.equals(scanParameters.get("coverity_prComment_enabled"), true)) {
            return true;
        }
        return scanParameters.containsKey("polaris_prComment_enabled") && Objects.equals(scanParameters.get("polaris_prComment_enabled"), true);
    }

    public static boolean isFixPrValueSet(Map<String, Object> scanParameters) {
        return scanParameters.containsKey("blackducksca_fixpr_enabled") && Objects.equals(scanParameters.get("blackducksca_fixpr_enabled"), true);
    }

    public void removeTemporaryInputJson(List<String> commandLineArgs) {
        for (String arg : commandLineArgs) {
            if (!arg.endsWith(".json")) continue;
            Utility.removeFile(arg, this.workspace, this.listener);
        }
    }
}

