/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.service;

import hudson.FilePath;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.security.scan.exception.PluginExceptionHandler;
import io.jenkins.plugins.security.scan.extension.SecurityScan;
import io.jenkins.plugins.security.scan.extension.freestyle.FreestyleScan;
import io.jenkins.plugins.security.scan.extension.global.ScannerGlobalConfig;
import io.jenkins.plugins.security.scan.extension.pipeline.FixPrScan;
import io.jenkins.plugins.security.scan.extension.pipeline.NetworkParams;
import io.jenkins.plugins.security.scan.extension.pipeline.PrCommentScan;
import io.jenkins.plugins.security.scan.extension.pipeline.ReturnStatusScan;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.ScanCredentialsHelper;
import io.jenkins.plugins.security.scan.global.Utility;
import io.jenkins.plugins.security.scan.global.enums.BuildStatus;
import io.jenkins.plugins.security.scan.global.enums.SecurityProduct;
import io.jenkins.plugins.security.scan.global.enums.TestLocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfiguration;

public class ParameterMappingService {
    private static final List<String> DEPRECATED_PARAMETERS = new ArrayList<String>();

    public static void addDeprecatedParameter(String param) {
        DEPRECATED_PARAMETERS.add(param);
    }

    public static List<String> getDeprecatedParameters() {
        return DEPRECATED_PARAMETERS;
    }

    public static Map<String, Object> preparePipelineParametersMap(SecurityScan securityScan, Map<String, Object> parametersMap, TaskListener listener) throws PluginExceptionHandler {
        String product = securityScan.getProduct();
        if (ParameterMappingService.validateProduct(product, listener)) {
            parametersMap.put("product", securityScan.getProduct().trim().toUpperCase());
            parametersMap.putAll(ParameterMappingService.prepareCoverityParametersMap(securityScan));
            parametersMap.putAll(ParameterMappingService.preparePolarisParametersMap(securityScan));
            parametersMap.putAll(ParameterMappingService.prepareBlackDuckSCAParametersMap(securityScan));
            parametersMap.putAll(ParameterMappingService.prepareSrmParametersMap(securityScan));
            parametersMap.putAll(ParameterMappingService.prepareSarifReportParametersMap(securityScan));
            ParameterMappingService.addParameterIfNotBlank(parametersMap, "bitbucket_username", securityScan.getBitbucket_username());
            ParameterMappingService.addParameterIfNotBlank(parametersMap, "bitbucket_token", securityScan.getBitbucket_token());
            ParameterMappingService.addParameterIfNotBlank(parametersMap, "gitlab_token", securityScan.getGitlab_token());
            ParameterMappingService.addParameterIfNotBlank(parametersMap, "github_token", securityScan.getGithub_token());
            parametersMap.putAll(ParameterMappingService.prepareAddtionalParametersMap(securityScan));
            if (securityScan instanceof ReturnStatusScan) {
                ReturnStatusScan returnStatusScan = (ReturnStatusScan)((Object)securityScan);
                ParameterMappingService.addParameterIfNotBlank(parametersMap, "return_status", returnStatusScan.isReturn_status());
            }
            return parametersMap;
        }
        throw new PluginExceptionHandler(101);
    }

    public static Map<String, Object> getGlobalConfigurationValues(FilePath workspace, TaskListener listener) {
        HashMap<String, Object> globalParameters = new HashMap<String, Object>();
        ScannerGlobalConfig config = (ScannerGlobalConfig)GlobalConfiguration.all().get(ScannerGlobalConfig.class);
        ScanCredentialsHelper scanCredentialsHelper = new ScanCredentialsHelper();
        if (config != null) {
            String bridgeDownloadUrl = ParameterMappingService.getBridgeDownloadUrlBasedOnAgentOS(workspace, listener, config.getBridgeDownloadUrlForMac(), config.getBridgeDownloadUrlForLinux(), config.getBridgeDownloadUrlForWindows());
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "blackducksca_url", config.getBlackDuckSCAUrl());
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "blackducksca_token", scanCredentialsHelper.getApiTokenByCredentialsId(config.getBlackDuckSCACredentialsId()).orElse(null));
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "detect_install_directory", config.getDetectInstallationPath());
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "coverity_url", config.getCoverityConnectUrl());
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "coverity_user", scanCredentialsHelper.getUsernameByCredentialsId(config.getCoverityCredentialsId()).orElse(null));
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "coverity_passphrase", scanCredentialsHelper.getPasswordByCredentialsId(config.getCoverityCredentialsId()).orElse(null));
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "coverity_install_directory", config.getCoverityInstallationPath());
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "srm_url", config.getSrmUrl());
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "srm_apikey", scanCredentialsHelper.getApiTokenByCredentialsId(config.getSrmCredentialsId()).orElse(null));
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "detect_execution_path", config.getSrmSCAInstallationPath());
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "coverity_execution_path", config.getSrmSASTInstallationPath());
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "bitbucket_username", scanCredentialsHelper.getUsernameByCredentialsId(config.getBitbucketCredentialsId()).orElse(null));
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "bitbucket_token", scanCredentialsHelper.getApiTokenByCredentialsId(config.getBitbucketCredentialsId()).orElse(scanCredentialsHelper.getPasswordByCredentialsId(config.getBitbucketCredentialsId()).orElse(null)));
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "github_token", scanCredentialsHelper.getApiTokenByCredentialsId(config.getGithubCredentialsId()).orElse(null));
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "gitlab_token", scanCredentialsHelper.getApiTokenByCredentialsId(config.getGitlabCredentialsId()).orElse(null));
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "bridgecli_download_url", bridgeDownloadUrl);
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "bridgecli_install_directory", config.getBridgeInstallationPath());
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "bridgecli_download_version", config.getBridgeDownloadVersion());
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "network_airgap", config.isNetworkAirGap());
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "network_ssl_cert_file", config.getNetworkSslCertFile());
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "network_ssl_trustAll", config.isNetworkSslTrustAll());
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "polaris_server_url", config.getPolarisServerUrl());
            ParameterMappingService.addParameterIfNotBlank(globalParameters, "polaris_access_token", scanCredentialsHelper.getApiTokenByCredentialsId(config.getPolarisCredentialsId()).orElse(null));
        }
        return globalParameters;
    }

    public static void addParameterIfNotBlank(Map<String, Object> parameters, String key, String value) {
        if (!Utility.isStringNullOrBlank(value)) {
            parameters.put(key, value);
        }
    }

    public static void addDeprecatedParameterIfNotBlank(Map<String, Object> parameters, String newKey, String value, String deprecatedKey) {
        if (!Utility.isStringNullOrBlank(value)) {
            parameters.put(newKey, value);
            ParameterMappingService.addDeprecatedParameter(deprecatedKey);
        }
    }

    public static void addParameterIfNotBlank(Map<String, Object> parameters, String key, Integer value) {
        if (value != null) {
            parameters.put(key, value);
        }
    }

    public static void addDeprecatedParameterIfNotBlank(Map<String, Object> parameters, String newKey, Integer value, String deprecatedKey) {
        if (value != null) {
            parameters.put(newKey, value);
            ParameterMappingService.addDeprecatedParameter(deprecatedKey);
        }
    }

    public static void addParameterIfNotBlank(Map<String, Object> parameters, String key, Boolean value) {
        if (value != null) {
            parameters.put(key, value);
        }
    }

    public static void addDeprecatedParameterIfNotBlank(Map<String, Object> parameters, String newKey, Boolean value, String deprecatedKey) {
        if (value != null) {
            parameters.put(newKey, value);
            ParameterMappingService.addDeprecatedParameter(deprecatedKey);
        }
    }

    public static void addDeprecatedParameterIfNotBlank(String key, Object value) {
        if (value instanceof String) {
            if (!Utility.isStringNullOrBlank((String)value)) {
                ParameterMappingService.addDeprecatedParameter(key);
            }
        } else if (value instanceof Boolean || value instanceof Integer) {
            ParameterMappingService.addDeprecatedParameter(key);
        }
    }

    public static Map<String, Object> prepareBlackDuckSCAParametersMap(SecurityScan securityScan) {
        HashMap<String, Object> blackDuckParameters = new HashMap<String, Object>();
        ParameterMappingService.addDeprecatedParameterIfNotBlank(blackDuckParameters, "blackducksca_url", securityScan.getBlackduck_url(), "blackduck_url");
        ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "blackducksca_url", securityScan.getBlackducksca_url());
        ParameterMappingService.addDeprecatedParameterIfNotBlank(blackDuckParameters, "blackducksca_token", securityScan.getBlackduck_token(), "blackduck_token");
        ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "blackducksca_token", securityScan.getBlackducksca_token());
        ParameterMappingService.addDeprecatedParameterIfNotBlank(blackDuckParameters, "detect_install_directory", securityScan.getBlackduck_install_directory(), "blackduck_install_directory");
        ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "detect_install_directory", securityScan.getDetect_install_directory());
        ParameterMappingService.addDeprecatedParameterIfNotBlank(blackDuckParameters, "blackducksca_scan_failure_severities", securityScan.getBlackduck_scan_failure_severities(), "blackduck_scan_failure_severities");
        ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "blackducksca_scan_failure_severities", securityScan.getBlackducksca_scan_failure_severities());
        ParameterMappingService.addDeprecatedParameterIfNotBlank(blackDuckParameters, "blackducksca_scan_full", securityScan.isBlackduckIntelligentScan(), "blackduck_scan_full");
        ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "blackducksca_scan_full", securityScan.isBlackduckscaIntelligentScan());
        if (securityScan instanceof PrCommentScan) {
            PrCommentScan prCommentScan = (PrCommentScan)((Object)securityScan);
            ParameterMappingService.addDeprecatedParameterIfNotBlank(blackDuckParameters, "blackducksca_prComment_enabled", prCommentScan.isBlackduck_prComment_enabled_actualValue(), "blackduck_prComment_enabled");
            ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "blackducksca_prComment_enabled", prCommentScan.isBlackducksca_prComment_enabled_actualValue());
        }
        if (securityScan instanceof FixPrScan) {
            FixPrScan fixPrScan = (FixPrScan)((Object)securityScan);
            ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "blackducksca_fixpr_enabled", fixPrScan.isBlackducksca_fixpr_enabled_actualValue());
            ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "blackducksca_fixpr_maxcount", fixPrScan.getBlackducksca_fixpr_maxCount());
            ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "blackducksca_fixpr_filter_severities", fixPrScan.getBlackducksca_fixpr_filter_severities());
            ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "blackducksca_fixpr_useUpgradeGuidance", fixPrScan.getBlackducksca_fixpr_useUpgradeGuidance());
        }
        ParameterMappingService.addDeprecatedParameterIfNotBlank(blackDuckParameters, "detect_download_url", securityScan.getBlackduck_download_url(), "blackduck_download_url");
        ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "detect_download_url", securityScan.getDetect_download_url());
        ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "project_directory", securityScan.getProject_directory());
        ParameterMappingService.addDeprecatedParameterIfNotBlank(blackDuckParameters, "blackducksca_waitForScan", securityScan.isBlackduck_waitForScan_actualValue(), "blackduck_waitForScan");
        ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "blackducksca_waitForScan", securityScan.isBlackducksca_waitForScan_actualValue());
        ParameterMappingService.prepareBlackDuckToolConfigurationParametersMap(blackDuckParameters, securityScan);
        return blackDuckParameters;
    }

    public static Map<String, Object> prepareCoverityParametersMap(SecurityScan securityScan) {
        HashMap<String, Object> coverityParameters = new HashMap<String, Object>();
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_url", securityScan.getCoverity_url());
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_user", securityScan.getCoverity_user());
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_passphrase", securityScan.getCoverity_passphrase());
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_project_name", securityScan.getCoverity_project_name());
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_stream_name", securityScan.getCoverity_stream_name());
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_policy_view", securityScan.getCoverity_policy_view());
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_install_directory", securityScan.getCoverity_install_directory());
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_version", securityScan.getCoverity_version());
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_local", securityScan.isCoverity_local());
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "project_directory", securityScan.getProject_directory());
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_waitForScan", securityScan.isCoverity_waitForScan_actualValue());
        if (securityScan instanceof PrCommentScan) {
            PrCommentScan prCommentScan = (PrCommentScan)((Object)securityScan);
            ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_prComment_enabled", prCommentScan.isCoverity_prComment_enabled_actualValue());
            ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_prComment_impacts", prCommentScan.getCoverity_prComment_impacts());
        }
        ParameterMappingService.prepareCoverityToolConfigurationParametersMap(coverityParameters, securityScan);
        return coverityParameters;
    }

    public static Map<String, Object> preparePolarisParametersMap(SecurityScan securityScan) {
        HashMap<String, Object> polarisParametersMap = new HashMap<String, Object>();
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "polaris_server_url", securityScan.getPolaris_server_url());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "polaris_access_token", securityScan.getPolaris_access_token());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "polaris_application_name", securityScan.getPolaris_application_name());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "polaris_project_name", securityScan.getPolaris_project_name());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "polaris_assessment_types", securityScan.getPolaris_assessment_types());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "polaris_branch_name", securityScan.getPolaris_branch_name());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "polaris_branch_parent_name", securityScan.getPolaris_branch_parent_name());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "polaris_test_sca_type", securityScan.getPolaris_test_sca_type());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "polaris_test_sast_type", securityScan.getPolaris_test_sast_type());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "polaris_test_sca_location", securityScan.getPolaris_test_sca_location());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "polaris_test_sast_location", securityScan.getPolaris_test_sast_location());
        ParameterMappingService.addDeprecatedParameterIfNotBlank("polaris_assessment_mode", securityScan.getPolaris_assessment_mode());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "project_directory", securityScan.getProject_directory());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "project_source_archive", securityScan.getProject_source_archive());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "project_source_excludes", securityScan.getProject_source_excludes());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "polaris_waitForScan", securityScan.isPolaris_waitForScan_actualValue());
        if (securityScan.isProject_source_preserveSymLinks_actualValue() != null) {
            polarisParametersMap.put("project_source_preserveSymLinks", securityScan.isProject_source_preserveSymLinks_actualValue());
        }
        if (securityScan instanceof PrCommentScan) {
            PrCommentScan prCommentScan = (PrCommentScan)((Object)securityScan);
            if (prCommentScan.isPolaris_prComment_enabled_actualValue() != null) {
                polarisParametersMap.put("polaris_prComment_enabled", prCommentScan.isPolaris_prComment_enabled_actualValue());
            }
            if (prCommentScan.getPolaris_prComment_severities() != null) {
                polarisParametersMap.put("polaris_prComment_severities", prCommentScan.getPolaris_prComment_severities());
            }
        }
        if (securityScan instanceof FreestyleScan) {
            FreestyleScan freestyleScan = (FreestyleScan)((Object)securityScan);
            ParameterMappingService.preparePolarisToolConfigurationParametersMap(polarisParametersMap, freestyleScan);
        }
        return polarisParametersMap;
    }

    public static Map<String, Object> prepareSrmParametersMap(SecurityScan securityScan) {
        HashMap<String, Object> srmParametersMap = new HashMap<String, Object>();
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "srm_url", securityScan.getSrm_url());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "srm_apikey", securityScan.getSrm_apikey());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "srm_assessment_types", securityScan.getSrm_assessment_types());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "srm_project_name", securityScan.getSrm_project_name());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "srm_project_id", securityScan.getSrm_project_id());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "srm_branch_name", securityScan.getSrm_branch_name());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "srm_branch_parent", securityScan.getSrm_branch_parent());
        ParameterMappingService.addDeprecatedParameterIfNotBlank(srmParametersMap, "detect_execution_path", securityScan.getBlackduck_execution_path(), "blackduck_execution_path");
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "detect_execution_path", securityScan.getDetect_execution_path());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "coverity_execution_path", securityScan.getCoverity_execution_path());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "project_directory", securityScan.getProject_directory());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "srm_waitForScan", securityScan.isSrm_waitForScan_actualValue());
        if (securityScan instanceof FreestyleScan) {
            FreestyleScan freestyleScan = (FreestyleScan)((Object)securityScan);
            ParameterMappingService.prepareSrmToolConfigurationParametersMap(srmParametersMap, freestyleScan);
        }
        return srmParametersMap;
    }

    private static void prepareCoverityToolConfigurationParametersMap(Map<String, Object> coverityParameters, SecurityScan securityScan) {
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_build_command", securityScan.getCoverity_build_command());
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_clean_command", securityScan.getCoverity_clean_command());
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_config_path", securityScan.getCoverity_config_path());
        ParameterMappingService.addParameterIfNotBlank(coverityParameters, "coverity_args", securityScan.getCoverity_args());
    }

    private static void prepareBlackDuckToolConfigurationParametersMap(Map<String, Object> blackDuckParameters, SecurityScan securityScan) {
        ParameterMappingService.addDeprecatedParameterIfNotBlank(blackDuckParameters, "detect_search_depth", securityScan.getBlackduck_search_depth(), "blackduck_search_depth");
        ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "detect_search_depth", securityScan.getDetect_search_depth());
        ParameterMappingService.addDeprecatedParameterIfNotBlank(blackDuckParameters, "detect_config_path", securityScan.getBlackduck_config_path(), "blackduck_config_path");
        ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "detect_config_path", securityScan.getDetect_config_path());
        ParameterMappingService.addDeprecatedParameterIfNotBlank(blackDuckParameters, "detect_args", securityScan.getBlackduck_args(), "blackduck_args");
        ParameterMappingService.addParameterIfNotBlank(blackDuckParameters, "detect_args", securityScan.getDetect_args());
    }

    private static void preparePolarisToolConfigurationParametersMap(Map<String, Object> polarisParametersMap, FreestyleScan freestyleScan) {
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "detect_search_depth", freestyleScan.getPolaris_sca_search_depth());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "detect_config_path", freestyleScan.getPolaris_sca_config_path());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "detect_args", freestyleScan.getPolaris_sca_args());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "coverity_build_command", freestyleScan.getPolaris_sast_build_command());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "coverity_clean_command", freestyleScan.getPolaris_sast_clean_command());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "coverity_config_path", freestyleScan.getPolaris_sast_config_path());
        ParameterMappingService.addParameterIfNotBlank(polarisParametersMap, "coverity_args", freestyleScan.getPolaris_sast_args());
    }

    private static void prepareSrmToolConfigurationParametersMap(Map<String, Object> srmParametersMap, FreestyleScan freestyleScan) {
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "detect_search_depth", freestyleScan.getSrm_sca_search_depth());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "detect_config_path", freestyleScan.getSrm_sca_config_path());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "detect_args", freestyleScan.getSrm_sca_args());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "coverity_build_command", freestyleScan.getSrm_sast_build_command());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "coverity_clean_command", freestyleScan.getSrm_sast_clean_command());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "coverity_config_path", freestyleScan.getSrm_sast_config_path());
        ParameterMappingService.addParameterIfNotBlank(srmParametersMap, "coverity_args", freestyleScan.getSrm_sast_args());
    }

    public static Map<String, Object> prepareAddtionalParametersMap(SecurityScan securityScan) {
        HashMap<String, Object> bridgeParameters = new HashMap<String, Object>();
        ParameterMappingService.addDeprecatedParameterIfNotBlank(bridgeParameters, "bridgecli_download_url", securityScan.getSynopsys_bridge_download_url(), "synopsys_bridge_download_url");
        ParameterMappingService.addParameterIfNotBlank(bridgeParameters, "bridgecli_download_url", securityScan.getBridgecli_download_url());
        ParameterMappingService.addDeprecatedParameterIfNotBlank(bridgeParameters, "bridgecli_download_version", securityScan.getSynopsys_bridge_download_version(), "synopsys_bridge_download_version");
        ParameterMappingService.addParameterIfNotBlank(bridgeParameters, "bridgecli_download_version", securityScan.getBridgecli_download_version());
        ParameterMappingService.addDeprecatedParameterIfNotBlank(bridgeParameters, "bridgecli_install_directory", securityScan.getSynopsys_bridge_install_directory(), "synopsys_bridge_install_directory");
        ParameterMappingService.addParameterIfNotBlank(bridgeParameters, "bridgecli_install_directory", securityScan.getBridgecli_install_directory());
        ParameterMappingService.addParameterIfNotBlank(bridgeParameters, "include_diagnostics", securityScan.isInclude_diagnostics());
        ParameterMappingService.addParameterIfNotBlank(bridgeParameters, "mark_build_status", securityScan.getMark_build_status());
        if (securityScan instanceof NetworkParams) {
            NetworkParams networkParams = (NetworkParams)((Object)securityScan);
            ParameterMappingService.addParameterIfNotBlank(bridgeParameters, "network_airgap", networkParams.isNetwork_airgap());
            ParameterMappingService.addParameterIfNotBlank(bridgeParameters, "network_ssl_cert_file", networkParams.getNetwork_ssl_cert_file());
            ParameterMappingService.addParameterIfNotBlank(bridgeParameters, "network_ssl_trustAll", networkParams.isNetwork_ssl_trustAll());
        }
        return bridgeParameters;
    }

    public static Map<String, Object> prepareSarifReportParametersMap(SecurityScan securityScan) {
        HashMap<String, Object> sarifParameters = new HashMap<String, Object>();
        ParameterMappingService.addDeprecatedParameterIfNotBlank(sarifParameters, "blackducksca_reports_sarif_create", securityScan.isBlackduck_reports_sarif_create(), "blackduck_reports_sarif_create");
        ParameterMappingService.addParameterIfNotBlank(sarifParameters, "blackducksca_reports_sarif_create", securityScan.isBlackducksca_reports_sarif_create());
        ParameterMappingService.addDeprecatedParameterIfNotBlank(sarifParameters, "blackducksca_reports_sarif_file_path", securityScan.getBlackduck_reports_sarif_file_path(), "blackduck_reports_sarif_file_path");
        ParameterMappingService.addParameterIfNotBlank(sarifParameters, "blackducksca_reports_sarif_file_path", securityScan.getBlackducksca_reports_sarif_file_path());
        ParameterMappingService.addDeprecatedParameterIfNotBlank(sarifParameters, "blackducksca_reports_sarif_groupSCAIssues", securityScan.isBlackduck_reports_sarif_groupSCAIssues_temporary(), "blackduck_reports_sarif_groupSCAIssues");
        ParameterMappingService.addParameterIfNotBlank(sarifParameters, "blackducksca_reports_sarif_groupSCAIssues", securityScan.isBlackducksca_reports_sarif_groupSCAIssues_temporary());
        ParameterMappingService.addDeprecatedParameterIfNotBlank(sarifParameters, "blackducksca_reports_sarif_severities", securityScan.getBlackduck_reports_sarif_severities(), "blackduck_reports_sarif_severities");
        ParameterMappingService.addParameterIfNotBlank(sarifParameters, "blackducksca_reports_sarif_severities", securityScan.getBlackducksca_reports_sarif_severities());
        ParameterMappingService.addParameterIfNotBlank(sarifParameters, "polaris_reports_sarif_create", securityScan.isPolaris_reports_sarif_create());
        ParameterMappingService.addParameterIfNotBlank(sarifParameters, "polaris_reports_sarif_file_path", securityScan.getPolaris_reports_sarif_file_path());
        ParameterMappingService.addParameterIfNotBlank(sarifParameters, "polaris_reports_sarif_groupSCAIssues", securityScan.isPolaris_reports_sarif_groupSCAIssues_temporary());
        ParameterMappingService.addParameterIfNotBlank(sarifParameters, "polaris_reports_sarif_severities", securityScan.getPolaris_reports_sarif_severities());
        ParameterMappingService.addParameterIfNotBlank(sarifParameters, "polaris_reports_sarif_issue_types", securityScan.getPolaris_reports_sarif_issue_types());
        return sarifParameters;
    }

    public static String getBridgeDownloadUrlBasedOnAgentOS(FilePath workspace, TaskListener listener, String bridgeDownloadUrlForMac, String bridgeDownloadUrlForLinux, String bridgeDownloadUrlForWindows) {
        String agentOs = Utility.getAgentOs(workspace, listener);
        if (agentOs.contains("mac")) {
            return bridgeDownloadUrlForMac;
        }
        if (agentOs.contains("linux")) {
            return bridgeDownloadUrlForLinux;
        }
        return bridgeDownloadUrlForWindows;
    }

    public static boolean validateProduct(String product, TaskListener listener) {
        boolean isValid;
        LoggerWrapper logger = new LoggerWrapper(listener);
        boolean bl = isValid = !Utility.isStringNullOrBlank(product) && Arrays.stream(product.split(",")).map(String::trim).map(String::toUpperCase).allMatch(p -> p.equals(SecurityProduct.BLACKDUCK.name()) || p.equals(SecurityProduct.BLACKDUCKSCA.name()) || p.equals(SecurityProduct.POLARIS.name()) || p.equals(SecurityProduct.COVERITY.name()) || p.equals(SecurityProduct.SRM.name()));
        if (!isValid) {
            logger.error("Invalid Security Product", new Object[0]);
            logger.info("Supported values for security products: " + String.valueOf(Arrays.stream(SecurityProduct.values()).filter(p -> p != SecurityProduct.BLACKDUCK).collect(Collectors.toList())), new Object[0]);
        }
        return isValid;
    }

    public static Result getBuildResultIfIssuesAreFound(int exitCode, String markBuildIfIssuesArePresent, LoggerWrapper logger) {
        Result result = null;
        if (exitCode == 8 && !Utility.isStringNullOrBlank(markBuildIfIssuesArePresent)) {
            try {
                BuildStatus buildStatus = BuildStatus.valueOf(markBuildIfIssuesArePresent.toUpperCase());
                if (buildStatus.in(BuildStatus.FAILURE, BuildStatus.UNSTABLE, BuildStatus.SUCCESS)) {
                    result = Utility.getMappedResultForBuildStatus(buildStatus);
                }
            }
            catch (IllegalArgumentException e) {
                logger.warn("Unsupported value for %s: %s. Supported values are: %s", "mark_build_status", markBuildIfIssuesArePresent, Arrays.asList(BuildStatus.values()));
            }
        }
        return result;
    }

    public static ListBoxModel getSecurityProductItems() {
        ListBoxModel items = new ListBoxModel();
        items.add(SecurityProduct.BLACKDUCKSCA.getProductLabel(), SecurityProduct.BLACKDUCKSCA.name().toLowerCase());
        items.add(SecurityProduct.COVERITY.getProductLabel(), SecurityProduct.COVERITY.name().toLowerCase());
        items.add(SecurityProduct.POLARIS.getProductLabel(), SecurityProduct.POLARIS.name().toLowerCase());
        items.add(SecurityProduct.SRM.getProductLabel(), SecurityProduct.SRM.name().toLowerCase());
        return items;
    }

    public static ListBoxModel getSCATestLocationItems() {
        ListBoxModel items = new ListBoxModel();
        items.add(TestLocation.HYBRID.getName(), TestLocation.HYBRID.getValue());
        items.add(TestLocation.REMOTE.getName(), TestLocation.REMOTE.getValue());
        return items;
    }

    public static ListBoxModel getSASTTestLocationItems() {
        ListBoxModel items = new ListBoxModel();
        items.add(TestLocation.HYBRID.getName(), TestLocation.HYBRID.getValue());
        items.add(TestLocation.LOCAL.getName(), TestLocation.LOCAL.getValue());
        items.add(TestLocation.REMOTE.getName(), TestLocation.REMOTE.getValue());
        return items;
    }

    public static ListBoxModel getMarkBuildStatusItems() {
        ListBoxModel items = new ListBoxModel();
        items.add(BuildStatus.FAILURE.name(), BuildStatus.FAILURE.name());
        items.add(BuildStatus.UNSTABLE.name(), BuildStatus.UNSTABLE.name());
        items.add(BuildStatus.SUCCESS.name(), BuildStatus.SUCCESS.name());
        return items;
    }

    public static String getProductUrl(Map<String, Object> scanParametersMap) {
        String product = scanParametersMap.get("product").toString().toUpperCase();
        String url = "";
        switch (SecurityProduct.valueOf(product)) {
            case BLACKDUCK: 
            case BLACKDUCKSCA: {
                url = scanParametersMap.getOrDefault("blackducksca_url", "").toString();
                break;
            }
            case COVERITY: {
                url = scanParametersMap.getOrDefault("coverity_url", "").toString();
                break;
            }
            case POLARIS: {
                url = scanParametersMap.getOrDefault("polaris_server_url", "").toString();
                break;
            }
            case SRM: {
                url = scanParametersMap.getOrDefault("srm_url", "").toString();
            }
        }
        return url;
    }
}

