/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.extension.pipeline;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.gitlabbranchsource.GitLabSCMSource;
import io.jenkins.plugins.security.scan.ScanInitializer;
import io.jenkins.plugins.security.scan.SecurityScanner;
import io.jenkins.plugins.security.scan.exception.PluginExceptionHandler;
import io.jenkins.plugins.security.scan.exception.ScannerException;
import io.jenkins.plugins.security.scan.extension.SecurityScan;
import io.jenkins.plugins.security.scan.extension.pipeline.FixPrScan;
import io.jenkins.plugins.security.scan.extension.pipeline.NetworkParams;
import io.jenkins.plugins.security.scan.extension.pipeline.PrCommentScan;
import io.jenkins.plugins.security.scan.extension.pipeline.ReturnStatusScan;
import io.jenkins.plugins.security.scan.global.ExceptionMessages;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.Utility;
import io.jenkins.plugins.security.scan.global.enums.SecurityProduct;
import io.jenkins.plugins.security.scan.service.ParameterMappingService;
import io.jenkins.plugins.security.scan.service.scm.SCMRepositoryService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SecurityScanStep
extends Step
implements SecurityScan,
PrCommentScan,
FixPrScan,
ReturnStatusScan,
NetworkParams,
Serializable {
    private static final long serialVersionUID = 6294070801130995534L;
    private String product;
    private String blackducksca_url;
    private transient String blackducksca_token;
    private String blackducksca_scan_failure_severities;
    private Boolean blackducksca_prComment_enabled;
    private Boolean blackducksca_prComment_enabled_actualValue;
    private Boolean blackducksca_fixpr_enabled;
    private Boolean blackducksca_fixpr_enabled_actualValue;
    private String blackducksca_fixpr_filter_severities;
    private String blackducksca_fixpr_useUpgradeGuidance;
    private Integer blackducksca_fixpr_maxCount;
    private Boolean blackducksca_reports_sarif_create;
    private String blackducksca_reports_sarif_file_path;
    private Boolean blackducksca_reports_sarif_groupSCAIssues;
    private String blackducksca_reports_sarif_severities;
    private Boolean blackducksca_reports_sarif_groupSCAIssues_temporary;
    private Boolean blackducksca_waitForScan;
    private Boolean blackducksca_waitForScan_actualValue;
    private String detect_install_directory;
    private Boolean blackducksca_scan_full;
    private Boolean blackduckscaIntelligentScan;
    private String detect_download_url;
    private Integer detect_search_depth;
    private String detect_config_path;
    private String detect_args;
    private String detect_execution_path;
    private String blackduck_url;
    private transient String blackduck_token;
    private String blackduck_install_directory;
    private Boolean blackduck_scan_full;
    private Boolean blackduckIntelligentScan;
    private String blackduck_scan_failure_severities;
    private Boolean blackduck_prComment_enabled;
    private Boolean blackduck_prComment_enabled_actualValue;
    private String blackduck_download_url;
    private Boolean blackduck_reports_sarif_create;
    private String blackduck_reports_sarif_file_path;
    private Boolean blackduck_reports_sarif_groupSCAIssues;
    private String blackduck_reports_sarif_severities;
    private Boolean blackduck_reports_sarif_groupSCAIssues_temporary;
    private Integer blackduck_search_depth;
    private String blackduck_config_path;
    private String blackduck_args;
    private String blackduck_execution_path;
    private Boolean blackduck_waitForScan;
    private Boolean blackduck_waitForScan_actualValue;
    private String coverity_url;
    private String coverity_user;
    private transient String coverity_passphrase;
    private String coverity_project_name;
    private String coverity_stream_name;
    private String coverity_policy_view;
    private String coverity_install_directory;
    private Boolean coverity_prComment_enabled;
    private Boolean coverity_prComment_enabled_actualValue;
    private String coverity_prComment_impacts;
    private String coverity_version;
    private Boolean coverity_local;
    private String coverity_build_command;
    private String coverity_clean_command;
    private String coverity_config_path;
    private String coverity_args;
    private String coverity_execution_path;
    private Boolean coverity_waitForScan;
    private Boolean coverity_waitForScan_actualValue;
    private String polaris_server_url;
    private transient String polaris_access_token;
    private String polaris_application_name;
    private String polaris_project_name;
    private String polaris_assessment_types;
    private String polaris_branch_name;
    private String polaris_branch_parent_name;
    private Boolean polaris_prComment_enabled;
    private Boolean polaris_prComment_enabled_actualValue;
    private String polaris_prComment_severities;
    private Boolean polaris_reports_sarif_create;
    private String polaris_reports_sarif_file_path;
    private String polaris_reports_sarif_issue_types;
    private Boolean polaris_reports_sarif_groupSCAIssues;
    private String polaris_reports_sarif_severities;
    private Boolean polaris_reports_sarif_groupSCAIssues_temporary;
    @Deprecated
    private String polaris_assessment_mode;
    private String polaris_test_sca_type;
    private String polaris_test_sast_type;
    private String polaris_test_sca_location;
    private String polaris_test_sast_location;
    private String project_source_archive;
    private String project_source_excludes;
    private Boolean project_source_preserveSymLinks;
    private Boolean project_source_preserveSymLinks_actualValue;
    private String project_directory;
    private String coverity_project_directory;
    private String blackducksca_project_directory;
    private String polaris_project_directory;
    private String srm_project_directory;
    private Boolean polaris_waitForScan;
    private Boolean polaris_waitForScan_actualValue;
    private String srm_url;
    private transient String srm_apikey;
    private String srm_assessment_types;
    private String srm_project_name;
    private String srm_project_id;
    private String srm_branch_name;
    private String srm_branch_parent;
    private Boolean srm_waitForScan;
    private Boolean srm_waitForScan_actualValue;
    private String bitbucket_username;
    private transient String bitbucket_token;
    private transient String github_token;
    private transient String gitlab_token;
    private String bridgecli_download_url;
    private String bridgecli_download_version;
    private String bridgecli_install_directory;
    private String synopsys_bridge_download_url;
    private String synopsys_bridge_download_version;
    private String synopsys_bridge_install_directory;
    private Boolean include_diagnostics;
    private Boolean coverity_include_diagnostics;
    private Boolean blackducksca_include_diagnostics;
    private Boolean polaris_include_diagnostics;
    private Boolean srm_include_diagnostics;
    private Boolean network_airgap;
    private String network_ssl_cert_file;
    private Boolean network_ssl_trustAll;
    private Boolean return_status = true;
    private String mark_build_status;
    private String blackducksca_mark_build_status;
    private String coverity_mark_build_status;
    private String polaris_mark_build_status;
    private String srm_mark_build_status;

    @DataBoundConstructor
    public SecurityScanStep() {
    }

    @Override
    public String getProduct() {
        return this.product;
    }

    @Override
    public String getBlackducksca_url() {
        return this.blackducksca_url;
    }

    @Override
    public String getBlackducksca_token() {
        return this.blackducksca_token;
    }

    @Override
    public String getDetect_install_directory() {
        return this.detect_install_directory;
    }

    @Override
    public Boolean isBlackducksca_scan_full() {
        return this.blackducksca_scan_full;
    }

    @Override
    public Boolean isBlackduckscaIntelligentScan() {
        return this.blackduckscaIntelligentScan;
    }

    @Override
    public String getBlackducksca_scan_failure_severities() {
        return this.blackducksca_scan_failure_severities;
    }

    @Override
    public Boolean isBlackducksca_prComment_enabled() {
        return this.blackducksca_prComment_enabled;
    }

    @Override
    public Boolean isBlackducksca_prComment_enabled_actualValue() {
        return this.blackducksca_prComment_enabled_actualValue;
    }

    @Override
    public Boolean isBlackducksca_fixpr_enabled() {
        return this.blackducksca_fixpr_enabled;
    }

    @Override
    public Boolean isBlackducksca_fixpr_enabled_actualValue() {
        return this.blackducksca_fixpr_enabled_actualValue;
    }

    @Override
    public String getBlackducksca_fixpr_filter_severities() {
        return this.blackducksca_fixpr_filter_severities;
    }

    @Override
    public String getBlackducksca_fixpr_useUpgradeGuidance() {
        return this.blackducksca_fixpr_useUpgradeGuidance;
    }

    @Override
    public Integer getBlackducksca_fixpr_maxCount() {
        return this.blackducksca_fixpr_maxCount;
    }

    @Override
    public String getDetect_download_url() {
        return this.detect_download_url;
    }

    @Override
    public Integer getDetect_search_depth() {
        return this.detect_search_depth;
    }

    @Override
    public String getDetect_config_path() {
        return this.detect_config_path;
    }

    @Override
    public String getDetect_args() {
        return this.detect_args;
    }

    @Override
    public String getDetect_execution_path() {
        return this.detect_execution_path;
    }

    @Override
    public Boolean isBlackducksca_reports_sarif_create() {
        return this.blackducksca_reports_sarif_create;
    }

    @Override
    public String getBlackducksca_reports_sarif_file_path() {
        return this.blackducksca_reports_sarif_file_path;
    }

    @Override
    public Boolean isBlackducksca_reports_sarif_groupSCAIssues() {
        return this.blackducksca_reports_sarif_groupSCAIssues;
    }

    @Override
    public String getBlackducksca_reports_sarif_severities() {
        return this.blackducksca_reports_sarif_severities;
    }

    @Override
    public Boolean isBlackducksca_reports_sarif_groupSCAIssues_temporary() {
        return this.blackducksca_reports_sarif_groupSCAIssues_temporary;
    }

    @Override
    public Boolean isBlackducksca_waitForScan() {
        return this.blackducksca_waitForScan;
    }

    @Override
    public Boolean isBlackducksca_waitForScan_actualValue() {
        return this.blackducksca_waitForScan_actualValue;
    }

    @Override
    public String getBlackduck_url() {
        return this.blackduck_url;
    }

    @Override
    public String getBlackduck_token() {
        return this.blackduck_token;
    }

    @Override
    public String getBlackduck_install_directory() {
        return this.blackduck_install_directory;
    }

    @Override
    public Boolean isBlackduck_scan_full() {
        return this.blackduck_scan_full;
    }

    @Override
    public Boolean isBlackduckIntelligentScan() {
        return this.blackduckIntelligentScan;
    }

    @Override
    public String getBlackduck_scan_failure_severities() {
        return this.blackduck_scan_failure_severities;
    }

    @Override
    public Boolean isBlackduck_prComment_enabled() {
        return this.blackduck_prComment_enabled;
    }

    @Override
    public Boolean isBlackduck_prComment_enabled_actualValue() {
        return this.blackduck_prComment_enabled_actualValue;
    }

    @Override
    public String getBlackduck_download_url() {
        return this.blackduck_download_url;
    }

    @Override
    public Integer getBlackduck_search_depth() {
        return this.blackduck_search_depth;
    }

    @Override
    public String getBlackduck_config_path() {
        return this.blackduck_config_path;
    }

    @Override
    public String getBlackduck_args() {
        return this.blackduck_args;
    }

    @Override
    public String getBlackduck_execution_path() {
        return this.blackduck_execution_path;
    }

    @Override
    public Boolean isBlackduck_reports_sarif_create() {
        return this.blackduck_reports_sarif_create;
    }

    @Override
    public String getBlackduck_reports_sarif_file_path() {
        return this.blackduck_reports_sarif_file_path;
    }

    @Override
    public Boolean isBlackduck_reports_sarif_groupSCAIssues() {
        return this.blackduck_reports_sarif_groupSCAIssues;
    }

    @Override
    public String getBlackduck_reports_sarif_severities() {
        return this.blackduck_reports_sarif_severities;
    }

    @Override
    public Boolean isBlackduck_reports_sarif_groupSCAIssues_temporary() {
        return this.blackduck_reports_sarif_groupSCAIssues_temporary;
    }

    @Override
    public Boolean isBlackduck_waitForScan() {
        return this.blackduck_waitForScan;
    }

    @Override
    public Boolean isBlackduck_waitForScan_actualValue() {
        return this.blackduck_waitForScan_actualValue;
    }

    @Override
    public String getCoverity_url() {
        return this.coverity_url;
    }

    @Override
    public String getCoverity_user() {
        return this.coverity_user;
    }

    @Override
    public String getCoverity_passphrase() {
        return this.coverity_passphrase;
    }

    @Override
    public String getCoverity_project_name() {
        return this.coverity_project_name;
    }

    @Override
    public String getCoverity_stream_name() {
        return this.coverity_stream_name;
    }

    @Override
    public String getCoverity_policy_view() {
        return this.coverity_policy_view;
    }

    @Override
    public String getCoverity_install_directory() {
        return this.coverity_install_directory;
    }

    @Override
    public Boolean isCoverity_prComment_enabled() {
        return this.coverity_prComment_enabled;
    }

    @Override
    public Boolean isCoverity_prComment_enabled_actualValue() {
        return this.coverity_prComment_enabled_actualValue;
    }

    @Override
    public String getCoverity_prComment_impacts() {
        return this.coverity_prComment_impacts;
    }

    @Override
    public String getCoverity_version() {
        return this.coverity_version;
    }

    @Override
    public Boolean isCoverity_local() {
        return this.coverity_local;
    }

    @Override
    public String getCoverity_build_command() {
        return this.coverity_build_command;
    }

    @Override
    public String getCoverity_clean_command() {
        return this.coverity_clean_command;
    }

    @Override
    public String getCoverity_config_path() {
        return this.coverity_config_path;
    }

    @Override
    public String getCoverity_args() {
        return this.coverity_args;
    }

    @Override
    public String getCoverity_execution_path() {
        return this.coverity_execution_path;
    }

    @Override
    public Boolean isCoverity_waitForScan() {
        return this.coverity_waitForScan;
    }

    @Override
    public Boolean isCoverity_waitForScan_actualValue() {
        return this.coverity_waitForScan_actualValue;
    }

    @Override
    public String getPolaris_server_url() {
        return this.polaris_server_url;
    }

    @Override
    public String getPolaris_access_token() {
        return this.polaris_access_token;
    }

    @Override
    public String getPolaris_application_name() {
        return this.polaris_application_name;
    }

    @Override
    public String getPolaris_project_name() {
        return this.polaris_project_name;
    }

    @Override
    public String getPolaris_assessment_types() {
        return this.polaris_assessment_types;
    }

    @Override
    public String getPolaris_branch_name() {
        return this.polaris_branch_name;
    }

    @Override
    public String getPolaris_branch_parent_name() {
        return this.polaris_branch_parent_name;
    }

    @Override
    public Boolean isPolaris_prComment_enabled() {
        return this.polaris_prComment_enabled;
    }

    @Override
    public Boolean isPolaris_prComment_enabled_actualValue() {
        return this.polaris_prComment_enabled_actualValue;
    }

    @Override
    public String getPolaris_prComment_severities() {
        return this.polaris_prComment_severities;
    }

    @Override
    public String getPolaris_test_sca_type() {
        return this.polaris_test_sca_type;
    }

    @Override
    public String getPolaris_test_sast_type() {
        return this.polaris_test_sast_type;
    }

    @Override
    public String getPolaris_test_sca_location() {
        return this.polaris_test_sca_location;
    }

    @Override
    public String getPolaris_test_sast_location() {
        return this.polaris_test_sast_location;
    }

    @Override
    public Boolean isPolaris_reports_sarif_create() {
        return this.polaris_reports_sarif_create;
    }

    @Override
    public String getPolaris_reports_sarif_file_path() {
        return this.polaris_reports_sarif_file_path;
    }

    @Override
    public Boolean isPolaris_reports_sarif_groupSCAIssues() {
        return this.polaris_reports_sarif_groupSCAIssues;
    }

    @Override
    public String getPolaris_reports_sarif_severities() {
        return this.polaris_reports_sarif_severities;
    }

    @Override
    public String getPolaris_reports_sarif_issue_types() {
        return this.polaris_reports_sarif_issue_types;
    }

    @Override
    public Boolean isPolaris_reports_sarif_groupSCAIssues_temporary() {
        return this.polaris_reports_sarif_groupSCAIssues_temporary;
    }

    @Override
    @Deprecated
    public String getPolaris_assessment_mode() {
        return this.polaris_assessment_mode;
    }

    @Override
    public String getProject_source_archive() {
        return this.project_source_archive;
    }

    @Override
    public Boolean isProject_source_preserveSymLinks() {
        return this.project_source_preserveSymLinks;
    }

    @Override
    public Boolean isProject_source_preserveSymLinks_actualValue() {
        return this.project_source_preserveSymLinks_actualValue;
    }

    @Override
    public Boolean isPolaris_waitForScan() {
        return this.polaris_waitForScan;
    }

    @Override
    public Boolean isPolaris_waitForScan_actualValue() {
        return this.polaris_waitForScan_actualValue;
    }

    @Override
    public String getProject_source_excludes() {
        return this.project_source_excludes;
    }

    @Override
    public String getBitbucket_username() {
        return this.bitbucket_username;
    }

    @Override
    public String getBitbucket_token() {
        return this.bitbucket_token;
    }

    @Override
    public String getGithub_token() {
        return this.github_token;
    }

    @Override
    public String getGitlab_token() {
        return this.gitlab_token;
    }

    @Override
    public String getBridgecli_download_url() {
        return this.bridgecli_download_url;
    }

    @Override
    public String getBridgecli_download_version() {
        return this.bridgecli_download_version;
    }

    @Override
    public String getBridgecli_install_directory() {
        return this.bridgecli_install_directory;
    }

    @Override
    public String getSynopsys_bridge_download_url() {
        return this.synopsys_bridge_download_url;
    }

    @Override
    public String getSynopsys_bridge_download_version() {
        return this.synopsys_bridge_download_version;
    }

    @Override
    public String getSynopsys_bridge_install_directory() {
        return this.synopsys_bridge_install_directory;
    }

    @Override
    public Boolean isInclude_diagnostics() {
        return this.include_diagnostics;
    }

    @Nullable
    public Boolean isCoverity_include_diagnostics() {
        return null;
    }

    @Nullable
    public Boolean isBlackducksca_include_diagnostics() {
        return null;
    }

    @Nullable
    public Boolean isPolaris_include_diagnostics() {
        return null;
    }

    @Nullable
    public Boolean isSrm_include_diagnostics() {
        return null;
    }

    @Override
    public Boolean isNetwork_airgap() {
        return this.network_airgap;
    }

    @Override
    public String getNetwork_ssl_cert_file() {
        return this.network_ssl_cert_file;
    }

    @Override
    public Boolean isNetwork_ssl_trustAll() {
        return this.network_ssl_trustAll;
    }

    @Override
    public Boolean isReturn_status() {
        return this.return_status;
    }

    @Override
    public String getMark_build_status() {
        return this.mark_build_status;
    }

    @Nullable
    public String getBlackducksca_mark_build_status() {
        return null;
    }

    @Nullable
    public String getCoverity_mark_build_status() {
        return null;
    }

    @Nullable
    public String getPolaris_mark_build_status() {
        return null;
    }

    @Nullable
    public String getSrm_mark_build_status() {
        return null;
    }

    @Override
    public String getProject_directory() {
        return this.project_directory;
    }

    @Override
    public String getSrm_url() {
        return this.srm_url;
    }

    @Override
    public String getSrm_apikey() {
        return this.srm_apikey;
    }

    @Override
    public String getSrm_project_name() {
        return this.srm_project_name;
    }

    @Override
    public String getSrm_project_id() {
        return this.srm_project_id;
    }

    @Override
    public String getSrm_assessment_types() {
        return this.srm_assessment_types;
    }

    @Override
    public String getSrm_branch_name() {
        return this.srm_branch_name;
    }

    @Override
    public String getSrm_branch_parent() {
        return this.srm_branch_parent;
    }

    @Override
    public Boolean isSrm_waitForScan() {
        return this.srm_waitForScan;
    }

    @Override
    public Boolean isSrm_waitForScan_actualValue() {
        return this.srm_waitForScan_actualValue;
    }

    @Nullable
    public String getBlackducksca_project_directory() {
        return null;
    }

    @Nullable
    public String getCoverity_project_directory() {
        return null;
    }

    @Nullable
    public String getPolaris_project_directory() {
        return null;
    }

    @Nullable
    public String getSrm_project_directory() {
        return null;
    }

    @DataBoundSetter
    public void setProduct(String product) {
        this.product = product;
    }

    @DataBoundSetter
    public void setBlackducksca_url(String blackducksca_url) {
        this.blackducksca_url = blackducksca_url;
    }

    @DataBoundSetter
    public void setBlackducksca_token(String blackducksca_token) {
        this.blackducksca_token = blackducksca_token;
    }

    @DataBoundSetter
    public void setDetect_install_directory(String blackducksca_install_directory) {
        this.detect_install_directory = blackducksca_install_directory;
    }

    @DataBoundSetter
    public void setBlackducksca_scan_full(Boolean blackducksca_scan_full) {
        if (blackducksca_scan_full == null) {
            this.blackducksca_scan_full = null;
            this.blackduckscaIntelligentScan = null;
        } else if (blackducksca_scan_full.booleanValue()) {
            this.blackducksca_scan_full = true;
            this.blackduckscaIntelligentScan = true;
        } else {
            this.blackducksca_scan_full = false;
            this.blackduckscaIntelligentScan = false;
        }
    }

    @DataBoundSetter
    public void setBlackducksca_scan_full(String value) {
        if ("auto".equals(value)) {
            this.setBlackducksca_scan_full((Boolean)null);
        } else if ("true".equals(value)) {
            this.setBlackducksca_scan_full(Boolean.TRUE);
        } else if ("false".equals(value)) {
            this.setBlackducksca_scan_full(Boolean.FALSE);
        }
    }

    @DataBoundSetter
    public void setBlackducksca_scan_failure_severities(String blackducksca_scan_failure_severities) {
        this.blackducksca_scan_failure_severities = Util.fixEmptyAndTrim((String)blackducksca_scan_failure_severities);
    }

    @DataBoundSetter
    public void setBlackducksca_prComment_enabled(Boolean blackducksca_prComment_enabled) {
        this.blackducksca_prComment_enabled = blackducksca_prComment_enabled != false ? Boolean.valueOf(true) : null;
        this.blackducksca_prComment_enabled_actualValue = blackducksca_prComment_enabled != false;
    }

    @DataBoundSetter
    public void setBlackducksca_fixpr_enabled(Boolean blackducksca_fixpr_enabled) {
        this.blackducksca_fixpr_enabled = blackducksca_fixpr_enabled != false ? Boolean.valueOf(true) : null;
        this.blackducksca_fixpr_enabled_actualValue = blackducksca_fixpr_enabled != false;
    }

    @DataBoundSetter
    public void setBlackducksca_fixpr_filter_severities(String blackducksca_fixpr_filter_severities) {
        this.blackducksca_fixpr_filter_severities = Util.fixEmptyAndTrim((String)blackducksca_fixpr_filter_severities);
    }

    @DataBoundSetter
    public void setBlackducksca_fixpr_useUpgradeGuidance(String blackducksca_fixpr_useUpgradeGuidance) {
        this.blackducksca_fixpr_useUpgradeGuidance = Util.fixEmptyAndTrim((String)blackducksca_fixpr_useUpgradeGuidance);
    }

    @DataBoundSetter
    public void setBlackducksca_fixpr_maxCount(Integer blackducksca_fixpr_maxCount) {
        this.blackducksca_fixpr_maxCount = blackducksca_fixpr_maxCount;
    }

    @DataBoundSetter
    public void setDetect_download_url(String detect_download_url) {
        this.detect_download_url = Util.fixEmptyAndTrim((String)detect_download_url);
    }

    @DataBoundSetter
    public void setDetect_search_depth(Integer detect_search_depth) {
        this.detect_search_depth = detect_search_depth;
    }

    @DataBoundSetter
    public void setDetect_config_path(String detect_config_path) {
        this.detect_config_path = Util.fixEmptyAndTrim((String)detect_config_path);
    }

    @DataBoundSetter
    public void setDetect_args(String detect_args) {
        this.detect_args = Util.fixEmptyAndTrim((String)detect_args);
    }

    @DataBoundSetter
    public void setDetect_execution_path(String detect_execution_path) {
        this.detect_execution_path = Util.fixEmptyAndTrim((String)detect_execution_path);
    }

    @DataBoundSetter
    public void setBlackducksca_reports_sarif_create(Boolean blackducksca_reports_sarif_create) {
        this.blackducksca_reports_sarif_create = blackducksca_reports_sarif_create != false ? Boolean.valueOf(true) : null;
    }

    @DataBoundSetter
    public void setBlackducksca_reports_sarif_file_path(String blackducksca_reports_sarif_file_path) {
        this.blackducksca_reports_sarif_file_path = Util.fixEmptyAndTrim((String)blackducksca_reports_sarif_file_path);
    }

    @DataBoundSetter
    public void setBlackducksca_reports_sarif_groupSCAIssues(Boolean blackducksca_reports_sarif_groupSCAIssues) {
        this.blackducksca_reports_sarif_groupSCAIssues = blackducksca_reports_sarif_groupSCAIssues != false ? Boolean.valueOf(true) : null;
        this.blackducksca_reports_sarif_groupSCAIssues_temporary = blackducksca_reports_sarif_groupSCAIssues != false;
    }

    @DataBoundSetter
    public void setBlackducksca_reports_sarif_severities(String blackducksca_reports_sarif_severities) {
        this.blackducksca_reports_sarif_severities = Util.fixEmptyAndTrim((String)blackducksca_reports_sarif_severities);
    }

    @DataBoundSetter
    public void setBlackducksca_waitForScan(Boolean blackducksca_waitForScan) {
        this.blackducksca_waitForScan = blackducksca_waitForScan != false ? Boolean.valueOf(true) : null;
        this.blackducksca_waitForScan_actualValue = blackducksca_waitForScan != false;
    }

    @DataBoundSetter
    public void setBlackduck_url(String blackduck_url) {
        this.blackduck_url = blackduck_url;
    }

    @DataBoundSetter
    public void setBlackduck_token(String blackduck_token) {
        this.blackduck_token = blackduck_token;
    }

    @DataBoundSetter
    public void setBlackduck_install_directory(String blackduck_install_directory) {
        this.blackduck_install_directory = blackduck_install_directory;
    }

    @DataBoundSetter
    public void setBlackduck_scan_full(Boolean blackduck_scan_full) {
        if (blackduck_scan_full.booleanValue()) {
            this.blackduckIntelligentScan = true;
        }
        if (!blackduck_scan_full.booleanValue()) {
            this.blackduckIntelligentScan = false;
        }
        this.blackduck_scan_full = blackduck_scan_full != false ? Boolean.valueOf(true) : null;
    }

    @DataBoundSetter
    public void setBlackduck_scan_failure_severities(String blackduck_scan_failure_severities) {
        this.blackduck_scan_failure_severities = Util.fixEmptyAndTrim((String)blackduck_scan_failure_severities);
    }

    @DataBoundSetter
    public void setBlackduck_prComment_enabled(Boolean blackduck_prComment_enabled) {
        this.blackduck_prComment_enabled = blackduck_prComment_enabled != false ? Boolean.valueOf(true) : null;
        this.blackduck_prComment_enabled_actualValue = blackduck_prComment_enabled != false;
    }

    @DataBoundSetter
    public void setBlackduck_download_url(String blackduck_download_url) {
        this.blackduck_download_url = Util.fixEmptyAndTrim((String)blackduck_download_url);
    }

    @DataBoundSetter
    public void setBlackduck_search_depth(Integer blackduck_search_depth) {
        this.blackduck_search_depth = blackduck_search_depth;
    }

    @DataBoundSetter
    public void setBlackduck_config_path(String blackduck_config_path) {
        this.blackduck_config_path = Util.fixEmptyAndTrim((String)blackduck_config_path);
    }

    @DataBoundSetter
    public void setBlackduck_args(String blackduck_args) {
        this.blackduck_args = Util.fixEmptyAndTrim((String)blackduck_args);
    }

    @DataBoundSetter
    public void setBlackduck_execution_path(String blackduck_execution_path) {
        this.blackduck_execution_path = Util.fixEmptyAndTrim((String)blackduck_execution_path);
    }

    @DataBoundSetter
    public void setBlackduck_reports_sarif_create(Boolean blackduck_reports_sarif_create) {
        this.blackduck_reports_sarif_create = blackduck_reports_sarif_create != false ? Boolean.valueOf(true) : null;
    }

    @DataBoundSetter
    public void setBlackduck_reports_sarif_file_path(String blackduck_reports_sarif_file_path) {
        this.blackduck_reports_sarif_file_path = Util.fixEmptyAndTrim((String)blackduck_reports_sarif_file_path);
    }

    @DataBoundSetter
    public void setBlackduck_reports_sarif_groupSCAIssues(Boolean blackduck_reports_sarif_groupSCAIssues) {
        this.blackduck_reports_sarif_groupSCAIssues = blackduck_reports_sarif_groupSCAIssues != false ? Boolean.valueOf(true) : null;
        this.blackduck_reports_sarif_groupSCAIssues_temporary = blackduck_reports_sarif_groupSCAIssues != false;
    }

    @DataBoundSetter
    public void setBlackduck_reports_sarif_severities(String blackduck_reports_sarif_severities) {
        this.blackduck_reports_sarif_severities = Util.fixEmptyAndTrim((String)blackduck_reports_sarif_severities);
    }

    @DataBoundSetter
    public void setBlackduck_waitForScan(Boolean blackduck_waitForScan) {
        this.blackduck_waitForScan = blackduck_waitForScan != false ? Boolean.valueOf(true) : null;
        this.blackduck_waitForScan_actualValue = blackduck_waitForScan != false;
    }

    @DataBoundSetter
    public void setCoverity_url(String coverity_url) {
        this.coverity_url = coverity_url;
    }

    @DataBoundSetter
    public void setCoverity_user(String coverity_user) {
        this.coverity_user = coverity_user;
    }

    @DataBoundSetter
    public void setCoverity_passphrase(String coverity_passphrase) {
        this.coverity_passphrase = coverity_passphrase;
    }

    @DataBoundSetter
    public void setCoverity_project_name(String coverity_project_name) {
        this.coverity_project_name = Util.fixEmptyAndTrim((String)coverity_project_name);
    }

    @DataBoundSetter
    public void setCoverity_stream_name(String coverity_stream_name) {
        this.coverity_stream_name = Util.fixEmptyAndTrim((String)coverity_stream_name);
    }

    @DataBoundSetter
    public void setCoverity_policy_view(String coverity_policy_view) {
        this.coverity_policy_view = Util.fixEmptyAndTrim((String)coverity_policy_view);
    }

    @DataBoundSetter
    public void setCoverity_install_directory(String coverity_install_directory) {
        this.coverity_install_directory = coverity_install_directory;
    }

    @DataBoundSetter
    public void setCoverity_prComment_enabled(Boolean coverity_prComment_enabled) {
        this.coverity_prComment_enabled = coverity_prComment_enabled != false ? Boolean.valueOf(true) : null;
        this.coverity_prComment_enabled_actualValue = coverity_prComment_enabled != false;
    }

    @DataBoundSetter
    public void setCoverity_prComment_impacts(String coverity_prComment_severities) {
        this.coverity_prComment_impacts = Util.fixEmptyAndTrim((String)coverity_prComment_severities);
    }

    @DataBoundSetter
    public void setCoverity_version(String coverity_version) {
        this.coverity_version = Util.fixEmptyAndTrim((String)coverity_version);
    }

    @DataBoundSetter
    public void setCoverity_local(Boolean coverity_local) {
        this.coverity_local = coverity_local != false ? Boolean.valueOf(true) : null;
    }

    @DataBoundSetter
    public void setCoverity_build_command(String coverity_build_command) {
        this.coverity_build_command = Util.fixEmptyAndTrim((String)coverity_build_command);
    }

    @DataBoundSetter
    public void setCoverity_clean_command(String coverity_clean_command) {
        this.coverity_clean_command = Util.fixEmptyAndTrim((String)coverity_clean_command);
    }

    @DataBoundSetter
    public void setCoverity_config_path(String coverity_config_path) {
        this.coverity_config_path = Util.fixEmptyAndTrim((String)coverity_config_path);
    }

    @DataBoundSetter
    public void setCoverity_args(String coverity_args) {
        this.coverity_args = Util.fixEmptyAndTrim((String)coverity_args);
    }

    @DataBoundSetter
    public void setCoverity_execution_path(String coverity_execution_path) {
        this.coverity_execution_path = Util.fixEmptyAndTrim((String)coverity_execution_path);
    }

    @DataBoundSetter
    public void setCoverity_waitForScan(Boolean coverity_waitForScan) {
        this.coverity_waitForScan = coverity_waitForScan != false ? Boolean.valueOf(true) : null;
        this.coverity_waitForScan_actualValue = coverity_waitForScan != false;
    }

    @DataBoundSetter
    public void setPolaris_server_url(String polaris_server_url) {
        this.polaris_server_url = polaris_server_url;
    }

    @DataBoundSetter
    public void setPolaris_access_token(String polaris_access_token) {
        this.polaris_access_token = polaris_access_token;
    }

    @DataBoundSetter
    public void setPolaris_application_name(String polaris_application_name) {
        this.polaris_application_name = Util.fixEmptyAndTrim((String)polaris_application_name);
    }

    @DataBoundSetter
    public void setPolaris_project_name(String polaris_project_name) {
        this.polaris_project_name = Util.fixEmptyAndTrim((String)polaris_project_name);
    }

    @DataBoundSetter
    public void setPolaris_assessment_types(String polaris_assessment_types) {
        this.polaris_assessment_types = Util.fixEmptyAndTrim((String)polaris_assessment_types);
    }

    @DataBoundSetter
    public void setPolaris_branch_name(String polaris_branch_name) {
        this.polaris_branch_name = Util.fixEmptyAndTrim((String)polaris_branch_name);
    }

    @DataBoundSetter
    public void setPolaris_branch_parent_name(String polaris_branch_parent_name) {
        this.polaris_branch_parent_name = Util.fixEmptyAndTrim((String)polaris_branch_parent_name);
    }

    @DataBoundSetter
    public void setPolaris_prComment_enabled(Boolean polaris_prComment_enabled) {
        this.polaris_prComment_enabled = polaris_prComment_enabled != false ? Boolean.valueOf(true) : null;
        this.polaris_prComment_enabled_actualValue = polaris_prComment_enabled != false;
    }

    @DataBoundSetter
    public void setPolaris_prComment_severities(String polaris_prComment_severities) {
        this.polaris_prComment_severities = Util.fixEmptyAndTrim((String)polaris_prComment_severities);
    }

    @DataBoundSetter
    public void setPolaris_test_sca_type(String polaris_test_sca_type) {
        this.polaris_test_sca_type = Util.fixEmptyAndTrim((String)polaris_test_sca_type);
    }

    @DataBoundSetter
    public void setPolaris_test_sast_type(String polaris_test_sast_type) {
        this.polaris_test_sast_type = Util.fixEmptyAndTrim((String)polaris_test_sast_type);
    }

    @DataBoundSetter
    public void setPolaris_test_sca_location(String polaris_test_sca_location) {
        this.polaris_test_sca_location = Util.fixEmptyAndTrim((String)polaris_test_sca_location);
    }

    @DataBoundSetter
    public void setPolaris_test_sast_location(String polaris_test_sast_location) {
        this.polaris_test_sast_location = Util.fixEmptyAndTrim((String)polaris_test_sast_location);
    }

    @Deprecated
    @DataBoundSetter
    public void setPolaris_assessment_mode(String polaris_assessment_mode) {
        this.polaris_assessment_mode = Util.fixEmptyAndTrim((String)polaris_assessment_mode);
    }

    @DataBoundSetter
    public void setPolaris_reports_sarif_create(Boolean polaris_reports_sarif_create) {
        this.polaris_reports_sarif_create = polaris_reports_sarif_create != false ? Boolean.valueOf(true) : null;
    }

    @DataBoundSetter
    public void setPolaris_reports_sarif_file_path(String polaris_reports_sarif_file_path) {
        this.polaris_reports_sarif_file_path = Util.fixEmptyAndTrim((String)polaris_reports_sarif_file_path);
    }

    @DataBoundSetter
    public void setPolaris_reports_sarif_groupSCAIssues(Boolean polaris_reports_sarif_groupSCAIssues) {
        this.polaris_reports_sarif_groupSCAIssues = polaris_reports_sarif_groupSCAIssues != false ? Boolean.valueOf(true) : null;
        this.polaris_reports_sarif_groupSCAIssues_temporary = polaris_reports_sarif_groupSCAIssues != false;
    }

    @DataBoundSetter
    public void setPolaris_reports_sarif_severities(String polaris_reports_sarif_severities) {
        this.polaris_reports_sarif_severities = Util.fixEmptyAndTrim((String)polaris_reports_sarif_severities);
    }

    @DataBoundSetter
    public void setPolaris_reports_sarif_issue_types(String polaris_reports_sarif_issue_types) {
        this.polaris_reports_sarif_issue_types = Util.fixEmptyAndTrim((String)polaris_reports_sarif_issue_types);
    }

    @DataBoundSetter
    public void setProject_source_archive(String project_source_archive) {
        this.project_source_archive = Util.fixEmptyAndTrim((String)project_source_archive);
    }

    @DataBoundSetter
    public void setProject_source_preserveSymLinks(Boolean project_source_preserveSymLinks) {
        this.project_source_preserveSymLinks = project_source_preserveSymLinks != false ? Boolean.valueOf(true) : null;
        this.project_source_preserveSymLinks_actualValue = project_source_preserveSymLinks;
    }

    @DataBoundSetter
    public void setProject_source_excludes(String project_source_excludes) {
        this.project_source_excludes = Util.fixEmptyAndTrim((String)project_source_excludes);
    }

    @DataBoundSetter
    public void setPolaris_waitForScan(Boolean polaris_waitForScan) {
        this.polaris_waitForScan = polaris_waitForScan != false ? Boolean.valueOf(true) : null;
        this.polaris_waitForScan_actualValue = polaris_waitForScan != false;
    }

    @DataBoundSetter
    public void setSrm_url(String srm_url) {
        this.srm_url = srm_url;
    }

    @DataBoundSetter
    public void setSrm_apikey(String srm_apikey) {
        this.srm_apikey = Util.fixEmptyAndTrim((String)srm_apikey);
    }

    @DataBoundSetter
    public void setSrm_assessment_types(String srm_assessment_types) {
        this.srm_assessment_types = Util.fixEmptyAndTrim((String)srm_assessment_types);
    }

    @DataBoundSetter
    public void setSrm_project_name(String srm_project_name) {
        this.srm_project_name = Util.fixEmptyAndTrim((String)srm_project_name);
    }

    @DataBoundSetter
    public void setSrm_project_id(String srm_project_id) {
        this.srm_project_id = Util.fixEmptyAndTrim((String)srm_project_id);
    }

    @DataBoundSetter
    public void setSrm_branch_name(String srm_branch_name) {
        this.srm_branch_name = Util.fixEmptyAndTrim((String)srm_branch_name);
    }

    @DataBoundSetter
    public void setSrm_branch_parent(String srm_branch_parent) {
        this.srm_branch_parent = Util.fixEmptyAndTrim((String)srm_branch_parent);
    }

    @DataBoundSetter
    public void setSrm_waitForScan(Boolean srm_waitForScan) {
        this.srm_waitForScan = srm_waitForScan != false ? Boolean.valueOf(true) : null;
        this.srm_waitForScan_actualValue = srm_waitForScan != false;
    }

    @DataBoundSetter
    public void setInclude_diagnostics(Boolean include_diagnostics) {
        this.include_diagnostics = include_diagnostics != false ? Boolean.valueOf(true) : null;
    }

    @DataBoundSetter
    public void setCoverity_include_diagnostics(Boolean coverity_include_diagnostics) {
        if (this.getProduct().contentEquals(SecurityProduct.COVERITY.name().toLowerCase())) {
            this.include_diagnostics = coverity_include_diagnostics != false ? Boolean.valueOf(true) : null;
        }
    }

    @DataBoundSetter
    public void setBlackducksca_include_diagnostics(Boolean blackducksca_include_diagnostics) {
        if (this.getProduct().contentEquals(SecurityProduct.BLACKDUCKSCA.name().toLowerCase())) {
            this.include_diagnostics = blackducksca_include_diagnostics != false ? Boolean.valueOf(true) : null;
        }
    }

    @DataBoundSetter
    public void setPolaris_include_diagnostics(Boolean polaris_include_diagnostics) {
        if (this.getProduct().contentEquals(SecurityProduct.POLARIS.name().toLowerCase())) {
            this.include_diagnostics = polaris_include_diagnostics != false ? Boolean.valueOf(true) : null;
        }
    }

    @DataBoundSetter
    public void setSrm_include_diagnostics(Boolean srm_include_diagnostics) {
        if (this.getProduct().contentEquals(SecurityProduct.SRM.name().toLowerCase())) {
            this.include_diagnostics = srm_include_diagnostics != false ? Boolean.valueOf(true) : null;
        }
    }

    @DataBoundSetter
    public void setProject_directory(String project_directory) {
        this.project_directory = Util.fixEmptyAndTrim((String)project_directory);
    }

    @DataBoundSetter
    public void setCoverity_project_directory(String coverity_project_directory) {
        if (this.getProduct().contentEquals(SecurityProduct.COVERITY.name().toLowerCase())) {
            this.project_directory = Util.fixEmptyAndTrim((String)coverity_project_directory);
        }
    }

    @DataBoundSetter
    public void setBlackducksca_project_directory(String blackducksca_project_directory) {
        if (this.getProduct().contentEquals(SecurityProduct.BLACKDUCKSCA.name().toLowerCase())) {
            this.project_directory = Util.fixEmptyAndTrim((String)blackducksca_project_directory);
        }
    }

    @DataBoundSetter
    public void setPolaris_project_directory(String polaris_project_directory) {
        if (this.getProduct().contentEquals(SecurityProduct.POLARIS.name().toLowerCase())) {
            this.project_directory = Util.fixEmptyAndTrim((String)polaris_project_directory);
        }
    }

    @DataBoundSetter
    public void setSrm_project_directory(String srm_project_directory) {
        if (this.getProduct().contentEquals(SecurityProduct.SRM.name().toLowerCase())) {
            this.project_directory = Util.fixEmptyAndTrim((String)srm_project_directory);
        }
    }

    @DataBoundSetter
    public void setBitbucket_username(String bitbucket_username) {
        this.bitbucket_username = bitbucket_username;
    }

    @DataBoundSetter
    public void setBitbucket_token(String bitbucket_token) {
        this.bitbucket_token = bitbucket_token;
    }

    @DataBoundSetter
    public void setGithub_token(String github_token) {
        this.github_token = github_token;
    }

    @DataBoundSetter
    public void setGitlab_token(String gitlab_token) {
        this.gitlab_token = gitlab_token;
    }

    @DataBoundSetter
    public void setBridgecli_download_url(String bridgecli_download_url) {
        this.bridgecli_download_url = bridgecli_download_url;
    }

    @DataBoundSetter
    public void setBridgecli_download_version(String bridgecli_download_version) {
        this.bridgecli_download_version = bridgecli_download_version;
    }

    @DataBoundSetter
    public void setBridgecli_install_directory(String bridgecli_install_directory) {
        this.bridgecli_install_directory = bridgecli_install_directory;
    }

    @DataBoundSetter
    public void setSynopsys_bridge_download_url(String synopsys_bridge_download_url) {
        this.synopsys_bridge_download_url = synopsys_bridge_download_url;
    }

    @DataBoundSetter
    public void setSynopsys_bridge_download_version(String synopsys_bridge_download_version) {
        this.synopsys_bridge_download_version = synopsys_bridge_download_version;
    }

    @DataBoundSetter
    public void setSynopsys_bridge_install_directory(String synopsys_bridge_install_directory) {
        this.synopsys_bridge_install_directory = synopsys_bridge_install_directory;
    }

    @DataBoundSetter
    public void setNetwork_airgap(Boolean network_airgap) {
        this.network_airgap = network_airgap != false ? Boolean.valueOf(true) : null;
    }

    @DataBoundSetter
    public void setNetwork_ssl_cert_file(String network_ssl_cert_file) {
        this.network_ssl_cert_file = network_ssl_cert_file;
    }

    @DataBoundSetter
    public void setNetwork_ssl_trustAll(Boolean network_ssl_trustAll) {
        this.network_ssl_trustAll = network_ssl_trustAll;
    }

    @DataBoundSetter
    public void setReturn_status(Boolean return_status) {
        this.return_status = return_status;
    }

    @DataBoundSetter
    public void setMark_build_status(String mark_build_status) {
        this.mark_build_status = Util.fixEmptyAndTrim((String)mark_build_status);
    }

    @DataBoundSetter
    public void setCoverity_mark_build_status(String coverity_mark_build_status) {
        if (this.getProduct().contentEquals(SecurityProduct.COVERITY.name().toLowerCase())) {
            this.mark_build_status = Util.fixEmptyAndTrim((String)coverity_mark_build_status);
        }
    }

    @DataBoundSetter
    public void setBlackducksca_mark_build_status(String blackducksca_mark_build_status) {
        if (this.getProduct().contentEquals(SecurityProduct.BLACKDUCKSCA.name().toLowerCase())) {
            this.mark_build_status = Util.fixEmptyAndTrim((String)blackducksca_mark_build_status);
        }
    }

    @DataBoundSetter
    public void setPolaris_mark_build_status(String polaris_mark_build_status) {
        if (this.getProduct().contentEquals(SecurityProduct.POLARIS.name().toLowerCase())) {
            this.mark_build_status = Util.fixEmptyAndTrim((String)polaris_mark_build_status);
        }
    }

    @DataBoundSetter
    public void setSrm_mark_build_status(String srm_mark_build_status) {
        if (this.getProduct().contentEquals(SecurityProduct.SRM.name().toLowerCase())) {
            this.mark_build_status = Util.fixEmptyAndTrim((String)srm_mark_build_status);
        }
    }

    private Map<String, Object> getParametersMap(FilePath workspace, TaskListener listener) throws PluginExceptionHandler {
        return ParameterMappingService.preparePipelineParametersMap(this, ParameterMappingService.getGlobalConfigurationValues(workspace, listener), listener);
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context);
    }

    public class Execution
    extends SynchronousNonBlockingStepExecution<Integer> {
        private static final long serialVersionUID = -2514079516220990421L;
        private final transient Run<?, ?> run;
        private final transient Launcher launcher;
        private final transient FlowNode flowNode;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
        private final transient TaskListener listener;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
        private final transient EnvVars envVars;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
        private final transient FilePath workspace;

        protected Execution(StepContext context) throws InterruptedException, IOException {
            super(context);
            this.run = (Run)context.get(Run.class);
            this.listener = (TaskListener)context.get(TaskListener.class);
            this.envVars = (EnvVars)context.get(EnvVars.class);
            this.workspace = (FilePath)context.get(FilePath.class);
            this.launcher = (Launcher)context.get(Launcher.class);
            this.flowNode = (FlowNode)context.get(FlowNode.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Integer run() throws PluginExceptionHandler, ScannerException {
            LoggerWrapper logger = new LoggerWrapper(this.listener);
            int exitCode = 0;
            String undefinedErrorMessage = null;
            Exception unknownException = new Exception();
            logger.println("**************************** START EXECUTION OF BLACK DUCK SECURITY SCAN ****************************", new Object[0]);
            Map<String, Object> scanparametersMap = SecurityScanStep.this.getParametersMap(this.workspace, this.listener);
            try {
                this.verifyRequiredPlugins(logger, this.envVars);
                SecurityScanner securityScanner = new SecurityScanner(this.run, this.listener, this.launcher, this.workspace, this.envVars);
                ScanInitializer scanInitializer = new ScanInitializer(securityScanner, this.workspace, this.envVars, this.listener);
                exitCode = scanInitializer.initializeScanner(scanparametersMap);
            }
            catch (Exception e) {
                block14: {
                    try {
                        if (e instanceof PluginExceptionHandler) {
                            exitCode = ((PluginExceptionHandler)e).getCode();
                            break block14;
                        }
                        exitCode = 999;
                        undefinedErrorMessage = e.getMessage();
                        unknownException = e;
                    }
                    catch (Throwable throwable) {
                        String exitMessage = ExceptionMessages.getErrorMessage(exitCode, undefinedErrorMessage);
                        if (exitMessage != null) {
                            if (exitCode == 0) {
                                logger.info(exitMessage, new Object[0]);
                            } else {
                                logger.error(exitMessage, new Object[0]);
                            }
                        }
                        this.handleExitCode(exitCode, exitMessage, unknownException, logger);
                        throw throwable;
                    }
                }
                String exitMessage = ExceptionMessages.getErrorMessage(exitCode, undefinedErrorMessage);
                if (exitMessage != null) {
                    if (exitCode == 0) {
                        logger.info(exitMessage, new Object[0]);
                    } else {
                        logger.error(exitMessage, new Object[0]);
                    }
                }
                this.handleExitCode(exitCode, exitMessage, unknownException, logger);
            }
            String exitMessage = ExceptionMessages.getErrorMessage(exitCode, undefinedErrorMessage);
            if (exitMessage != null) {
                if (exitCode == 0) {
                    logger.info(exitMessage, new Object[0]);
                } else {
                    logger.error(exitMessage, new Object[0]);
                }
            }
            this.handleExitCode(exitCode, exitMessage, unknownException, logger);
            return exitCode;
        }

        private void handleExitCode(int exitCode, String exitMessage, Exception e, LoggerWrapper logger) throws PluginExceptionHandler, ScannerException {
            if (exitCode != 8 && !Utility.isStringNullOrBlank(SecurityScanStep.this.getMark_build_status())) {
                logger.info("Marking build status as " + SecurityScanStep.this.getMark_build_status() + " is ignored since exit code is: " + exitCode, new Object[0]);
            }
            if (exitCode == 0) {
                logger.println("**************************** END EXECUTION OF BLACK DUCK SECURITY SCAN ****************************", new Object[0]);
            } else {
                Result result = ParameterMappingService.getBuildResultIfIssuesAreFound(exitCode, SecurityScanStep.this.getMark_build_status(), logger);
                if (result != null) {
                    logger.info("Marking build as " + String.valueOf(result) + " since issues are present", new Object[0]);
                    this.handleNonZeroExitCode(exitCode, result, exitMessage, e, logger);
                } else {
                    this.handleNonZeroExitCode(exitCode, Result.FAILURE, exitMessage, e, logger);
                }
            }
        }

        private void handleNonZeroExitCode(int exitCode, Result result, String exitMessage, Exception e, LoggerWrapper logger) throws PluginExceptionHandler, ScannerException {
            this.flowNode.addOrReplaceAction((Action)new WarningAction(result));
            this.run.setResult(result);
            logger.println("**************************** END EXECUTION OF BLACK DUCK SECURITY SCAN ****************************", new Object[0]);
            if (Objects.equals(SecurityScanStep.this.isReturn_status(), true)) {
                return;
            }
            if (exitCode == 999) {
                throw new ScannerException(exitMessage, e);
            }
            throw new PluginExceptionHandler(exitMessage);
        }

        public void verifyRequiredPlugins(LoggerWrapper logger, EnvVars envVars) throws PluginExceptionHandler {
            String jobType = Utility.jenkinsJobType(envVars);
            SCMRepositoryService scmRepositoryService = new SCMRepositoryService(this.listener, envVars);
            Map<String, Boolean> installedBranchSourceDependencies = Utility.installedBranchSourceDependencies();
            if (jobType.equalsIgnoreCase("WorkflowMultiBranchProject")) {
                if (installedBranchSourceDependencies.isEmpty()) {
                    logger.error("Necessary 'Branch Source Plugin' is not installed in Jenkins instance. Please install necessary 'Branch Source Plugin' in your Jenkins instance", new Object[0]);
                    throw new PluginExceptionHandler(115);
                }
                SCMSource scmSource = scmRepositoryService.findSCMSource();
                if (!(installedBranchSourceDependencies.getOrDefault("cloudbees-bitbucket-branch-source", false).booleanValue() && scmSource instanceof BitbucketSCMSource || installedBranchSourceDependencies.getOrDefault("github-branch-source", false).booleanValue() && scmSource instanceof GitHubSCMSource || installedBranchSourceDependencies.getOrDefault("gitlab-branch-source", false).booleanValue() && scmSource instanceof GitLabSCMSource)) {
                    logger.error("Necessary 'Branch Source Plugin' is not installed in Jenkins instance. Please install necessary 'Branch Source Plugin' in your Jenkins instance", new Object[0]);
                    throw new PluginExceptionHandler(115);
                }
            }
        }
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return new HashSet<Class>(Arrays.asList(Run.class, TaskListener.class, EnvVars.class, FilePath.class, Launcher.class, Node.class));
        }

        public String getFunctionName() {
            return "security_scan";
        }

        @Nonnull
        public String getDisplayName() {
            return "Black Duck Security Scan";
        }

        public ListBoxModel doFillProductItems() {
            ListBoxModel items = new ListBoxModel();
            items.add((Object)new ListBoxModel.Option("Select", ""));
            items.addAll((Collection)ParameterMappingService.getSecurityProductItems());
            return items;
        }

        public ListBoxModel doFillPolaris_test_sast_locationItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Select", "");
            items.addAll((Collection)ParameterMappingService.getSASTTestLocationItems());
            return items;
        }

        public ListBoxModel doFillPolaris_test_sca_locationItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Select", "");
            items.addAll((Collection)ParameterMappingService.getSCATestLocationItems());
            return items;
        }

        public ListBoxModel doFillBlackducksca_mark_build_statusItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Select", "");
            items.addAll((Collection)ParameterMappingService.getMarkBuildStatusItems());
            return items;
        }

        public ListBoxModel doFillPolaris_mark_build_statusItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Select", "");
            items.addAll((Collection)ParameterMappingService.getMarkBuildStatusItems());
            return items;
        }

        public ListBoxModel doFillCoverity_mark_build_statusItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Select", "");
            items.addAll((Collection)ParameterMappingService.getMarkBuildStatusItems());
            return items;
        }

        public ListBoxModel doFillSrm_mark_build_statusItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Select", "");
            items.addAll((Collection)ParameterMappingService.getMarkBuildStatusItems());
            return items;
        }
    }
}

