/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.extension.global;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.security.scan.extension.global.AuthenticationSupport;
import io.jenkins.plugins.security.scan.global.ScanCredentialsHelper;
import io.jenkins.plugins.security.scan.global.Utility;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.EnglishReasonPhraseCatalog;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

@Extension
public class ScannerGlobalConfig
extends GlobalConfiguration
implements Serializable {
    private static final long serialVersionUID = -3129542889827231427L;
    private static final int CONNECTION_TIMEOUT_IN_SECONDS = 120;
    private String AUTHORIZATION_FAILURE = "Could not perform the authorization request: ";
    private String CONNECTION_SUCCESSFUL = "Connection successful.";
    private String blackDuckSCAUrl;
    private String blackDuckSCACredentialsId;
    private String detectInstallationPath;
    private String coverityConnectUrl;
    private String coverityCredentialsId;
    private String coverityInstallationPath;
    private String bridgeDownloadUrlForMac;
    private String bridgeDownloadUrlForWindows;
    private String bridgeDownloadUrlForLinux;
    private String bridgeDownloadVersion;
    private String bridgeInstallationPath;
    private Boolean networkAirGap;
    private String polarisServerUrl;
    private String polarisCredentialsId;
    private String srmUrl;
    private String srmCredentialsId;
    private String srmSCAInstallationPath;
    private String srmSASTInstallationPath;
    private String bitbucketCredentialsId;
    private String githubCredentialsId;
    private String gitlabCredentialsId;
    private String networkSslCertFile;
    private Boolean networkSslTrustAll;

    @DataBoundConstructor
    public ScannerGlobalConfig() {
        this.load();
    }

    @DataBoundSetter
    public void setBlackDuckSCAUrl(String blackDuckSCAUrl) {
        this.blackDuckSCAUrl = blackDuckSCAUrl;
        this.save();
    }

    @DataBoundSetter
    public void setBlackDuckSCACredentialsId(String blackDuckSCACredentialsId) {
        this.blackDuckSCACredentialsId = blackDuckSCACredentialsId;
        this.save();
    }

    @DataBoundSetter
    public void setDetectInstallationPath(String detectInstallationPath) {
        this.detectInstallationPath = detectInstallationPath;
        this.save();
    }

    @DataBoundSetter
    public void setCoverityConnectUrl(String coverityConnectUrl) {
        this.coverityConnectUrl = coverityConnectUrl;
        this.save();
    }

    @DataBoundSetter
    public void setCoverityInstallationPath(String coverityInstallationPath) {
        this.coverityInstallationPath = coverityInstallationPath;
        this.save();
    }

    @DataBoundSetter
    public void setBitbucketCredentialsId(String bitbucketCredentialsId) {
        this.bitbucketCredentialsId = bitbucketCredentialsId;
        this.save();
    }

    @DataBoundSetter
    public void setGithubCredentialsId(String githubCredentialsId) {
        this.githubCredentialsId = githubCredentialsId;
        this.save();
    }

    @DataBoundSetter
    public void setGitlabCredentialsId(String gitlabCredentialsId) {
        this.gitlabCredentialsId = gitlabCredentialsId;
        this.save();
    }

    @DataBoundSetter
    public void setBridgeDownloadUrlForMac(String bridgeDownloadUrlForMac) {
        this.bridgeDownloadUrlForMac = bridgeDownloadUrlForMac;
        this.save();
    }

    @DataBoundSetter
    public void setBridgeDownloadUrlForWindows(String bridgeDownloadUrlForWindows) {
        this.bridgeDownloadUrlForWindows = bridgeDownloadUrlForWindows;
        this.save();
    }

    @DataBoundSetter
    public void setBridgeDownloadUrlForLinux(String bridgeDownloadUrlForLinux) {
        this.bridgeDownloadUrlForLinux = bridgeDownloadUrlForLinux;
        this.save();
    }

    @DataBoundSetter
    public void setBridgeDownloadVersion(String bridgeDownloadVersion) {
        this.bridgeDownloadVersion = bridgeDownloadVersion;
        this.save();
    }

    @DataBoundSetter
    public void setBridgeInstallationPath(String bridgeInstallationPath) {
        this.bridgeInstallationPath = bridgeInstallationPath;
        this.save();
    }

    @DataBoundSetter
    public void setNetworkAirGap(Boolean networkAirGap) {
        this.networkAirGap = networkAirGap;
        this.save();
    }

    @DataBoundSetter
    public void setPolarisServerUrl(String polarisServerUrl) {
        this.polarisServerUrl = polarisServerUrl;
        this.save();
    }

    @DataBoundSetter
    public void setPolarisCredentialsId(String polarisCredentialsId) {
        this.polarisCredentialsId = polarisCredentialsId;
        this.save();
    }

    @DataBoundSetter
    public void setCoverityCredentialsId(String coverityCredentialsId) {
        this.coverityCredentialsId = coverityCredentialsId;
        this.save();
    }

    @DataBoundSetter
    public void setSrmUrl(String srmUrl) {
        this.srmUrl = srmUrl;
        this.save();
    }

    @DataBoundSetter
    public void setSrmCredentialsId(String srmCredentialsId) {
        this.srmCredentialsId = srmCredentialsId;
        this.save();
    }

    @DataBoundSetter
    public void setSrmSCAInstallationPath(String srmSCAInstallationPath) {
        this.srmSCAInstallationPath = srmSCAInstallationPath;
    }

    @DataBoundSetter
    public void setSrmSASTInstallationPath(String srmSASTInstallationPath) {
        this.srmSASTInstallationPath = srmSASTInstallationPath;
    }

    @DataBoundSetter
    public void setNetworkSslCertFile(String networkSslCertFile) {
        this.networkSslCertFile = networkSslCertFile;
        this.save();
    }

    @DataBoundSetter
    public void setNetworkSslTrustAll(Boolean networkSslTrustAll) {
        this.networkSslTrustAll = networkSslTrustAll;
        this.save();
    }

    public String getBlackDuckSCAUrl() {
        return this.blackDuckSCAUrl;
    }

    public String getDetectInstallationPath() {
        return this.detectInstallationPath;
    }

    public String getCoverityConnectUrl() {
        return this.coverityConnectUrl;
    }

    public String getCoverityInstallationPath() {
        return this.coverityInstallationPath;
    }

    public String getBridgeDownloadUrlForMac() {
        return this.bridgeDownloadUrlForMac;
    }

    public String getBridgeDownloadUrlForWindows() {
        return this.bridgeDownloadUrlForWindows;
    }

    public String getBridgeDownloadUrlForLinux() {
        return this.bridgeDownloadUrlForLinux;
    }

    public String getBridgeDownloadVersion() {
        return this.bridgeDownloadVersion;
    }

    public String getBridgeInstallationPath() {
        return this.bridgeInstallationPath;
    }

    public Boolean isNetworkAirGap() {
        return this.networkAirGap;
    }

    public String getNetworkSslCertFile() {
        return this.networkSslCertFile;
    }

    public Boolean isNetworkSslTrustAll() {
        return this.networkSslTrustAll;
    }

    public String getPolarisServerUrl() {
        return this.polarisServerUrl;
    }

    public String getBlackDuckSCACredentialsId() {
        return this.blackDuckSCACredentialsId;
    }

    public String getCoverityCredentialsId() {
        return this.coverityCredentialsId;
    }

    public String getPolarisCredentialsId() {
        return this.polarisCredentialsId;
    }

    public String getBitbucketCredentialsId() {
        return this.bitbucketCredentialsId;
    }

    public String getGithubCredentialsId() {
        return this.githubCredentialsId;
    }

    public String getGitlabCredentialsId() {
        return this.gitlabCredentialsId;
    }

    public String getSrmUrl() {
        return this.srmUrl;
    }

    public String getSrmCredentialsId() {
        return this.srmCredentialsId;
    }

    public String getSrmSCAInstallationPath() {
        return this.srmSCAInstallationPath;
    }

    public String getSrmSASTInstallationPath() {
        return this.srmSASTInstallationPath;
    }

    private ListBoxModel getOptionsWithApiTokenCredentials() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return new StandardListBoxModel().includeEmptyValue();
        }
        jenkins.checkPermission(Jenkins.ADMINISTER);
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)jenkins, BaseStandardCredentials.class, Collections.emptyList(), ScanCredentialsHelper.API_TOKEN_CREDENTIALS);
    }

    public ListBoxModel doFillBlackDuckSCACredentialsIdItems() {
        return this.getOptionsWithApiTokenCredentials();
    }

    public ListBoxModel doFillPolarisCredentialsIdItems() {
        return this.getOptionsWithApiTokenCredentials();
    }

    public ListBoxModel doFillCoverityCredentialsIdItems() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return new StandardListBoxModel().includeEmptyValue();
        }
        jenkins.checkPermission(Jenkins.ADMINISTER);
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)jenkins, BaseStandardCredentials.class, Collections.emptyList(), ScanCredentialsHelper.USERNAME_PASSWORD_CREDENTIALS);
    }

    public ListBoxModel doFillSrmCredentialsIdItems() {
        return this.getOptionsWithApiTokenCredentials();
    }

    public ListBoxModel doFillBitbucketCredentialsIdItems() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return new StandardListBoxModel().includeEmptyValue();
        }
        jenkins.checkPermission(Jenkins.ADMINISTER);
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)jenkins, BaseStandardCredentials.class, Collections.emptyList(), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{ScanCredentialsHelper.USERNAME_PASSWORD_CREDENTIALS, ScanCredentialsHelper.API_TOKEN_CREDENTIALS}));
    }

    public ListBoxModel doFillGithubCredentialsIdItems() {
        return this.getOptionsWithApiTokenCredentials();
    }

    public ListBoxModel doFillGitlabCredentialsIdItems() {
        return this.getOptionsWithApiTokenCredentials();
    }

    @POST
    public FormValidation doTestBlackDuckSCAConnection(@QueryParameter(value="blackDuckSCAUrl") String blackDuckSCAUrl, @QueryParameter(value="blackDuckSCACredentialsId") String blackDuckSCACredentialsId) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return FormValidation.warning((String)"Connection validation could not be completed: Validation couldn't retrieve the instance of Jenkins from the JVM. This may happen if Jenkins is still starting up or if this code is running on a different JVM than your Jenkins server.");
        }
        jenkins.checkPermission(Jenkins.ADMINISTER);
        if (Utility.isStringNullOrBlank(blackDuckSCAUrl)) {
            return FormValidation.error((String)"The Black Duck SCA URL must be specified");
        }
        if (Utility.isStringNullOrBlank(blackDuckSCACredentialsId)) {
            return FormValidation.error((String)"The Black Duck SCA credentials must be specified");
        }
        try {
            AuthenticationSupport authenticationSupport = new AuthenticationSupport();
            HttpResponse response = authenticationSupport.attemptBlackDuckSCAAuthentication(blackDuckSCAUrl, blackDuckSCACredentialsId, 120);
            if (response.getCode() != 200) {
                String validationMessage = this.getValidationMessage(response.getCode());
                return FormValidation.error((String)String.join((CharSequence)" ", validationMessage));
            }
        }
        catch (Exception e) {
            return FormValidation.error((String)(this.AUTHORIZATION_FAILURE + this.getFormattedExceptionMessage(e.getCause().getMessage())));
        }
        return FormValidation.ok((String)this.CONNECTION_SUCCESSFUL);
    }

    private String getValidationMessage(int statusCode) {
        String validationMessage;
        try {
            String statusPhrase = EnglishReasonPhraseCatalog.INSTANCE.getReason(statusCode, Locale.ENGLISH);
            validationMessage = String.format("ERROR: Connection attempt returned %s %s", statusCode, statusPhrase);
        }
        catch (IllegalArgumentException ignored) {
            validationMessage = "ERROR: Connection could not be established.";
        }
        return validationMessage;
    }

    @POST
    public FormValidation doTestPolarisConnection(@QueryParameter(value="polarisServerUrl") String polarisServerUrl, @QueryParameter(value="polarisCredentialsId") String polarisCredentialsId) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return FormValidation.warning((String)"Connection validation could not be completed: Validation couldn't retrieve the instance of Jenkins from the JVM. This may happen if Jenkins is still starting up or if this code is running on a different JVM than your Jenkins server.");
        }
        jenkins.checkPermission(Jenkins.ADMINISTER);
        if (Utility.isStringNullOrBlank(polarisServerUrl)) {
            return FormValidation.error((String)"The Polaris server url must be specified");
        }
        if (Utility.isStringNullOrBlank(polarisCredentialsId)) {
            return FormValidation.error((String)"The Polaris credentials must be specified");
        }
        try {
            AuthenticationSupport authenticationSupport = new AuthenticationSupport();
            HttpResponse response = authenticationSupport.attemptPolarisAuthentication(polarisServerUrl, polarisCredentialsId, 120);
            if (response.getCode() != 200) {
                String validationMessage = this.getValidationMessage(response.getCode());
                return FormValidation.error((String)String.join((CharSequence)" ", validationMessage));
            }
        }
        catch (Exception e) {
            return FormValidation.error((String)(this.AUTHORIZATION_FAILURE + this.getFormattedExceptionMessage(e.getCause().getMessage())));
        }
        return FormValidation.ok((String)this.CONNECTION_SUCCESSFUL);
    }

    @POST
    public FormValidation doTestCoverityConnection(@QueryParameter(value="coverityConnectUrl") String coverityConnectUrl, @QueryParameter(value="coverityCredentialsId") String coverityCredentialsId) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return FormValidation.warning((String)"Connection validation could not be completed: Validation couldn't retrieve the instance of Jenkins from the JVM. This may happen if Jenkins is still starting up or if this code is running on a different JVM than your Jenkins server.");
        }
        jenkins.checkPermission(Jenkins.ADMINISTER);
        if (Utility.isStringNullOrBlank(coverityConnectUrl)) {
            return FormValidation.error((String)"The Coverity connect url must be specified");
        }
        if (Utility.isStringNullOrBlank(coverityCredentialsId)) {
            return FormValidation.error((String)"The Coverity credentials must be specified");
        }
        try {
            AuthenticationSupport authenticationSupport = new AuthenticationSupport();
            HttpResponse response = authenticationSupport.attemptCoverityAuthentication(coverityConnectUrl, coverityCredentialsId, 120);
            if (response.getCode() != 200) {
                String validationMessage = this.getValidationMessage(response.getCode());
                return FormValidation.error((String)String.join((CharSequence)" ", validationMessage));
            }
        }
        catch (Exception e) {
            return FormValidation.error((String)(this.AUTHORIZATION_FAILURE + this.getFormattedExceptionMessage(e.getCause().getMessage())));
        }
        return FormValidation.ok((String)this.CONNECTION_SUCCESSFUL);
    }

    @POST
    public FormValidation doTestSrmConnection(@QueryParameter(value="srmUrl") String srmUrl, @QueryParameter(value="srmCredentialsId") String srmCredentialsId) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return FormValidation.warning((String)"Connection validation could not be completed: Validation couldn't retrieve the instance of Jenkins from the JVM. This may happen if Jenkins is still starting up or if this code is running on a different JVM than your Jenkins server.");
        }
        jenkins.checkPermission(Jenkins.ADMINISTER);
        if (Utility.isStringNullOrBlank(srmUrl)) {
            return FormValidation.error((String)"The SRM server url must be specified");
        }
        if (Utility.isStringNullOrBlank(srmCredentialsId)) {
            return FormValidation.error((String)"The SRM credentials must be specified");
        }
        try {
            AuthenticationSupport authenticationSupport = new AuthenticationSupport();
            HttpResponse response = authenticationSupport.attemptSrmAuthentication(srmUrl, srmCredentialsId, 120);
            if (response.getCode() != 200) {
                String validationMessage = this.getValidationMessage(response.getCode());
                return FormValidation.error((String)String.join((CharSequence)" ", validationMessage));
            }
        }
        catch (Exception e) {
            return FormValidation.error((String)(this.AUTHORIZATION_FAILURE + this.getFormattedExceptionMessage(e.getCause().getMessage())));
        }
        return FormValidation.ok((String)this.CONNECTION_SUCCESSFUL);
    }

    private String getFormattedExceptionMessage(String message) {
        Pattern pattern = Pattern.compile("failed: (.*)");
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return message;
    }
}

