/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan.bridge;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.TaskListener;
import io.jenkins.plugins.security.scan.exception.PluginExceptionHandler;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class BridgeDownload {
    private final LoggerWrapper logger;
    private final FilePath workspace;
    private final EnvVars envVars;
    private final Map<String, Object> scanParameters;

    public BridgeDownload(FilePath workspace, TaskListener listener, EnvVars envVars, Map<String, Object> scanParameters) {
        this.workspace = workspace;
        this.logger = new LoggerWrapper(listener);
        this.envVars = envVars;
        this.scanParameters = scanParameters;
    }

    public FilePath downloadBridgeCLI(String bridgeDownloadUrl, String bridgeInstallationPath) throws PluginExceptionHandler {
        FilePath bridgeZipFilePath = null;
        FilePath bridgeInstallationFilePath = new FilePath(this.workspace.getChannel(), bridgeInstallationPath);
        if (!this.checkIfBridgeUrlExists(bridgeDownloadUrl)) {
            this.logger.warn("Connection to the Bridge CLI download URL failed: %s", bridgeDownloadUrl);
        }
        int retryCount = 1;
        boolean downloadSuccess = false;
        while (!downloadSuccess && retryCount <= 3) {
            try {
                this.logger.info("Downloading Bridge CLI from: " + bridgeDownloadUrl, new Object[0]);
                bridgeZipFilePath = this.downloadBridge(bridgeDownloadUrl, bridgeInstallationFilePath);
                if (bridgeZipFilePath == null) continue;
                downloadSuccess = true;
            }
            catch (InterruptedException e) {
                this.logger.error("Interrupted while waiting to retry Bridge CLI download", new Object[0]);
                Thread.currentThread().interrupt();
                throw new PluginExceptionHandler(106);
            }
            catch (Exception e) {
                this.handleDownloadException(bridgeDownloadUrl, retryCount);
                ++retryCount;
            }
        }
        if (!downloadSuccess) {
            this.logger.error("Bridge CLI download failed after %s attempts", 3);
        }
        if (bridgeZipFilePath == null) {
            throw new PluginExceptionHandler(106);
        }
        return bridgeZipFilePath;
    }

    private FilePath downloadBridge(String bridgeDownloadUrl, FilePath bridgeInstallationFilePath) throws InterruptedException, IOException {
        FilePath bridgeZipFilePath = bridgeInstallationFilePath.child("bridge-cli-bundle.zip");
        HttpURLConnection connection = Utility.getHttpURLConnection(new URL(bridgeDownloadUrl), this.envVars, this.logger, this.scanParameters);
        if (connection != null) {
            try (InputStream inputStream = connection.getInputStream();){
                bridgeZipFilePath.copyFrom(inputStream);
                this.logger.info("Bridge CLI successfully downloaded in: " + String.valueOf(bridgeZipFilePath), new Object[0]);
            }
        }
        return bridgeZipFilePath;
    }

    private void handleDownloadException(String bridgeDownloadUrl, int retryCount) throws PluginExceptionHandler {
        int statusCode = this.getHttpStatusCode(bridgeDownloadUrl);
        if (this.terminateRetry(statusCode)) {
            this.logger.error("Bridge CLI download failed with status code: %s and plugin won't retry to download", statusCode);
            throw new PluginExceptionHandler(107);
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ie) {
            this.logger.warn("An exception occurred in between consecutive retry attempts: %s", ie.getMessage());
            Thread.currentThread().interrupt();
        }
        this.logger.warn("Bridge CLI download failed and attempt#%s to download again.", retryCount);
    }

    public int getHttpStatusCode(String url) {
        int statusCode = -1;
        try {
            HttpURLConnection connection = Utility.getHttpURLConnection(new URL(url), this.envVars, this.logger, this.scanParameters);
            if (connection != null) {
                connection.setRequestMethod("HEAD");
                statusCode = connection.getResponseCode();
                connection.disconnect();
            }
        }
        catch (IOException e) {
            this.logger.error("An exception occurred while checking the http status code: %s", e.getMessage());
        }
        return statusCode;
    }

    public boolean terminateRetry(int statusCode) {
        return statusCode == 401 || statusCode == 403 || statusCode == 200 || statusCode == 201 || statusCode == 416;
    }

    public boolean checkIfBridgeUrlExists(String bridgeDownloadUrl) {
        try {
            URL url = new URL(bridgeDownloadUrl);
            HttpURLConnection connection = Utility.getHttpURLConnection(url, this.envVars, this.logger, this.scanParameters);
            if (connection != null) {
                connection.setRequestMethod("HEAD");
                return connection.getResponseCode() == 200;
            }
        }
        catch (Exception e) {
            this.logger.error("An exception occurred while checking bridge url exists or not: %s", e.getMessage());
        }
        return false;
    }
}

