/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan;

import com.fasterxml.jackson.databind.JsonNode;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import io.jenkins.plugins.security.scan.action.IssueAction;
import io.jenkins.plugins.security.scan.bridge.BridgeDownloadParameters;
import io.jenkins.plugins.security.scan.exception.PluginExceptionHandler;
import io.jenkins.plugins.security.scan.global.IssueCalculator;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.Utility;
import io.jenkins.plugins.security.scan.global.enums.ReportType;
import io.jenkins.plugins.security.scan.global.enums.SecurityProduct;
import io.jenkins.plugins.security.scan.service.ParameterMappingService;
import io.jenkins.plugins.security.scan.service.ToolsParameterService;
import io.jenkins.plugins.security.scan.service.diagnostics.UploadReportService;
import io.jenkins.plugins.security.scan.service.scan.ScanParametersService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class SecurityScanner {
    private final Run<?, ?> run;
    private final TaskListener listener;
    private final LoggerWrapper logger;
    private final Launcher launcher;
    private final FilePath workspace;
    private final EnvVars envVars;
    private final ToolsParameterService toolsParameterService;

    public SecurityScanner(Run<?, ?> run, TaskListener listener, Launcher launcher, FilePath workspace, EnvVars envVars) {
        this.run = run;
        this.listener = listener;
        this.launcher = launcher;
        this.workspace = workspace;
        this.envVars = envVars;
        this.toolsParameterService = new ToolsParameterService(listener, envVars, workspace);
        this.logger = new LoggerWrapper(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runScanner(Map<String, Object> scanParams, FilePath bridgeInstallationPath, BridgeDownloadParameters bridgeDownloadParams) throws PluginExceptionHandler {
        int scanner = 0;
        List<String> commandLineArgs = this.toolsParameterService.getCommandLineArgs(scanParams, bridgeInstallationPath, bridgeDownloadParams);
        this.logger.info("Executable command line arguments: " + commandLineArgs.stream().map(arg -> arg.concat(" ")).collect(Collectors.joining()).trim(), new Object[0]);
        try {
            this.logger.println();
            this.logger.println("******************************* %s *******************************", "START EXECUTION OF BRIDGE CLI");
            scanner = this.launcher.launch().cmds(commandLineArgs).envs((Map)this.envVars).pwd(this.workspace).stdout(this.listener).quiet(true).join();
        }
        catch (Exception e) {
            try {
                this.logger.error("An exception occurred while invoking bridge-cli from the plugin: %s", e.getMessage());
                Thread.currentThread().interrupt();
            }
            catch (Throwable throwable) {
                this.logger.println("******************************* %s *******************************", "END EXECUTION OF BRIDGE CLI");
                this.toolsParameterService.removeTemporaryInputJson(commandLineArgs);
                this.handleDiagnostics(scanParams);
                this.handleSarifReports(scanParams);
                this.handleIssueCount(scanParams);
                throw throwable;
            }
            this.logger.println("******************************* %s *******************************", "END EXECUTION OF BRIDGE CLI");
            this.toolsParameterService.removeTemporaryInputJson(commandLineArgs);
            this.handleDiagnostics(scanParams);
            this.handleSarifReports(scanParams);
            this.handleIssueCount(scanParams);
        }
        this.logger.println("******************************* %s *******************************", "END EXECUTION OF BRIDGE CLI");
        this.toolsParameterService.removeTemporaryInputJson(commandLineArgs);
        this.handleDiagnostics(scanParams);
        this.handleSarifReports(scanParams);
        this.handleIssueCount(scanParams);
        return scanner;
    }

    public void handleDiagnostics(Map<String, Object> scanParams) {
        if (Objects.equals(scanParams.get("include_diagnostics"), true)) {
            UploadReportService uploadReportService = new UploadReportService(this.run, this.listener, this.launcher, this.envVars, new ArtifactArchiver("**"));
            uploadReportService.archiveReports(this.workspace.child(".bridge"), ReportType.DIAGNOSTIC);
        }
    }

    public void handleSarifReports(Map<String, Object> scanParams) {
        boolean createBlackDuckSarif = Objects.equals(scanParams.get("blackducksca_reports_sarif_create"), true);
        boolean createPolarisSarif = Objects.equals(scanParams.get("polaris_reports_sarif_create"), true);
        if (!createBlackDuckSarif && !createPolarisSarif) {
            return;
        }
        String changeId = (String)this.envVars.get((Object)"CHANGE_ID");
        boolean isPullRequest = changeId != null;
        this.logger.info((isPullRequest ? "This is a (PR/MR) event" : "This is not a (PR/MR) event") + (String)(isPullRequest ? " (PR/MR Number: " + changeId + ")" : ""), new Object[0]);
        ScanParametersService scanParametersService = new ScanParametersService(this.listener);
        Set<String> scanType = scanParametersService.getSecurityProducts(scanParams);
        boolean isBlackDuckScan = scanType.contains(SecurityProduct.BLACKDUCK.name()) || scanType.contains(SecurityProduct.BLACKDUCKSCA.name());
        boolean isPolarisScan = scanType.contains(SecurityProduct.POLARIS.name());
        boolean waitForScan = true;
        if (isBlackDuckScan && scanParams.containsKey("blackducksca_waitForScan")) {
            waitForScan = (Boolean)scanParams.get("blackducksca_waitForScan");
        } else if (isPolarisScan && scanParams.containsKey("polaris_waitForScan")) {
            waitForScan = (Boolean)scanParams.get("polaris_waitForScan");
        }
        if (isPullRequest || !waitForScan) {
            return;
        }
        String reportFilePath = Utility.resolveSarifReportFilePath(scanParams, this.workspace, isBlackDuckScan, isPolarisScan, this.logger);
        String reportFileName = Utility.determineSARIFReportFileName(reportFilePath);
        UploadReportService uploadReportService = new UploadReportService(this.run, this.listener, this.launcher, this.envVars, new ArtifactArchiver(reportFileName));
        uploadReportService.archiveReports(this.workspace.child(reportFilePath), ReportType.SARIF);
    }

    public void handleIssueCount(Map<String, Object> scanParams) {
        try {
            FilePath filePath = this.workspace.child(".bridge/output/scan_info_out.json");
            if (!filePath.exists()) {
                this.logger.info("File for issue count does not exist", new Object[0]);
                return;
            }
            this.logger.info("Retrieving the issue count from the scan results", new Object[0]);
            String product = scanParams.get("product").toString();
            String productUrl = ParameterMappingService.getProductUrl(scanParams);
            JsonNode rootNode = Utility.parseJsonFile(filePath.readToString());
            IssueCalculator issueCalculator = new IssueCalculator();
            String issuesUrl = issueCalculator.getIssuesUrl(rootNode, product.toLowerCase());
            int totalIssues = issueCalculator.calculateTotalIssues(rootNode, product.toLowerCase());
            boolean isPullRequestEvent = Utility.isPullRequestEvent(this.envVars);
            if (totalIssues != -1 && !isPullRequestEvent) {
                this.logger.info("Total issues found: " + totalIssues, new Object[0]);
                this.run.addAction((Action)new IssueAction(product.toLowerCase(), totalIssues, Utility.isStringNullOrBlank(issuesUrl) ? productUrl : issuesUrl));
            } else {
                this.logger.info("Issue count not found in output file", new Object[0]);
            }
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            this.logger.info("An exception occurred while processing JSON file for Issue count: %s", e.getMessage());
            Thread.currentThread().interrupt();
        }
    }
}

