/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.security.scan;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.TaskListener;
import io.jenkins.plugins.security.scan.SecurityScanner;
import io.jenkins.plugins.security.scan.bridge.BridgeDownloadManager;
import io.jenkins.plugins.security.scan.bridge.BridgeDownloadParameters;
import io.jenkins.plugins.security.scan.exception.PluginExceptionHandler;
import io.jenkins.plugins.security.scan.global.ApplicationConstants;
import io.jenkins.plugins.security.scan.global.LoggerWrapper;
import io.jenkins.plugins.security.scan.global.Utility;
import io.jenkins.plugins.security.scan.global.enums.SecurityProduct;
import io.jenkins.plugins.security.scan.service.ParameterMappingService;
import io.jenkins.plugins.security.scan.service.bridge.BridgeDownloadParametersService;
import io.jenkins.plugins.security.scan.service.scan.ScanParametersService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ScanInitializer {
    private final SecurityScanner scanner;
    private final FilePath workspace;
    private final TaskListener listener;
    private final EnvVars envVars;
    private final LoggerWrapper logger;

    public ScanInitializer(SecurityScanner scanner, FilePath workspace, EnvVars envVars, TaskListener listener) {
        this.scanner = scanner;
        this.workspace = workspace;
        this.listener = listener;
        this.envVars = envVars;
        this.logger = new LoggerWrapper(listener);
    }

    public int initializeScanner(Map<String, Object> scanParameters) throws PluginExceptionHandler {
        ScanParametersService scanParametersService = new ScanParametersService(this.listener);
        BridgeDownloadParameters bridgeDownloadParameters = new BridgeDownloadParameters(this.workspace, this.listener, this.envVars, scanParameters);
        BridgeDownloadParametersService bridgeDownloadParametersService = new BridgeDownloadParametersService(this.workspace, this.listener);
        BridgeDownloadParameters bridgeDownloadParams = bridgeDownloadParametersService.getBridgeDownloadParams(scanParameters, bridgeDownloadParameters);
        this.logMessagesForParameters(scanParameters, scanParametersService.getSecurityProducts(scanParameters));
        scanParametersService.performScanParameterValidation(scanParameters, this.envVars);
        bridgeDownloadParametersService.performBridgeDownloadParameterValidation(bridgeDownloadParams);
        BridgeDownloadManager bridgeDownloadManager = new BridgeDownloadManager(this.workspace, this.listener, this.envVars, scanParameters);
        bridgeDownloadParametersService.updateBridgeInstallationPath(bridgeDownloadParameters);
        boolean isNetworkAirGap = this.checkNetworkAirgap(scanParameters);
        boolean isBridgeInstalled = bridgeDownloadManager.checkIfBridgeInstalled(bridgeDownloadParams.getBridgeInstallationPath());
        boolean isBridgeDownloadRequired = true;
        this.handleNetworkAirgap(isNetworkAirGap, bridgeDownloadParams, isBridgeInstalled);
        if (scanParameters.containsKey("network_ssl_trustAll") && ((Boolean)scanParameters.get("network_ssl_trustAll")).booleanValue() && scanParameters.containsKey("network_ssl_cert_file")) {
            throw new PluginExceptionHandler(117);
        }
        if (isBridgeInstalled) {
            isBridgeDownloadRequired = bridgeDownloadManager.isBridgeDownloadRequired(bridgeDownloadParams);
        }
        this.handleBridgeDownload(isBridgeDownloadRequired, isNetworkAirGap, bridgeDownloadParams, bridgeDownloadManager);
        FilePath bridgeInstallationPath = new FilePath(this.workspace.getChannel(), bridgeDownloadParams.getBridgeInstallationPath());
        this.logger.info("Bridge CLI version is - " + bridgeDownloadParams.getBridgeDownloadVersion(), new Object[0]);
        if (scanParameters.containsKey("polaris_assessment_mode") && Utility.isVersionCompatible(bridgeDownloadParams.getBridgeDownloadVersion(), "3.8.0")) {
            this.logger.warn("Polaris Assessment Mode is deprecated. Use \"SAST Test Location (Optional)\" as \"REMOTE\" and/or \"SCA Test Location (Optional)\" as \"REMOTE\" for source upload scans instead.", new Object[0]);
        }
        return this.scanner.runScanner(scanParameters, bridgeInstallationPath, bridgeDownloadParams);
    }

    private boolean checkNetworkAirgap(Map<String, Object> scanParameters) {
        return scanParameters.containsKey("network_airgap") && scanParameters.get("network_airgap").equals(true);
    }

    private void handleNetworkAirgap(boolean isNetworkAirgap, BridgeDownloadParameters bridgeDownloadParams, boolean isBridgeInstalled) throws PluginExceptionHandler {
        if (isNetworkAirgap && !bridgeDownloadParams.getBridgeDownloadUrl().contains(".zip") && !isBridgeInstalled) {
            this.logger.error("Bridge CLI executable file could not be found at %s", bridgeDownloadParams.getBridgeInstallationPath());
            throw new PluginExceptionHandler(109);
        }
        if (isNetworkAirgap) {
            this.logger.info("Network air gap is enabled, skipping Bridge CLI download.", new Object[0]);
        }
    }

    public void handleBridgeDownload(boolean isBridgeDownloadRequired, boolean isNetworkAirgap, BridgeDownloadParameters bridgeDownloadParams, BridgeDownloadManager bridgeDownloadManager) throws PluginExceptionHandler {
        if (isBridgeDownloadRequired && bridgeDownloadParams.getBridgeDownloadUrl().contains(".zip")) {
            if (isNetworkAirgap) {
                this.logger.warn("Bridge-CLI will be downloaded from the provided custom URL. Make sure the network is reachable", new Object[0]);
            }
            bridgeDownloadManager.initiateBridgeDownloadAndUnzip(bridgeDownloadParams);
        } else {
            String os = Utility.getAgentOs(this.workspace, this.listener);
            String installedBridgeVersionFilePath = os.contains("win") ? String.join((CharSequence)"\\", bridgeDownloadParams.getBridgeInstallationPath(), "versions.txt") : String.join((CharSequence)"/", bridgeDownloadParams.getBridgeInstallationPath(), "versions.txt");
            String installedBridgeVersion = bridgeDownloadManager.getBridgeVersionFromVersionFile(installedBridgeVersionFilePath);
            bridgeDownloadParams.setBridgeDownloadVersion(installedBridgeVersion);
            this.logger.info("Bridge download is not required. Found installed in: " + bridgeDownloadParams.getBridgeInstallationPath(), new Object[0]);
        }
        this.logger.println("------------------------------------------------------------------------------------", new Object[0]);
    }

    public void logMessagesForParameters(Map<String, Object> scanParameters, Set<String> securityProducts) {
        this.logger.println("-------------------------- Parameter Validation Initiated --------------------------", new Object[0]);
        HashMap<String, Object> parametersCopy = new HashMap<String, Object>(scanParameters);
        this.logMessagesForProductParameters(parametersCopy, securityProducts);
        this.logMessagesForAdditionalParameters(parametersCopy);
        if ((Objects.equals(parametersCopy.get("blackducksca_reports_sarif_create"), true) || Objects.equals(parametersCopy.get("polaris_reports_sarif_create"), true)) && this.envVars.get((Object)"CHANGE_ID") != null) {
            this.logger.info("SARIF report create/upload is ignored for PR/MR scans", new Object[0]);
        }
    }

    private void logMessagesForProductParameters(Map<String, Object> scanParameters, Set<String> securityProducts) {
        this.logger.info(" --- product = " + securityProducts.toString(), new Object[0]);
        if (securityProducts.contains(SecurityProduct.BLACKDUCK.name())) {
            this.logger.warn("%s product is deprecated and will be removed in future. Please use %s and its corresponding parameters instead.", SecurityProduct.BLACKDUCK.name().toLowerCase(), SecurityProduct.BLACKDUCKSCA.name().toLowerCase());
        }
        for (String product : securityProducts) {
            String securityProduct = product.toLowerCase();
            this.logger.info("Parameters for %s:", securityProduct);
            this.logParameters(scanParameters, securityProduct);
            this.logger.println("------------------------------------------------------------------------------------", new Object[0]);
        }
        this.logWarningForDeprecatedParameters();
    }

    private void logParameters(Map<String, Object> scanParameters, String securityProduct) {
        for (Map.Entry<String, Object> entry : scanParameters.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!this.shouldLogParameter(securityProduct, key)) continue;
            if (this.isSensitiveKey(key)) {
                value = "******************************************************************************";
            }
            this.logger.info(" --- " + key + " = " + value.toString(), new Object[0]);
        }
    }

    private boolean shouldLogParameter(String securityProduct, String key) {
        List<String> arbitraryParamList = ApplicationConstants.ARBITRARY_PARAM_KEYS;
        if (!securityProduct.equalsIgnoreCase(SecurityProduct.BLACKDUCKSCA.name()) && !securityProduct.equalsIgnoreCase(SecurityProduct.BLACKDUCK.name()) && key.contains("blackducksca_scan_full")) {
            return false;
        }
        return key.contains(securityProduct) || key.equals("project_directory") || key.startsWith("detect_") || securityProduct.equals(SecurityProduct.POLARIS.name().toLowerCase()) && (key.startsWith("project_") || arbitraryParamList.contains(key)) || securityProduct.equals(SecurityProduct.SRM.name().toLowerCase()) && (key.equals("detect_execution_path") || key.equals("coverity_execution_path") || arbitraryParamList.contains(key));
    }

    private boolean isSensitiveKey(String key) {
        return key.equals("blackducksca_token") || key.equals("polaris_access_token") || key.equals("coverity_passphrase") || key.equals("srm_apikey");
    }

    private void logMessagesForAdditionalParameters(Map<String, Object> scanParameters) {
        boolean additionalParamsFound = false;
        for (Map.Entry<String, Object> entry : scanParameters.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("bridgecli_") && !key.startsWith("network_") && !key.equals("include_diagnostics") && !key.equals("mark_build_status")) continue;
            if (!additionalParamsFound) {
                this.logger.info("Parameters for additional configuration:", new Object[0]);
                additionalParamsFound = true;
            }
            Object value = entry.getValue();
            this.logger.info(" --- " + key + " = " + value.toString(), new Object[0]);
        }
    }

    private void logWarningForDeprecatedParameters() {
        if (!ParameterMappingService.getDeprecatedParameters().isEmpty()) {
            this.logger.warn("%s is/are deprecated and will be removed in future. Check documentation for new parameters: %s", ParameterMappingService.getDeprecatedParameters().toString(), "https://documentation.blackduck.com/bundle/bridge/page/documentation/c_using-jenkins-plugin.html");
            ParameterMappingService.getDeprecatedParameters().clear();
        }
    }
}

