/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.Bdio;
import com.blackducksoftware.bdio2.BdioMetadata;
import com.blackducksoftware.bdio2.LegacyJsonParserEmitter;
import com.blackducksoftware.bdio2.LegacyScanContainerEmitter;
import com.blackducksoftware.bdio2.LegacyUtilities;
import com.blackducksoftware.bdio2.model.File;
import com.blackducksoftware.bdio2.model.FileCollection;
import com.blackducksoftware.bdio2.model.Project;
import com.blackducksoftware.common.base.ExtraStrings;
import com.blackducksoftware.common.value.Product;
import com.blackducksoftware.common.value.ProductList;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.JsonEOFException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

class LegacyStreamingScanContainerEmitter
extends LegacyJsonParserEmitter {
    private BdioMetadata metadata;
    private Function<File, Map<String, Object>> base;
    private Predicate<LegacyScanContainerEmitter.LegacyScanNode> isBase;
    private String hostName;
    private String baseDir;
    private List<Map<String, Object>> graph;
    private int estimatedSize;

    public LegacyStreamingScanContainerEmitter(InputStream inputStream) {
        super(LegacyUtilities.scanContainerObjectMapper().getFactory(), inputStream);
    }

    @Override
    protected Object next(JsonParser jp) throws IOException {
        List<Map<String, Object>> graph;
        if (this.metadata == null) {
            if (jp.nextToken() != null) {
                if (!jp.isExpectedStartObjectToken()) {
                    throw JsonMappingException.from((JsonParser)jp, (String)"expected start object");
                }
                this.parseMetadata(jp);
                return this.metadata.asNamedGraph();
            }
        } else if (this.graph != null && !(graph = this.parseGraph(jp)).isEmpty()) {
            return this.metadata.asNamedGraph(graph, "@id", "@type");
        }
        return null;
    }

    private void parseMetadata(JsonParser jp) throws IOException {
        this.metadata = new BdioMetadata();
        this.metadata.scanType(Bdio.ScanType.SIGNATURE);
        String project = null;
        String release = null;
        ZonedDateTime createdOn = null;
        Long timeToScan = null;
        Long mct = null;
        String fieldName = jp.nextFieldName();
        while (fieldName != null) {
            switch (fieldName) {
                case "matchConfidenceThreshold": {
                    mct = jp.nextLongValue(-1L);
                    this.metadata.matchConfidenceThreshold(mct);
                    break;
                }
                case "scanNodeList": {
                    this.finishMetadata(jp, this.metadata, project, release, createdOn, timeToScan);
                    return;
                }
                case "hostName": {
                    this.hostName = jp.nextTextValue();
                    this.metadata.creator(null, this.hostName);
                    break;
                }
                case "baseDir": {
                    this.baseDir = ExtraStrings.removeSuffix((CharSequence)jp.nextTextValue(), (CharSequence)"/");
                    this.isBase = LegacyScanContainerEmitter.LegacyScanNode.isBase(this.baseDir);
                    break;
                }
                case "scannerVersion": {
                    this.metadata.merge(LegacyStreamingScanContainerEmitter.publisher(LegacyStreamingScanContainerEmitter.scanClient().version((CharSequence)jp.nextTextValue()).build()));
                    break;
                }
                case "signatureVersion": {
                    this.metadata.merge(LegacyStreamingScanContainerEmitter.publisher(LegacyStreamingScanContainerEmitter.scanClient().addCommentText((CharSequence)"signature %s", new Object[]{jp.nextTextValue()}).build()));
                    break;
                }
                case "ownerEntityKeyToken": {
                    String ownerEntityKeyToken = Strings.nullToEmpty((String)jp.nextTextValue());
                    if (ownerEntityKeyToken.startsWith("SP#")) {
                        this.metadata.merge(LegacyStreamingScanContainerEmitter.publisher(LegacyStreamingScanContainerEmitter.scanClient().addCommentText((CharSequence)"snippets", new Object[0]).build()));
                        break;
                    }
                    if (!ownerEntityKeyToken.startsWith("SG#")) break;
                    this.metadata.merge(LegacyStreamingScanContainerEmitter.publisher(LegacyStreamingScanContainerEmitter.scanClient().addCommentText((CharSequence)"string_search", new Object[0]).build()));
                    break;
                }
                case "name": {
                    this.metadata.name(Strings.emptyToNull((String)jp.nextTextValue()));
                    break;
                }
                case "createdOn": {
                    jp.nextToken();
                    createdOn = ((Date)jp.readValueAs(Date.class)).toInstant().atZone(ZoneOffset.UTC);
                    break;
                }
                case "timeToScan": {
                    timeToScan = jp.nextLongValue(0L);
                    break;
                }
                case "project": {
                    project = jp.nextTextValue();
                    break;
                }
                case "release": {
                    release = jp.nextTextValue();
                    break;
                }
                default: {
                    if (!jp.nextToken().isStructStart()) break;
                    jp.skipChildren();
                }
            }
            fieldName = jp.nextFieldName();
        }
    }

    private void finishMetadata(JsonParser jp, BdioMetadata metadata, @Nullable String project, @Nullable String release, @Nullable ZonedDateTime createdOn, @Nullable Long timeToScan) throws IOException {
        metadata.creationDateTime(createdOn);
        metadata.captureInterval(createdOn, createdOn != null && timeToScan != null ? createdOn.plus(timeToScan, ChronoUnit.MILLIS) : null);
        String name = (String)metadata.get(Bdio.DataProperty.name.toString());
        if (name != null) {
            metadata.id(LegacyUtilities.toNameUri(name));
        } else {
            metadata.id(LegacyUtilities.toFileUri(this.hostName, this.baseDir, null));
            metadata.name(this.hostName + "#" + this.baseDir);
        }
        metadata.merge(LegacyStreamingScanContainerEmitter.publisher(new Product.Builder().simpleName(LegacyScanContainerEmitter.class).implementationVersion(LegacyScanContainerEmitter.class).addComment((CharSequence)"(streaming)").build()));
        if (jp.nextToken() == null || !jp.isExpectedStartArrayToken()) {
            throw JsonMappingException.from((JsonParser)jp, (String)"expected start array");
        }
        String rootId = LegacyUtilities.toFileUri(this.hostName, this.baseDir, "root");
        if (project != null) {
            this.offer(new Project(rootId).name(project).version(release));
            this.base = f -> new Project(rootId).base((File)f);
        } else {
            this.offer(new FileCollection(rootId));
            this.base = f -> new FileCollection(rootId).base((File)f);
        }
    }

    private List<Map<String, Object>> parseGraph(JsonParser jp) throws IOException {
        while (jp.nextToken() != null) {
            if (jp.isExpectedStartObjectToken()) {
                LegacyScanContainerEmitter.LegacyScanNode scanNode = (LegacyScanContainerEmitter.LegacyScanNode)jp.readValueAs(LegacyScanContainerEmitter.LegacyScanNode.class);
                File file = new File(LegacyUtilities.toFileUri(this.hostName, this.baseDir, scanNode.toString())).fileSystemType(scanNode.fileSystemType()).path(scanNode.path(this.baseDir, null)).byteCount(scanNode.byteCount()).fingerprint(scanNode.fingerprint());
                if (this.isBase.test(scanNode)) {
                    this.offer(this.base.apply(file));
                }
                if (this.offer(file)) continue;
                List<Map<String, Object>> result = this.finishEntry();
                this.offer(file);
                return result;
            }
            if (!jp.hasToken(JsonToken.END_ARRAY)) continue;
            return this.finishEntry();
        }
        throw new JsonEOFException(jp, jp.currentToken(), "unexpected end of stream");
    }

    private boolean offer(Map<String, Object> node) {
        int nodeSize;
        if (this.graph == null) {
            this.graph = new ArrayList<Map<String, Object>>(LegacyUtilities.averageEntryNodeCount());
            this.estimatedSize = LegacyUtilities.estimateEntryOverhead(this.metadata);
        }
        if (this.estimatedSize + (nodeSize = LegacyUtilities.estimateSize(node)) < 0x1000000) {
            this.estimatedSize += nodeSize;
            return this.graph.add(node);
        }
        return false;
    }

    private List<Map<String, Object>> finishEntry() {
        if (this.graph != null && !this.graph.isEmpty()) {
            List<Map<String, Object>> result = this.graph;
            this.graph = null;
            return result;
        }
        return Collections.emptyList();
    }

    private static Map<String, Object> publisher(Product product) {
        return ImmutableMap.of((Object)Bdio.DataProperty.publisher.toString(), (Object)ProductList.of((Product)product));
    }

    private static Product.Builder scanClient() {
        return new Product.Builder().name((CharSequence)"ScanClient");
    }
}

