/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.Bdio;
import com.blackducksoftware.bdio2.BdioMetadata;
import com.blackducksoftware.bdio2.BdioObject;
import com.blackducksoftware.bdio2.LegacyJsonParserEmitter;
import com.blackducksoftware.bdio2.LegacyUtilities;
import com.blackducksoftware.bdio2.model.Annotation;
import com.blackducksoftware.bdio2.model.Component;
import com.blackducksoftware.bdio2.model.Dependency;
import com.blackducksoftware.bdio2.model.File;
import com.blackducksoftware.bdio2.model.FileCollection;
import com.blackducksoftware.bdio2.model.License;
import com.blackducksoftware.bdio2.model.Project;
import com.blackducksoftware.common.base.ExtraOptionals;
import com.blackducksoftware.common.base.ExtraStreams;
import com.blackducksoftware.common.base.ExtraStrings;
import com.blackducksoftware.common.value.Digest;
import com.blackducksoftware.common.value.Product;
import com.blackducksoftware.common.value.ProductList;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.JsonParserDelegate;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;

class LegacyBdio1xEmitter
extends LegacyJsonParserEmitter {
    private static final String VOCAB = "http://blackducksoftware.com/rdf/terms#";
    private static Pattern SPDX_CREATOR = Pattern.compile("(?:Person: (?<personName>.*))|(?:Tool: (?<toolName>.*?)(?:-(?<toolVersion>.+))?)|(?:Organization: (?<organizationName>.*))");
    private static final CharMatcher PRODUCT_TOKEN_CHAR = CharMatcher.anyOf((CharSequence)"!#$%&'*+-.^_`|~").or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.inRange((char)'a', (char)'z')).or(CharMatcher.inRange((char)'A', (char)'Z'));
    private final NodeComputer computedNodes = new NodeComputer();
    private final Deque<Map<String, Object>> unconvertedNodes = new ArrayDeque<Map<String, Object>>();
    private final Map<String, Object> currentNode = new LinkedHashMap<String, Object>();
    private Archive archive;
    private BdioMetadata metadata;

    public LegacyBdio1xEmitter(InputStream inputStream) {
        super(new Bdio1JsonFactory(), inputStream);
    }

    @Override
    protected Object next(JsonParser jsonParser) throws IOException {
        Bdio1JsonParser jp = Bdio1JsonParser.create(jsonParser);
        if (this.metadata == null) {
            if (jp.nextToken() != null) {
                if (!jp.isExpectedStartArrayToken()) {
                    throw JsonMappingException.from((JsonParser)jp, (String)"expected start array");
                }
                this.parseMetadata(jp);
                return this.metadata.asNamedGraph();
            }
        } else {
            List<Map<String, Object>> graph = this.parseGraph(jp);
            if (!graph.isEmpty()) {
                return this.metadata.asNamedGraph(graph, "@id", "@type");
            }
        }
        return null;
    }

    private void parseMetadata(Bdio1JsonParser jp) throws IOException {
        while (this.readNode(jp)) {
            if (this.currentType().equals("BillOfMaterials")) {
                this.metadata = new BdioMetadata().id(ExtraStrings.beforeLast((CharSequence)this.currentId(), (char)'#'));
                this.metadata.scanType(Bdio.ScanType.PACKAGE_MANAGER);
                Optional<String> name = this.currentValue("spdx:name").filter(s -> !s.isEmpty());
                name.ifPresent(this.metadata::name);
                name.map(LegacyUtilities::toNameUri).ifPresent(this.metadata::id);
                this.convertCreationInfo(this.metadata::creationDateTime, this.metadata::creator, this.metadata::publisher);
                return;
            }
            this.unconvertedNodes.add(new LinkedHashMap<String, Object>(this.currentNode));
        }
        this.metadata = BdioMetadata.createRandomUUID();
        this.metadata.publisher(ProductList.of((Product)LegacyBdio1xEmitter.product().build()));
        this.metadata.scanType(Bdio.ScanType.PACKAGE_MANAGER);
    }

    private List<Map<String, Object>> parseGraph(Bdio1JsonParser jp) throws IOException {
        ArrayList<Map<String, Object>> graph = new ArrayList<Map<String, Object>>(LegacyUtilities.averageEntryNodeCount());
        int size = this.fillGraphNodes(jp, graph, LegacyUtilities.estimateEntryOverhead(this.metadata));
        if (graph.isEmpty() && this.computedNodes.finish()) {
            this.fillGraphNodes(jp, graph, size);
        }
        return graph;
    }

    private int fillGraphNodes(Bdio1JsonParser jp, List<Map<String, Object>> graph, int size) throws IOException {
        AtomicInteger estimatedSize = new AtomicInteger(size);
        Consumer<Map> addToGraph = node -> {
            if (estimatedSize.addAndGet(LegacyUtilities.estimateSize(node)) < 0x5A00000) {
                graph.add((Map<String, Object>)node);
            } else {
                this.computedNodes.addFirst((Map<String, Object>)node);
            }
        };
        while (estimatedSize.get() < 0x5A00000) {
            Map<String, Object> computedNode = this.computedNodes.pollFirst();
            if (computedNode != null) {
                addToGraph.accept(computedNode);
                continue;
            }
            Map<String, Object> bufferedNode = this.unconvertedNodes.pollFirst();
            if (bufferedNode != null) {
                this.currentNode.clear();
                this.currentNode.putAll(bufferedNode);
            } else if (!this.readNode(jp)) break;
            this.convert(addToGraph);
        }
        return estimatedSize.get();
    }

    private boolean readNode(Bdio1JsonParser jp) throws IOException {
        this.currentNode.clear();
        if (jp.nextToken() == JsonToken.START_OBJECT) {
            String fieldName;
            while (jp.nextToken() == JsonToken.FIELD_NAME && (fieldName = jp.getCurrentName()) != null) {
                this.currentNode.put(fieldName, jp.nextFieldValue());
            }
            return true;
        }
        return false;
    }

    private String currentId() {
        Object id = this.currentNode.get("@id");
        Preconditions.checkState((id == null || id instanceof String ? 1 : 0) != 0, (String)"current identifier must be a string: %s", (Object)id);
        if (Strings.isNullOrEmpty((String)((String)id))) {
            id = BdioObject.randomId();
            this.currentNode.put("@id", id);
        }
        return (String)id;
    }

    private String currentType() {
        Object type = this.currentNode.get("@type");
        if (type instanceof List) {
            type = ((List)type).get(0);
        }
        Preconditions.checkState((boolean)(type instanceof String), (String)"current type must be a string: %s", (Object)type);
        return ExtraStrings.removePrefix((CharSequence)((String)type), (CharSequence)VOCAB);
    }

    private Optional<String> currentValue(Object ... paths) {
        return this.currentValue(String.class, paths);
    }

    private Stream<String> currentValues(Object ... paths) {
        return this.currentValues(String.class, paths);
    }

    private <T> Stream<T> currentValues(Class<T> type, Object ... paths) {
        Object value = this.currentValue(Object.class, paths).orElse(null);
        if (value instanceof Iterable) {
            return Streams.stream((Iterable)value).flatMap(ExtraStreams.ofType(type));
        }
        return type.isInstance(value) ? Stream.of(type.cast(value)) : Stream.empty();
    }

    private <T> Optional<T> currentValue(Class<T> type, Object ... paths) {
        Object result = this.currentNode;
        for (Object path : paths) {
            if (result instanceof Map) {
                if (path.equals(0)) continue;
                result = result.get(path);
                continue;
            }
            if (result instanceof List) {
                result = ((List)result).get((Integer)path);
                continue;
            }
            if (result != null) continue;
            return Optional.empty();
        }
        return type.isInstance(result) ? Optional.of(type.cast(result)) : Optional.empty();
    }

    private int currentSize(Object ... paths) {
        return this.currentValue(Object.class, paths).map(obj -> {
            if (obj instanceof List) {
                return ((List)obj).size();
            }
            return 1;
        }).orElse(0);
    }

    private void convert(Consumer<? super Map<String, Object>> graph) {
        String type = this.currentType();
        if (type.equals("Project")) {
            if (this.currentValue("name").isPresent()) {
                this.convertProject(graph);
                this.computedNodes.setRootProjectId(this.currentId());
            } else {
                this.convertFileCollection(graph);
                this.computedNodes.setRootFileCollectionId(this.currentId());
            }
        } else if (type.equals("Component")) {
            this.convertComponent(graph);
        } else if (type.equals("License")) {
            this.convertLicense(graph);
        } else if (type.equals("File")) {
            this.convertFile(graph, this.computedNodes::addRootDependency);
            this.computedNodes.addFile(this.currentId(), this.currentValue("fileName").orElse(null));
        }
    }

    private void convertProject(Consumer<? super Project> project) {
        Project result = new Project(this.currentId());
        this.currentValue("name").ifPresent(result::name);
        this.currentValue("revision").ifPresent(result::version);
        this.convertExternalIdentifier(result::namespace, result::identifier, result::context);
        this.convertRelationships(result::dependency);
        this.convertComment(result::description);
        project.accept(result);
    }

    private void convertFileCollection(Consumer<? super FileCollection> fileCollection) {
        FileCollection result = new FileCollection(this.currentId());
        this.convertComment(result::description);
        fileCollection.accept(result);
    }

    private void convertComponent(Consumer<? super Component> component) {
        Component result = new Component(this.currentId());
        this.currentValue("name").ifPresent(result::name);
        this.currentValue("homepage").ifPresent(result::homepage);
        this.convertRevision(result::version);
        this.currentValue("license").ifPresent(result::license);
        this.convertExternalIdentifier(result::namespace, result::identifier, result::context);
        this.convertRelationships(result::dependency);
        this.convertComment(result::description);
        component.accept(result);
    }

    private void convertLicense(Consumer<? super License> license) {
        License result = new License(this.currentId());
        this.currentValue("spdx:name").ifPresent(result::name);
        this.convertExternalIdentifier(result::namespace, result::identifier, result::context);
        this.convertComment(result::description);
        license.accept(result);
    }

    private void convertFile(Consumer<? super File> file, Consumer<? super Dependency> dependency) {
        File result = new File(this.currentId());
        this.currentValue(Number.class, "size").map(Number::longValue).ifPresent(result::byteCount);
        this.convertPath(result::path);
        this.convertFileTypes(result::fileSystemType);
        this.convertChecksums(result::fingerprint);
        this.convertMatchDetail(result, dependency);
        this.convertComment(result::description);
        this.currentValue("artifactOf").map(dependsOn -> {
            Dependency dep = new Dependency().dependsOn(dependsOn).evidence(result);
            this.currentValue("licenseConcluded").ifPresent(dep::license);
            return dep;
        }).ifPresent(dependency);
        if (Objects.equals(this.currentValue("fileName").orElse(null), "./") && this.currentValue(Number.class, "size").orElse(-1).longValue() == 0L) {
            result.remove(Bdio.DataProperty.byteCount.toString());
        }
        if (result.size() > 2) {
            file.accept(result);
        }
    }

    private void convertComment(Consumer<Annotation> annotation) {
        this.currentValue("rdfs:comment").map(comment -> new Annotation().comment((String)comment)).ifPresent(annotation);
    }

    private void convertCreationInfo(Consumer<ZonedDateTime> creationDateTime, Consumer<String> creator, Consumer<ProductList> producer) {
        this.currentValue("creationInfo", "spdx:created").flatMap(dateTime -> {
            try {
                return Optional.of(OffsetDateTime.parse(dateTime).toZonedDateTime());
            }
            catch (DateTimeParseException e) {
                return Optional.empty();
            }
        }).ifPresent(creationDateTime);
        String hostname = Optional.of(this.currentId()).flatMap(id -> {
            try {
                return Optional.ofNullable(ExtraStrings.ensurePrefix((CharSequence)"@", (CharSequence)URI.create(id).getHost()));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }).orElse("");
        StringJoiner creatorBuilder = new StringJoiner(",");
        ProductList.Builder producerBuilder = new ProductList.Builder();
        this.currentValues("creationInfo", "spdx:creator").map(SPDX_CREATOR::matcher).filter(Matcher::matches).forEach(m -> {
            if (Strings.emptyToNull((String)m.group("personName")) != null) {
                creatorBuilder.add(m.group("personName") + hostname);
            } else if (m.group("toolName") != null) {
                String name = Strings.emptyToNull((String)PRODUCT_TOKEN_CHAR.retainFrom((CharSequence)m.group("toolName")));
                String version = Optional.ofNullable(m.group("toolVersion")).map(arg_0 -> ((CharMatcher)PRODUCT_TOKEN_CHAR).retainFrom(arg_0)).flatMap(ExtraStrings::ofEmpty).orElse(null);
                if (name != null) {
                    producerBuilder.addProduct(new Product.Builder().name((CharSequence)name).version((CharSequence)version).build());
                }
            }
        });
        String specVersion = this.currentValue("specVersion").filter(s -> !s.isEmpty()).orElse("1.0.0");
        Bdio.Context.forSpecVersion(specVersion);
        producerBuilder.addProduct(LegacyBdio1xEmitter.product().addCommentText((CharSequence)"bdio %s", new Object[]{specVersion}).build());
        creator.accept(ExtraStrings.ofEmpty((CharSequence)creatorBuilder.toString()).orElse(Strings.emptyToNull((String)hostname)));
        producer.accept(producerBuilder.build());
    }

    private void convertExternalIdentifier(Consumer<String> namespace, Consumer<String> identifier, Consumer<String> repository) {
        this.currentValue("externalIdentifier", 0, "externalSystemTypeId").map(LegacyBdio1xEmitter::toNamespace).ifPresent(namespace);
        this.currentValue("externalIdentifier", 0, "externalId").ifPresent(identifier);
        this.currentValue("externalIdentifier", 0, "externalRepositoryLocation").ifPresent(repository);
    }

    private void convertRevision(Consumer<String> version) {
        Optional<String> versionValue = this.findExternalId((systemTypeId, id) -> {
            if (LegacyBdio1xEmitter.checkIdentifier(systemTypeId, "npm", "http://blackducksoftware.com/rdf/terms#externalIdentifier_npm")) {
                return ExtraStrings.afterLast((CharSequence)id, (char)'@');
            }
            if (LegacyBdio1xEmitter.checkIdentifier(systemTypeId, "rubygems", "http://blackducksoftware.com/rdf/terms#externalIdentifier_rubygems")) {
                return ExtraStrings.afterLast((CharSequence)id, (char)'=');
            }
            return null;
        });
        ExtraOptionals.or(versionValue, () -> this.currentValue("revision")).ifPresent(version);
    }

    private <R> Optional<R> findExternalId(BiFunction<String, String, R> f) {
        Optional result = Optional.empty();
        int externalIdentifierSize = this.currentSize("externalIdentifier");
        for (int index = 0; index < externalIdentifierSize && !result.isPresent(); ++index) {
            Optional<String> externalSystemTypeId = this.currentValue("externalIdentifier", index, "externalSystemTypeId");
            Optional<String> externalId = this.currentValue("externalIdentifier", index, "externalId");
            result = ExtraOptionals.map(externalSystemTypeId, externalId, f);
        }
        return result;
    }

    private void convertPath(Consumer<String> path) {
        this.currentValue("fileName").ifPresent(fileName -> {
            Archive currentArchive;
            if (this.currentValues("fileType").flatMap(LegacyBdio1xEmitter::toFileSystemType).anyMatch(Predicate.isEqual(Bdio.FileSystemType.DIRECTORY_ARCHIVE.toString()))) {
                this.archive = new Archive(this.archive, (String)fileName);
                currentArchive = this.archive.container;
            } else {
                while (this.archive != null && !fileName.startsWith(this.archive.fileName)) {
                    this.archive = this.archive.container;
                }
                currentArchive = this.archive;
            }
            path.accept(Archive.computePath(currentArchive, fileName));
        });
    }

    private void convertFileTypes(Consumer<String> fileSystemType) {
        this.currentValues("fileType").flatMap(LegacyBdio1xEmitter::toFileSystemType).limit(1L).forEach(fileSystemType);
    }

    private void convertChecksums(Consumer<Collection<Digest>> fingerprint) {
        int checksumSize = this.currentSize("checksum");
        ArrayList fingerprints = new ArrayList(checksumSize);
        for (int index = 0; index < checksumSize; ++index) {
            Optional algorithm = this.currentValue("checksum", index, "algorithm").flatMap(LegacyBdio1xEmitter::toDigestAlgorithm);
            Optional<String> checksumValue = this.currentValue("checksum", index, "checksumValue");
            ExtraOptionals.map(algorithm, checksumValue, Digest::of).ifPresent(fingerprints::add);
        }
        if (!fingerprints.isEmpty()) {
            fingerprint.accept(fingerprints);
        }
    }

    private void convertMatchDetail(File file, Consumer<? super Dependency> dependency) {
        this.currentValue("matchDetail", "artifactOf").flatMap(dependsOn -> {
            Dependency dep = new Dependency().dependsOn(dependsOn);
            this.currentValue("matchDetail", "licenseConcluded").ifPresent(dep::license);
            String matchType = this.currentValue("matchDetail", "matchType").orElse(null);
            if (matchType == null) {
                dep.evidence(file);
            } else if (LegacyBdio1xEmitter.checkIdentifier(matchType, "PARTIAL", "http://blackducksoftware.com/rdf/terms#matchType_partial")) {
                dep.evidence(file);
                dep.range("bytes */0");
            } else if (LegacyBdio1xEmitter.checkIdentifier(matchType, "DEPENDENCY", "http://blackducksoftware.com/rdf/terms#matchType_dependency")) {
                dep.declaredBy(file);
            } else {
                return Optional.empty();
            }
            return Optional.of(dep);
        }).ifPresent(dependency);
    }

    private void convertRelationships(Consumer<Dependency> dependency) {
        int relationshipSize = this.currentSize("relationship");
        for (int index = 0; index < relationshipSize; ++index) {
            Optional<String> relationshipType = this.currentValue("relationship", index, "relationshipType");
            Optional<String> related = this.currentValue("relationship", index, "related");
            if (!relationshipType.isPresent() || !related.isPresent() || !LegacyBdio1xEmitter.checkIdentifier(relationshipType.get(), "DYNAMIC_LINK", "http://blackducksoftware.com/rdf/terms#relationshipType_dynamicLink")) continue;
            Dependency dep = new Dependency().dependsOn(related.get());
            dependency.accept(dep);
        }
    }

    private static Stream<String> toFileSystemType(String fileType) {
        if (LegacyBdio1xEmitter.checkIdentifier(fileType, "BINARY", "http://spdx.org/rdf/terms#fileType_binary") || LegacyBdio1xEmitter.checkIdentifier(fileType, "APPLICATION", "http://spdx.org/rdf/terms#fileType_application")) {
            return Stream.of(Bdio.FileSystemType.REGULAR.toString());
        }
        if (LegacyBdio1xEmitter.checkIdentifier(fileType, "TEXT", "http://spdx.org/rdf/terms#fileType_text") || LegacyBdio1xEmitter.checkIdentifier(fileType, "SOURCE", "http://spdx.org/rdf/terms#fileType_source")) {
            return Stream.of(Bdio.FileSystemType.REGULAR_TEXT.toString());
        }
        if (LegacyBdio1xEmitter.checkIdentifier(fileType, "DIRECTORY", "http://blackducksoftware.com/rdf/terms#fileType_directory")) {
            return Stream.of(Bdio.FileSystemType.DIRECTORY.toString());
        }
        if (LegacyBdio1xEmitter.checkIdentifier(fileType, "ARCHIVE", "http://spdx.org/rdf/terms#fileType_archive")) {
            return Stream.of(Bdio.FileSystemType.DIRECTORY_ARCHIVE.toString());
        }
        return Stream.empty();
    }

    private static Optional<String> toDigestAlgorithm(String algorithm) {
        if (LegacyBdio1xEmitter.checkIdentifier(algorithm, "sha1", "http://spdx.org/rdf/terms#checksumAlgorithm_sha1")) {
            return Optional.of("sha1");
        }
        if (LegacyBdio1xEmitter.checkIdentifier(algorithm, "sha256", "http://spdx.org/rdf/terms#checksumAlgorithm_sha256")) {
            return Optional.of("sha256");
        }
        if (LegacyBdio1xEmitter.checkIdentifier(algorithm, "md5", "http://spdx.org/rdf/terms#checksumAlgorithm_md5")) {
            return Optional.of("md5");
        }
        if (algorithm.indexOf(58) <= 0) {
            return Optional.of(algorithm);
        }
        return Optional.empty();
    }

    private static String toNamespace(String externalSystemTypeId) {
        if (LegacyBdio1xEmitter.checkIdentifier(externalSystemTypeId, "anaconda", "http://blackducksoftware.com/rdf/terms#externalIdentifier_anaconda")) {
            return "anaconda";
        }
        if (LegacyBdio1xEmitter.checkIdentifier(externalSystemTypeId, "bower", "http://blackducksoftware.com/rdf/terms#externalIdentifier_bower")) {
            return "bower";
        }
        if (LegacyBdio1xEmitter.checkIdentifier(externalSystemTypeId, "cocoapods", "http://blackducksoftware.com/rdf/terms#externalIdentifier_cocoapods")) {
            return "cocoapods";
        }
        if (LegacyBdio1xEmitter.checkIdentifier(externalSystemTypeId, "cpan", "http://blackducksoftware.com/rdf/terms#externalIdentifier_cpan")) {
            return "cpan";
        }
        if (LegacyBdio1xEmitter.checkIdentifier(externalSystemTypeId, "goget", "http://blackducksoftware.com/rdf/terms#externalIdentifier_goget")) {
            return "goget";
        }
        if (LegacyBdio1xEmitter.checkIdentifier(externalSystemTypeId, "maven", "http://blackducksoftware.com/rdf/terms#externalIdentifier_maven")) {
            return "maven";
        }
        if (LegacyBdio1xEmitter.checkIdentifier(externalSystemTypeId, "npm", "http://blackducksoftware.com/rdf/terms#externalIdentifier_npm")) {
            return "npm";
        }
        if (LegacyBdio1xEmitter.checkIdentifier(externalSystemTypeId, "nuget", "http://blackducksoftware.com/rdf/terms#externalIdentifier_nuget")) {
            return "nuget";
        }
        if (LegacyBdio1xEmitter.checkIdentifier(externalSystemTypeId, "rubygems", "http://blackducksoftware.com/rdf/terms#externalIdentifier_rubygems")) {
            return "rubygems";
        }
        if (LegacyBdio1xEmitter.checkIdentifier(externalSystemTypeId, "bdsuite", "http://blackducksoftware.com/rdf/terms#externalIdentifier_bdsuite")) {
            return "bdsuite";
        }
        if (LegacyBdio1xEmitter.checkIdentifier(externalSystemTypeId, "bdhub", "http://blackducksoftware.com/rdf/terms#externalIdentifier_bdhub")) {
            return "bdhub";
        }
        if (LegacyBdio1xEmitter.checkIdentifier(externalSystemTypeId, "openhub", "http://blackducksoftware.com/rdf/terms#externalIdentifier_openhub")) {
            return "openhub";
        }
        return externalSystemTypeId;
    }

    private static boolean checkIdentifier(String value, String term, String iri) {
        String valueIri;
        if (value.equals(term) || value.equals(iri) || value.equals(ExtraStrings.removePrefix((CharSequence)iri, (CharSequence)VOCAB))) {
            return true;
        }
        List parts = Splitter.on((String)":_").limit(2).splitToList((CharSequence)value);
        return parts.size() == 2 && (valueIri = ExtraStrings.beforeFirst((CharSequence)iri, (char)'#') + '#' + (String)parts.get(0) + '_' + (String)parts.get(1)).equals(iri);
    }

    private static Product.Builder product() {
        return new Product.Builder().simpleName(LegacyBdio1xEmitter.class).implementationVersion(LegacyBdio1xEmitter.class);
    }

    private static class Bdio1JsonParser
    extends JsonParserDelegate {
        private static final ImmutableMap<String, String> PREFIXES = ImmutableMap.builder().put((Object)"spdx:", (Object)"http://spdx.org/rdf/terms#").put((Object)"doap:", (Object)"http://usefulinc.com/ns/doap#").put((Object)"rdfs:", (Object)"http://www.w3.org/2000/01/rdf-schema#").put((Object)"xsd:", (Object)"http://www.w3.org/2001/XMLSchema#").build();

        public static Bdio1JsonParser create(JsonParser jp) {
            return jp instanceof Bdio1JsonParser ? (Bdio1JsonParser)jp : new Bdio1JsonParser(jp);
        }

        private Bdio1JsonParser(JsonParser d) {
            super(Objects.requireNonNull(d));
        }

        public String nextFieldName() throws IOException {
            return Bdio1JsonParser.applyPrefix(super.nextFieldName());
        }

        public Object nextFieldValue() throws IOException {
            JsonToken currToken = this.nextToken();
            if (currToken.isBoolean()) {
                return this.getBooleanValue();
            }
            if (currToken.isNumeric()) {
                return this.getNumberValue();
            }
            if (currToken == JsonToken.VALUE_STRING) {
                return this.getText();
            }
            if (currToken == JsonToken.VALUE_NULL) {
                return null;
            }
            if (currToken == JsonToken.START_ARRAY) {
                ArrayList<Object> result = new ArrayList<Object>();
                Object element = this.nextFieldValue();
                while (this.getCurrentToken() != JsonToken.END_ARRAY) {
                    result.add(element);
                    element = this.nextFieldValue();
                }
                return result;
            }
            if (currToken == JsonToken.END_ARRAY) {
                return null;
            }
            if (currToken == JsonToken.START_OBJECT) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                while (this.nextToken() == JsonToken.FIELD_NAME) {
                    result.put(Bdio1JsonParser.applyPrefix(this.getCurrentName()), this.nextFieldValue());
                }
                return result;
            }
            throw JsonMappingException.from((JsonParser)this, (String)"unexpected field value token");
        }

        @Nullable
        private static String applyPrefix(@Nullable String value) {
            if (value == null || value.length() <= 26 || value.charAt(0) == '@') {
                return value;
            }
            if (value.startsWith(LegacyBdio1xEmitter.VOCAB)) {
                return value.substring(LegacyBdio1xEmitter.VOCAB.length());
            }
            for (Map.Entry prefix : PREFIXES.entrySet()) {
                if (!value.startsWith((String)prefix.getValue())) continue;
                return (String)prefix.getKey() + value.substring(((String)prefix.getValue()).length());
            }
            return value;
        }
    }

    private static class Bdio1JsonFactory
    extends JsonFactory {
        private static final long serialVersionUID = 1L;

        private Bdio1JsonFactory() {
        }

        protected JsonParser _createParser(InputStream in, IOContext ctxt) throws IOException {
            return new Bdio1JsonParser(super._createParser(in, ctxt));
        }
    }

    private static class Archive {
        private final Archive container;
        private final String fileName;
        private final String nestedPath;

        private Archive(Archive container, String fileName) {
            while (container != null && !fileName.startsWith(container.fileName)) {
                container = container.container;
            }
            this.container = container;
            this.fileName = fileName;
            this.nestedPath = LegacyUtilities.guessScheme(fileName) + ':' + UrlEscapers.urlPathSegmentEscaper().escape(Archive.computePath(container, fileName)) + '#';
        }

        public static String computePath(Archive container, String fileName) {
            if (container != null) {
                int endIndex = fileName.endsWith("/") ? fileName.length() - 1 : fileName.length();
                String path = fileName.substring(container.fileName.length(), endIndex);
                return container.nestedPath + UrlEscapers.urlFragmentEscaper().escape(path);
            }
            Preconditions.checkArgument((boolean)fileName.startsWith("./"), (String)"invalid BDIO 1.x fileName (must start with './'): %s", (Object)fileName);
            return "file:///" + Joiner.on((char)'/').join(Iterables.transform((Iterable)Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)fileName.substring(2)), (Function)UrlEscapers.urlPathSegmentEscaper().asFunction()));
        }
    }

    private static class NodeComputer {
        private static final int DEPENDENCY_BATCH_SIZE = 100;
        private final AtomicBoolean finished = new AtomicBoolean();
        private final AtomicBoolean hasFile = new AtomicBoolean();
        private final AtomicReference<Supplier<BdioObject>> rootObjectRef = new AtomicReference();
        private final AtomicReference<Supplier<File>> baseFileRef = new AtomicReference();
        private final Multimap<String, Dependency> dependencyBuffer = LinkedHashMultimap.create();
        private final Deque<Map<String, Object>> convertedBuffer = new ArrayDeque<Map<String, Object>>();

        private NodeComputer() {
        }

        public void setRootProjectId(String id) {
            this.rootObjectRef.compareAndSet(null, () -> new Project(id));
        }

        public void setRootFileCollectionId(String id) {
            this.rootObjectRef.compareAndSet(null, () -> new FileCollection(id));
        }

        public void addFile(String id, @Nullable String fileName) {
            this.hasFile.set(true);
            if (Objects.equals(fileName, "./")) {
                this.baseFileRef.set(() -> new File(id));
            }
        }

        public void addRootDependency(Dependency dependency) {
            LegacyUtilities.mergeDependency(this.dependencyBuffer, dependency);
            if (this.dependencyBuffer.size() > 100) {
                this.drainDependencies();
            }
        }

        public void addFirst(Map<String, Object> node) {
            this.convertedBuffer.addFirst(node);
        }

        public Map<String, Object> pollFirst() {
            return this.convertedBuffer.pollFirst();
        }

        public boolean finish() {
            if (this.finished.compareAndSet(false, true)) {
                this.drainBaseFile();
                this.drainDependencies();
                return true;
            }
            return false;
        }

        private void drainBaseFile() {
            Supplier<BdioObject> rootObjectSupplier = this.rootObjectRef.get();
            Supplier<File> baseFileSupplier = this.baseFileRef.get();
            if (rootObjectSupplier != null && (baseFileSupplier != null || this.hasFile.get())) {
                File baseFile = baseFileSupplier != null ? baseFileSupplier.get() : new File("file:///").path("file:///");
                BdioObject rootObject = rootObjectSupplier.get();
                if (rootObject instanceof Project) {
                    ((Project)rootObject).base(baseFile);
                } else if (rootObject instanceof FileCollection) {
                    ((FileCollection)rootObject).base(baseFile);
                }
                this.addFirst(rootObject);
                if (baseFileSupplier == null) {
                    this.addFirst(baseFile);
                }
            }
        }

        private void drainDependencies() {
            Supplier<BdioObject> rootObjectSupplier = this.rootObjectRef.get();
            if (rootObjectSupplier != null && !this.dependencyBuffer.isEmpty()) {
                BdioObject rootObject = rootObjectSupplier.get();
                for (Dependency dependency : this.dependencyBuffer.values()) {
                    if (rootObject instanceof Project) {
                        ((Project)rootObject).dependency(dependency);
                        continue;
                    }
                    if (!(rootObject instanceof FileCollection)) continue;
                    ((FileCollection)rootObject).dependency(dependency);
                }
                this.dependencyBuffer.clear();
                this.addFirst(rootObject);
            }
        }
    }
}

