/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.Bdio;
import com.blackducksoftware.bdio2.BdioMetadata;
import com.blackducksoftware.bdio2.EntrySizeViolationException;
import com.blackducksoftware.common.io.ExtraIO;
import com.github.jsonldjava.utils.JsonUtils;
import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BdioWriter
implements Closeable {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean needsFooter = new AtomicBoolean();
    private final AtomicInteger remaining = new AtomicInteger();
    private final BdioMetadata metadata;
    private final StreamSupplier entryStreams;
    private final byte[] header;
    private final byte[] delimiter;
    private final byte[] footer;
    private OutputStream out;

    public BdioWriter(BdioMetadata metadata, StreamSupplier entryStreams) {
        this.metadata = Objects.requireNonNull(metadata);
        this.entryStreams = Objects.requireNonNull(entryStreams);
        this.header = ("{\n  " + '\"' + "@id" + '\"' + " : " + '\"' + metadata.id() + '\"' + ",\n  " + '\"' + "@type" + '\"' + " : " + '\"' + metadata.scanType() + '\"' + ",\n  " + '\"' + "@graph" + '\"' + " : [ ").getBytes(StandardCharsets.UTF_8);
        this.delimiter = ", ".getBytes(StandardCharsets.UTF_8);
        this.footer = " ]\n}\n".getBytes(StandardCharsets.UTF_8);
    }

    public void start() throws IOException {
        Preconditions.checkState((boolean)this.started.compareAndSet(false, true), (Object)"already started");
        this.out = this.entryStreams.newStream();
        OutputStreamWriter writer = new OutputStreamWriter(this.out, StandardCharsets.UTF_8);
        JsonUtils.writePrettyPrint((Writer)writer, this.metadata.asNamedGraph());
        ((Writer)writer).flush();
    }

    public void next(Map<String, Object> node) throws IOException {
        Preconditions.checkState((boolean)this.started.get(), (Object)"not started");
        byte[] serializedNode = JsonUtils.toPrettyString(node).replace("\n", "\n  ").getBytes(StandardCharsets.UTF_8);
        if ((long)this.remaining.addAndGet((this.delimiter.length + serializedNode.length) * -1) > 0L) {
            this.out.write(this.delimiter);
            this.out.write(serializedNode);
        } else {
            this.nextEntry();
            if ((long)this.remaining.addAndGet(serializedNode.length * -1) > 0L) {
                this.out.write(serializedNode);
            } else {
                throw new EntrySizeViolationException(null, Math.abs(this.remaining.get()) + 0x1000000);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.closeStream();
            }
            finally {
                this.entryStreams.close();
            }
        }
    }

    public void closeEntry() {
        this.remaining.set(0);
    }

    private void nextEntry() throws IOException {
        this.closeStream();
        this.out = this.entryStreams.newStream();
        this.out.write(this.header);
        this.needsFooter.set(true);
        this.remaining.set(0x1000000 - this.header.length - this.footer.length);
    }

    private void closeStream() throws IOException {
        if (this.out != null) {
            if (this.needsFooter.get()) {
                this.out.write(this.footer);
            }
            this.out.close();
        }
    }

    public static class BdioFile
    implements StreamSupplier {
        private final ZipOutputStream out;
        private final OutputStream bufferedOut;
        private final AtomicInteger entryCount = new AtomicInteger(-1);

        public BdioFile(OutputStream outputStream) {
            this.out = new ZipOutputStream(ExtraIO.buffer((OutputStream)outputStream));
            this.bufferedOut = new BufferedOutputStream(this.out){

                @Override
                public void close() throws IOException {
                    super.flush();
                }
            };
        }

        @Override
        public OutputStream newStream() throws IOException {
            this.out.putNextEntry(new ZipEntry(Bdio.dataEntryName(this.entryCount.getAndIncrement())));
            return this.bufferedOut;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    @FunctionalInterface
    public static interface StreamSupplier
    extends Closeable {
        public OutputStream newStream() throws IOException;

        @Override
        default public void close() throws IOException {
        }
    }
}

