/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.Bdio;
import com.blackducksoftware.bdio2.BdioContext;
import com.blackducksoftware.bdio2.BdioReader;
import com.blackducksoftware.bdio2.Emitter;
import com.blackducksoftware.common.value.ProductList;
import com.google.common.collect.MoreCollectors;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class BdioEmitter
implements Emitter {
    private String scanType;
    private final BdioReader reader;
    private final BdioContext context;

    public BdioEmitter(InputStream in) {
        this.reader = new BdioReader(in);
        this.context = BdioContext.getDefault();
    }

    @Override
    public void emit(Consumer<Object> onNext, Consumer<Throwable> onError, Runnable onComplete) {
        Objects.requireNonNull(onNext);
        Objects.requireNonNull(onError);
        Objects.requireNonNull(onComplete);
        try {
            Object next = this.reader.nextEntry();
            if (next != null) {
                this.checkAndAddScanType(next);
                onNext.accept(next);
            } else {
                onComplete.run();
            }
        }
        catch (IOException e) {
            onError.accept(e);
        }
    }

    @Override
    public void dispose() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void checkAndAddScanType(Object object) {
        if (object instanceof Map && this.context.getFieldValue("@type", (Map)object).filter(Objects::nonNull).allMatch(o -> o.equals("null"))) {
            if (this.scanType == null) {
                ProductList productList = ((Optional)this.context.getFieldValue((Object)Bdio.DataProperty.publisher, (Map)object).filter(Objects::nonNull).collect(MoreCollectors.toOptional())).orElse(null);
                if (productList != null) {
                    if (productList.primary().name().equalsIgnoreCase("ScanClient")) {
                        this.scanType = Bdio.ScanType.SIGNATURE.name();
                    } else if (productList.primary().name().equalsIgnoreCase("Protecode-SC")) {
                        this.scanType = Bdio.ScanType.BINARY.name();
                    }
                }
                if (this.scanType == null) {
                    this.scanType = Bdio.ScanType.PACKAGE_MANAGER.name();
                }
            }
            this.context.putFieldValue((Map)object, "@type", this.scanType);
        }
    }
}

