/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.bdio2.Bdio;
import com.blackducksoftware.bdio2.BdioValueMapper;
import com.blackducksoftware.bdio2.StandardJavaValueMapper;
import com.blackducksoftware.common.base.ExtraThrowables;
import com.github.jsonldjava.core.Context;
import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.RemoteDocument;
import com.github.jsonldjava.utils.JsonUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class BdioContext {
    private final BdioValueMapper valueMapper;
    private final DocumentLoader documentLoader;
    private final ImmutableSet<String> embeddedTypes;
    @Nullable
    private final String base;
    @Nullable
    private final Object expandContext;
    private final Context context;

    public static BdioContext getDefault() {
        return ContextHolder.DEFAULT_CONTEXT;
    }

    private BdioContext(Builder builder) {
        this.valueMapper = Objects.requireNonNull(builder.valueMapper);
        this.documentLoader = Objects.requireNonNull(builder.documentLoader);
        this.embeddedTypes = ImmutableSet.copyOf((Collection)builder.embeddedTypes);
        this.base = builder.base;
        this.expandContext = builder.expandContext;
        this.context = new Context(this.jsonLdOptions()).parse(this.expandContext);
    }

    Map<String, Object> serialize() {
        return this.context.serialize();
    }

    String getTypeMapping(String property) {
        return this.context.getTypeMapping(property);
    }

    Map<String, String> getPrefixes(boolean onlyCommonPrefixes) {
        return this.context.getPrefixes(onlyCommonPrefixes);
    }

    public JsonLdOptions jsonLdOptions() {
        JsonLdOptions options = new JsonLdOptions();
        options.setDocumentLoader(this.documentLoader);
        options.setBase(this.base);
        options.setExpandContext(this.expandContext);
        options.setOmitDefault(Boolean.TRUE);
        return options;
    }

    public Object fromFieldValue(String term, @Nullable Object input) {
        return this._fromFieldValue(term, input).collect(this.valueMapper.getCollector(this.context.getContainer(term)));
    }

    private Stream<Object> _fromFieldValue(String term, @Nullable Object input) {
        if (input instanceof List) {
            return ((List)input).stream().flatMap(e -> this._fromFieldValue(term, e));
        }
        if (input instanceof Map) {
            return Stream.of(this.valueMapper.fromFieldValue((Map)input));
        }
        String type = this.context.getTypeMapping(term);
        if (type != null && input != null) {
            return this._fromFieldValue(term, ImmutableMap.of((Object)"@type", (Object)type, (Object)"@value", (Object)input));
        }
        return Stream.of(input);
    }

    public Object toFieldValue(String term, @Nullable Object input) {
        return this.valueMapper.split(input).map(e -> this._toFieldValue(term, e)).collect(BdioContext.jsonLdCollector(this.context.getContainer(term)));
    }

    private Object _toFieldValue(String term, @Nullable Object input) {
        String type = this.context.getTypeMapping(term);
        if (input instanceof String && Objects.equals(type, "@id")) {
            input = ImmutableMap.of((Object)type, (Object)input);
        }
        if (input != null) {
            return this.valueMapper.toFieldValue(type, input, this::isEmbedded);
        }
        return input;
    }

    public boolean isEmbedded(@Nullable Object type) {
        if (type instanceof List) {
            return ((List)type).stream().anyMatch(this::isEmbedded);
        }
        if (this.embeddedTypes.contains(type)) {
            return true;
        }
        String fullyQualified = (String)this.context.getPrefixes(false).get(type);
        if (fullyQualified != null) {
            return this.isEmbedded(fullyQualified);
        }
        return false;
    }

    public Optional<String> lookupTerm(String iri) {
        if (BdioContext.isKeyword(iri)) {
            return Optional.of(iri);
        }
        Object definition = this.context.getInverse().get(iri);
        if (definition instanceof Map && (definition = ((Map)definition).values().iterator().next()) instanceof Map && (definition = ((Map)definition).get("@type")) instanceof Map) {
            return Optional.of(((Map)definition).values().iterator().next().toString());
        }
        return Optional.empty();
    }

    public Stream<?> getFieldValue(Object field, Map<?, ?> values) {
        String key = field.toString();
        return this.valueMapper.split(this.fromFieldValue(this.term(key), values.get(key)));
    }

    public Object putFieldValue(Map<String, Object> map, Object field, @Nullable Object value) {
        String key = field.toString();
        if (value == null) {
            return map.computeIfPresent(key, this::computeFieldValueIfPresent);
        }
        if (map.containsKey(key)) {
            return map.merge(key, value, this.mergeFieldValue(key));
        }
        return map.put(key, this.toFieldValue(this.term(key), value));
    }

    private BinaryOperator<Object> mergeFieldValue(String key) {
        return (oldValue, input) -> {
            Objects.requireNonNull(input);
            String term = this.term(key);
            String container = this.context.getContainer(term);
            if (container == null && Objects.equals(this.context.getTypeMapping(term), "@id")) {
                container = "@list";
            }
            if (oldValue == null || container == null || container.isEmpty() || container.equals("@none")) {
                return this.toFieldValue(term, input);
            }
            Object newValue = this.toFieldValue(term, input);
            Stream<Object> newValues = newValue instanceof List ? ((List)newValue).stream() : Stream.of(newValue);
            Stream<Object> oldValues = oldValue instanceof List ? ((List)oldValue).stream() : Stream.of(oldValue);
            return Streams.concat((Stream[])new Stream[]{newValues, oldValues}).collect(BdioContext.jsonLdCollector(container));
        };
    }

    private Object computeFieldValueIfPresent(String key, Object oldValue) {
        String term = this.term(key);
        String container = this.context.getContainer(term);
        if (container == null || container.isEmpty() || container.equals("@none")) {
            return null;
        }
        return oldValue;
    }

    boolean isLegacyBdio() {
        return Objects.equals(this.expandContext, Bdio.Context.VERSION_1_0.toString()) || Objects.equals(this.expandContext, Bdio.Context.VERSION_1_1.toString()) || Objects.equals(this.expandContext, Bdio.Context.VERSION_1_1_1.toString());
    }

    private String term(String iri) {
        return this.lookupTerm(iri).orElseThrow(ExtraThrowables.illegalState((String)"the current context does not support: %s", (Object[])new Object[]{iri}));
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        builder.valueMapper = this.valueMapper;
        builder.documentLoader = this.documentLoader;
        builder.embeddedTypes.addAll(this.embeddedTypes);
        builder.base = this.base;
        builder.expandContext = this.expandContext;
        return builder;
    }

    private static Collector<? super Object, ?, ?> jsonLdCollector(String container) {
        if (container == null || container.isEmpty() || container.equals("@none") || container.equals("@id")) {
            return Collectors.reducing(null, (a, b) -> a != null ? a : b);
        }
        return Collectors.collectingAndThen(Collectors.toList(), l -> {
            l.removeIf(Objects::isNull);
            return l;
        });
    }

    private static boolean isKeyword(Object obj) {
        return obj instanceof String && ((String)obj).startsWith("@");
    }

    public static final class Builder {
        private static ImmutableMap<String, String> STANDARD_DOCUMENTS;
        private BdioValueMapper valueMapper;
        private DocumentLoader documentLoader;
        private final Set<String> embeddedTypes = new LinkedHashSet<String>();
        @Nullable
        private String base;
        @Nullable
        private Object expandContext;

        public Builder() {
            this.valueMapper = StandardJavaValueMapper.getInstance();
            this.documentLoader = new DocumentLoader();
            STANDARD_DOCUMENTS.forEach((arg_0, arg_1) -> ((DocumentLoader)this.documentLoader).addInjectedDoc(arg_0, arg_1));
            for (Bdio.Class bdioClass : Bdio.Class.values()) {
                if (!bdioClass.embedded()) continue;
                this.embeddedTypes.add(bdioClass.toString());
            }
        }

        public Builder valueMapper(BdioValueMapper valueMapper) {
            this.valueMapper = Objects.requireNonNull(valueMapper);
            return this;
        }

        public Builder injectDocument(String url, CharSequence content) {
            this.documentLoader.addInjectedDoc(url, content.toString());
            return this;
        }

        public Builder injectDocument(RemoteDocument document) {
            String url = document.getDocumentUrl();
            if (document.getDocument() instanceof CharSequence) {
                return this.injectDocument(url, (CharSequence)document.getDocument());
            }
            try {
                this.documentLoader.addInjectedDoc(url, JsonUtils.toString((Object)document.getDocument()));
                return this;
            }
            catch (IOException e) {
                throw new JsonLdError(JsonLdError.Error.LOADING_INJECTED_CONTEXT_FAILED, (Object)url, (Throwable)e);
            }
        }

        public Builder embeddedTypes(Collection<String> embeddedTypes) {
            this.embeddedTypes.addAll(embeddedTypes);
            return this;
        }

        public Builder base(@Nullable String base) {
            if (base != null && !base.isEmpty()) {
                URI baseUri = URI.create(base);
                Preconditions.checkArgument((baseUri.isAbsolute() && !baseUri.isOpaque() ? 1 : 0) != 0, (String)"base must be an absolute hierarchical URI: %s", (Object)base);
            }
            this.base = base;
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Builder expandContext(@Nullable Object expandContext) {
            if (expandContext == null || expandContext instanceof String || expandContext instanceof Map || expandContext instanceof List) {
                this.expandContext = expandContext;
                return this;
            } else if (expandContext instanceof Bdio.Context) {
                this.expandContext = expandContext.toString();
                return this;
            } else {
                if (!(expandContext instanceof Bdio.ContentType)) throw new IllegalArgumentException("expandContext must be a Bdio.ContentType, Bdio.Context, String, Map<String, Object> or a List<Object>");
                Preconditions.checkArgument((expandContext != Bdio.ContentType.JSON ? 1 : 0) != 0, (Object)"the JSON content type leaves the expansion context undefined");
                if (expandContext == Bdio.ContentType.JSONLD || expandContext == Bdio.ContentType.BDIO_ZIP) {
                    this.expandContext = null;
                    return this;
                } else {
                    if (expandContext != Bdio.ContentType.BDIO_JSON) throw new IllegalArgumentException("unknown content type: " + expandContext);
                    this.expandContext = Bdio.Context.DEFAULT.toString();
                }
            }
            return this;
        }

        public BdioContext build() {
            return new BdioContext(this);
        }

        static {
            ImmutableMap.Builder standardDocuments = ImmutableMap.builder();
            for (Bdio.Context context : Bdio.Context.values()) {
                try {
                    standardDocuments.put((Object)context.toString(), (Object)Resources.toString((URL)context.resourceUrl(), (Charset)StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to inject standard context", e);
                }
            }
            STANDARD_DOCUMENTS = standardDocuments.build();
        }
    }

    private static final class ContextHolder {
        private static final BdioContext DEFAULT_CONTEXT = new Builder().expandContext((Object)Bdio.Context.DEFAULT).build();

        private ContextHolder() {
        }
    }
}

