/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.bdio2;

import com.blackducksoftware.common.base.ExtraStrings;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import com.google.common.net.MediaType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public class Bdio {
    public static final int MAX_ENTRY_WRITE_SIZE = 0x1000000;
    public static final int MAX_ENTRY_READ_SIZE = 0x5A00000;

    public static String dataEntryName(int entryNumber) {
        if (entryNumber < -1) {
            throw new IllegalArgumentException("entryNumber must greater then or equal to -1: " + entryNumber);
        }
        if (entryNumber < 0) {
            return "bdio-header.jsonld";
        }
        return String.format("bdio-entry-%02d.jsonld", entryNumber);
    }

    public static boolean isDataEntryName(String name) {
        return name.endsWith(".jsonld");
    }

    private Bdio() {
        assert (false);
    }

    public static enum ScanType {
        PACKAGE_MANAGER("PACKAGE_MANAGER"),
        SIGNATURE("SIGNATURE"),
        BINARY("BINARY"),
        INFRASTRUCTURE_AS_CODE("INFRASTRUCTURE_AS_CODE");

        private final String value;

        private ScanType(String value) {
            this.value = Objects.requireNonNull(value);
        }

        public static ScanType from(@Nullable Object obj) {
            if (obj instanceof ScanType) {
                return (ScanType)((Object)obj);
            }
            for (ScanType scanType : ScanType.values()) {
                if (!scanType.value.equals(obj)) continue;
                return scanType;
            }
            throw new IllegalArgumentException("unsupported scanType: " + obj);
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Context {
        VERSION_2_1("https://blackducksoftware.github.io/bdio/2.1.0", "bdio-context-2.1.jsonld"),
        VERSION_2_0("https://blackducksoftware.github.io/bdio/2.0.0", "bdio-context-2.0.jsonld"),
        VERSION_1_1_1("http://blackducksoftware.com/rdf/terms/1.1.1", "bdio-context-1.1.1.jsonld"),
        VERSION_1_1("http://blackducksoftware.com/rdf/terms/1.1.0", "bdio-context-1.1.jsonld"),
        VERSION_1_0("http://blackducksoftware.com/rdf/terms/1.0.0", "bdio-context-1.0.jsonld"),
        DEFAULT("https://blackducksoftware.github.io/bdio", Context.VERSION_2_1.resourceName);

        private final String iri;
        private final String resourceName;

        private Context(String iri, String resourceName) {
            this.iri = Objects.requireNonNull(iri);
            this.resourceName = Objects.requireNonNull(resourceName);
        }

        public String toString() {
            return this.iri;
        }

        URL resourceUrl() {
            return Resources.getResource(Bdio.class, (String)this.resourceName);
        }

        public static Context forSpecVersion(String specVersion) {
            switch (specVersion) {
                case "": 
                case "1.0.0": {
                    return VERSION_1_0;
                }
                case "1.1.0": {
                    return VERSION_1_1;
                }
                case "1.1.1": {
                    return VERSION_1_1_1;
                }
                case "2.0.0": {
                    return VERSION_2_0;
                }
                case "2.1.0": {
                    return VERSION_2_1;
                }
            }
            throw new IllegalArgumentException("unknown BDIO specification version: " + specVersion);
        }
    }

    public static enum ContentType {
        JSONLD("application/ld+json", "jsonld"),
        JSON("application/json", "json"),
        BDIO_JSON("application/vnd.blackducksoftware.bdio+json", "json"),
        BDIO_ZIP("application/vnd.blackducksoftware.bdio+zip", "bdio");

        private final String mediaType;
        private final String extension;

        private ContentType(String mediaType, String extension) {
            this.mediaType = Objects.requireNonNull(mediaType);
            this.extension = Objects.requireNonNull(extension);
        }

        public String toString() {
            return this.mediaType;
        }

        public String extension() {
            return this.extension;
        }

        public <R> R as(Function<String, R> f) {
            return f.apply(this.mediaType);
        }

        public static ContentType forMediaType(String input) {
            MediaType mediaType = MediaType.parse((String)input);
            for (ContentType contentType : ContentType.values()) {
                if (!mediaType.is(contentType.as(MediaType::parse))) continue;
                if (contentType == JSONLD || contentType == JSON) {
                    Preconditions.checkArgument((boolean)((Charset)mediaType.charset().or((Object)StandardCharsets.UTF_8)).equals(StandardCharsets.UTF_8), (Object)("unsupported charset: " + input));
                }
                return contentType;
            }
            throw new IllegalArgumentException("unsupported media type: " + input);
        }

        public static ContentType forFileName(String input) {
            for (ContentType contentType : ContentType.values()) {
                if (!input.endsWith("." + contentType.extension)) continue;
                return contentType;
            }
            throw new IllegalArgumentException("unsupported file extension: " + ExtraStrings.afterLast((CharSequence)input, (char)'/'));
        }
    }

    public static enum FileSystemType {
        REGULAR("regular"),
        REGULAR_BINARY("regular/binary"),
        REGULAR_TEXT("regular/text"),
        DIRECTORY("directory"),
        DIRECTORY_ARCHIVE("directory/archive"),
        SYMLINK("symlink"),
        OTHER_DEVICE_BLOCK("other/device/block"),
        OTHER_DEVICE_CHARACTER("other/device/character"),
        OTHER_DOOR("other/door"),
        OTHER_PIPE("other/pipe"),
        OTHER_SOCKET("other/socket"),
        OTHER_WHITEOUT("other/whiteout");

        private final String value;
        private final boolean regularFile;
        private final boolean directory;
        private final boolean symbolicLink;
        private final boolean other;

        private FileSystemType(String value) {
            this.value = Objects.requireNonNull(value);
            String type = ExtraStrings.beforeFirst((CharSequence)value, (char)'/');
            this.regularFile = type.equals("regular");
            this.directory = type.equals("directory");
            this.symbolicLink = type.equals("symlink");
            this.other = type.equals("other");
        }

        public boolean isRegularFile() {
            return this.regularFile;
        }

        public boolean isDirectory() {
            return this.directory;
        }

        public boolean isSymbolicLink() {
            return this.symbolicLink;
        }

        public boolean isOther() {
            return this.other;
        }

        public static FileSystemType from(@Nullable Object obj) {
            if (obj instanceof FileSystemType) {
                return (FileSystemType)((Object)obj);
            }
            for (FileSystemType fileSystemType : FileSystemType.values()) {
                if (!fileSystemType.value.equals(obj)) continue;
                return fileSystemType;
            }
            throw new IllegalArgumentException("unknown file system type: " + obj);
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Container {
        single,
        ordered,
        unordered;

    }

    public static enum Datatype {
        ContentRange("https://blackducksoftware.github.io/bdio#ContentRange"),
        ContentType("https://blackducksoftware.github.io/bdio#ContentType"),
        DateTime("http://www.w3.org/2001/XMLSchema#dateTime"),
        Default(""),
        Digest("https://blackducksoftware.github.io/bdio#Digest"),
        Long("http://www.w3.org/2001/XMLSchema#long"),
        Products("https://blackducksoftware.github.io/bdio#Products");

        private final String iri;

        private Datatype(String iri) {
            this.iri = Objects.requireNonNull(iri);
        }

        public String toString() {
            return this.iri;
        }
    }

    public static enum DataProperty {
        archiveContext("https://blackducksoftware.github.io/bdio#hasArchiveContext", Container.single),
        buildDetails("https://blackducksoftware.github.io/bdio#hasBuildDetails", Container.single),
        buildNumber("https://blackducksoftware.github.io/bdio#hasBuildNumber", Container.single),
        buildOptions("https://blackducksoftware.github.io/bdio#hasBuildOptions", Container.ordered),
        byteCount("https://blackducksoftware.github.io/bdio#hasByteCount", Container.single),
        captureInterval("https://blackducksoftware.github.io/bdio#hasCaptureInterval", Container.single),
        captureOptions("https://blackducksoftware.github.io/bdio#hasCaptureOptions", Container.ordered),
        comment("https://blackducksoftware.github.io/bdio#hasComment", Container.single),
        contentType("https://blackducksoftware.github.io/bdio#hasContentType", Container.single),
        context("https://blackducksoftware.github.io/bdio#hasContext", Container.single),
        correlationId("https://blackducksoftware.github.io/bdio#hasCorrelationId", Container.single),
        creationDateTime("https://blackducksoftware.github.io/bdio#hasCreationDateTime", Container.single),
        creator("https://blackducksoftware.github.io/bdio#hasCreator", Container.single),
        deepDirectoryCount("https://blackducksoftware.github.io/bdio#hasDeepDirectoryCount", Container.single),
        deepFileCount("https://blackducksoftware.github.io/bdio#hasDeepFileCount", Container.single),
        dependencyType("https://blackducksoftware.github.io/bdio#hasDependencyType", Container.single),
        distanceFromInnerRoot("https://blackducksoftware.github.io/bdio#hasDistanceFromInnerRoot", Container.single),
        distanceFromRoot("https://blackducksoftware.github.io/bdio#hasDistanceFromRoot", Container.single),
        encoding("https://blackducksoftware.github.io/bdio#hasEncoding", Container.single),
        fileSystemType("https://blackducksoftware.github.io/bdio#hasFileSystemType", Container.single),
        fingerprint("https://blackducksoftware.github.io/bdio#hasFingerprint", Container.unordered),
        homepage("https://blackducksoftware.github.io/bdio#hasHomepage", Container.unordered),
        identifier("https://blackducksoftware.github.io/bdio#hasIdentifier", Container.single),
        lastModifiedDateTime("https://blackducksoftware.github.io/bdio#hasLastModifiedDateTime", Container.single),
        linkPath("https://blackducksoftware.github.io/bdio#hasLinkPath", Container.single),
        matchConfidenceThreshold("https://blackducksoftware.github.io/bdio#hasMatchConfidenceThreshold", Container.single),
        name("https://blackducksoftware.github.io/bdio#hasName", Container.single),
        namespace("https://blackducksoftware.github.io/bdio#hasNamespace", Container.single),
        nodeName("https://blackducksoftware.github.io/bdio#hasNodeName", Container.single),
        parentId("https://blackducksoftware.github.io/bdio#hasParentId", Container.single),
        path("https://blackducksoftware.github.io/bdio#hasPath", Container.single),
        platform("https://blackducksoftware.github.io/bdio#hasPlatform", Container.single),
        project("https://blackducksoftware.github.io/bdio#hasProject", Container.single),
        projectGroup("https://blackducksoftware.github.io/bdio#hasProjectGroup", Container.single),
        projectVersion("https://blackducksoftware.github.io/bdio#hasProjectVersion", Container.single),
        publisher("https://blackducksoftware.github.io/bdio#hasPublisher", Container.single),
        range("https://blackducksoftware.github.io/bdio#hasRange", Container.unordered),
        requestedVersion("https://blackducksoftware.github.io/bdio#hasRequestedVersion", Container.single),
        resolver("https://blackducksoftware.github.io/bdio#hasResolver", Container.single),
        rights("https://blackducksoftware.github.io/bdio#hasRights", Container.single),
        scope("https://blackducksoftware.github.io/bdio#hasScope", Container.single),
        shallowDirectoryCount("https://blackducksoftware.github.io/bdio#hasShallowDirectoryCount", Container.single),
        sourceBranch("https://blackducksoftware.github.io/bdio#hasSourceBranch", Container.single),
        sourceRepository("https://blackducksoftware.github.io/bdio#hasSourceRepository", Container.single),
        sourceRevision("https://blackducksoftware.github.io/bdio#hasSourceRevision", Container.single),
        sourceTag("https://blackducksoftware.github.io/bdio#hasSourceTag", Container.single),
        uri("https://blackducksoftware.github.io/bdio#hasUri", Container.single),
        vendor("https://blackducksoftware.github.io/bdio#hasVendor", Container.single),
        version("https://blackducksoftware.github.io/bdio#hasVersion", Container.single);

        private final String iri;
        private final Container container;

        private DataProperty(String iri, Container container) {
            this.iri = Objects.requireNonNull(iri);
            this.container = Objects.requireNonNull(container);
        }

        public String toString() {
            return this.iri;
        }

        public Container container() {
            return this.container;
        }
    }

    public static enum ObjectProperty {
        affected("https://blackducksoftware.github.io/bdio#hasAffected", Container.unordered),
        base("https://blackducksoftware.github.io/bdio#hasBase", Container.unordered),
        canonical("https://blackducksoftware.github.io/bdio#hasCanonical", Container.single),
        declaredBy("https://blackducksoftware.github.io/bdio#declaredBy", Container.unordered),
        dependency("https://blackducksoftware.github.io/bdio#hasDependency", Container.unordered),
        dependsOn("https://blackducksoftware.github.io/bdio#dependsOn", Container.unordered),
        description("https://blackducksoftware.github.io/bdio#hasDescription", Container.unordered),
        evidence("https://blackducksoftware.github.io/bdio#hasEvidence", Container.unordered),
        license("https://blackducksoftware.github.io/bdio#hasLicense", Container.single),
        licenseConjunctive("https://blackducksoftware.github.io/bdio#haslicenseConjunctive", Container.ordered),
        licenseDisjunctive("https://blackducksoftware.github.io/bdio#hasLicenseDisjunctive", Container.ordered),
        licenseException("https://blackducksoftware.github.io/bdio#hasLicenseException", Container.single),
        licenseOrLater("https://blackducksoftware.github.io/bdio#hasLicenseOrLater", Container.single),
        note("https://blackducksoftware.github.io/bdio#hasNote", Container.ordered),
        parent("https://blackducksoftware.github.io/bdio#hasParent", Container.single),
        previousVersion("https://blackducksoftware.github.io/bdio#hasPreviousVersion", Container.single),
        subproject("https://blackducksoftware.github.io/bdio#hasSubproject", Container.unordered);

        private final String iri;
        private final Container container;

        private ObjectProperty(String iri, Container container) {
            this.iri = Objects.requireNonNull(iri);
            this.container = Objects.requireNonNull(container);
        }

        public String toString() {
            return this.iri;
        }

        public Container container() {
            return this.container;
        }
    }

    public static enum Class {
        Annotation("https://blackducksoftware.github.io/bdio#Annotation"),
        Component("https://blackducksoftware.github.io/bdio#Component"),
        Container("https://blackducksoftware.github.io/bdio#Container"),
        Dependency("https://blackducksoftware.github.io/bdio#Dependency"),
        File("https://blackducksoftware.github.io/bdio#File"),
        FileCollection("https://blackducksoftware.github.io/bdio#FileCollection"),
        License("https://blackducksoftware.github.io/bdio#License"),
        LicenseGroup("https://blackducksoftware.github.io/bdio#LicenseGroup"),
        Note("https://blackducksoftware.github.io/bdio#Note"),
        Project("https://blackducksoftware.github.io/bdio#Project"),
        Repository("https://blackducksoftware.github.io/bdio#Repository"),
        Vulnerability("https://blackducksoftware.github.io/bdio#Vulnerability");

        private final String iri;

        private Class(String iri) {
            this.iri = Objects.requireNonNull(iri);
        }

        public boolean root() {
            return this == Project || this == Container || this == Repository || this == FileCollection;
        }

        public boolean embedded() {
            return this == Annotation || this == Dependency || this == LicenseGroup || this == Note;
        }

        public String toString() {
            return this.iri;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface DataPropertyRange {
        public Datatype value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ObjectPropertyRange {
        public Class[] value() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Domain {
        public boolean metadata() default false;

        public Class[] value() default {};
    }
}

