/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.stepworkflow.jenkins;

import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.jenkins.extensions.JenkinsIntLogger;
import com.blackduck.integration.jenkins.wrapper.JenkinsVersionHelper;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.log.SilentIntLogger;
import com.blackduck.integration.phonehome.PhoneHomeClient;
import com.blackduck.integration.phonehome.PhoneHomeResponse;
import com.blackduck.integration.phonehome.PhoneHomeService;
import com.blackduck.integration.phonehome.request.PhoneHomeRequestBody;
import com.blackduck.integration.phonehome.request.PhoneHomeRequestBodyBuilder;
import com.blackduck.integration.rest.HttpMethod;
import com.blackduck.integration.rest.client.IntHttpClient;
import com.blackduck.integration.rest.proxy.ProxyInfo;
import com.blackduck.integration.rest.response.Response;
import com.blackduck.integration.stepworkflow.StepWorkflow;
import com.blackduck.integration.stepworkflow.StepWorkflowResponse;
import com.blackduck.integration.stepworkflow.jenkins.PhoneHomeCredentials;
import com.blackduck.integration.util.ResourceUtil;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import hudson.AbortException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class JenkinsStepWorkflow<T> {
    protected final JenkinsIntLogger logger;
    protected final JenkinsVersionHelper jenkinsVersionHelper;
    private static final int TIMEOUT_IN_SECONDS = 20;
    private final Gson gson;
    private final IntHttpClient intHttpClient;
    private static final String CREDENTIALS_PATH = "https://static-content.app.blackduck.com/detect/analytics/creds.json";
    private static final String TEST_CREDENTIALS_PATH = "https://static-content.saas-staging.blackduck.com/detect/analytics/creds.json";

    public JenkinsStepWorkflow(JenkinsIntLogger logger, JenkinsVersionHelper jenkinsVersionHelper) {
        this.logger = logger;
        this.jenkinsVersionHelper = jenkinsVersionHelper;
        this.gson = new Gson();
        this.intHttpClient = new IntHttpClient((IntLogger)new SilentIntLogger(), this.gson, 20, true, ProxyInfo.NO_PROXY_INFO);
    }

    protected abstract PhoneHomeRequestBodyBuilder createPhoneHomeBuilder();

    protected abstract StepWorkflow<T> buildWorkflow() throws AbortException;

    public abstract Object perform() throws Exception;

    protected StepWorkflowResponse<T> runWorkflow() throws AbortException {
        Optional<PhoneHomeResponse> phoneHomeResponse = this.beginPhoneHome();
        try {
            StepWorkflowResponse<T> stepWorkflowResponse = this.buildWorkflow().run();
            return stepWorkflowResponse;
        }
        finally {
            phoneHomeResponse.ifPresent(PhoneHomeResponse::getImmediateResult);
        }
    }

    protected Optional<PhoneHomeResponse> beginPhoneHome() {
        try {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            PhoneHomeCredentials phoneHomeCredentials = this.getGa4Credentials();
            PhoneHomeClient phoneHomeClient = new PhoneHomeClient((IntLogger)this.logger, httpClientBuilder, this.gson, phoneHomeCredentials.getApiSecret(), phoneHomeCredentials.getMeasurementId());
            ExecutorService executor = Executors.newSingleThreadExecutor();
            PhoneHomeService phoneHomeService = PhoneHomeService.createAsynchronousPhoneHomeService((IntLogger)this.logger, (PhoneHomeClient)phoneHomeClient, (ExecutorService)executor);
            PhoneHomeRequestBodyBuilder phoneHomeRequestBodyBuilder = this.createPhoneHomeBuilder();
            PhoneHomeRequestBody phoneHomeRequestBody = this.addJenkinsMetadataAndBuildPhoneHomeRequest(phoneHomeRequestBodyBuilder);
            return Optional.ofNullable(phoneHomeService.phoneHome(phoneHomeRequestBody));
        }
        catch (Exception e) {
            this.logger.trace("Phone home failed due to an unexpected exception:", e);
            return Optional.empty();
        }
    }

    protected PhoneHomeRequestBody addJenkinsMetadataAndBuildPhoneHomeRequest(PhoneHomeRequestBodyBuilder phoneHomeRequestBodyBuilder) {
        this.jenkinsVersionHelper.getJenkinsVersion().ifPresent(jenkinsVersionString -> phoneHomeRequestBodyBuilder.addToMetaData("jenkins.version", jenkinsVersionString));
        return phoneHomeRequestBodyBuilder.build();
    }

    protected PhoneHomeCredentials getGa4Credentials() throws IOException, InterruptedException, JsonSyntaxException, IntegrationException {
        String fileUrl = CREDENTIALS_PATH;
        if (this.isTestEnvironment()) {
            fileUrl = TEST_CREDENTIALS_PATH;
            this.logger.debug("Phone home is operational for a test environment.");
        }
        this.logger.debug("Downloading phone home credentials.");
        RequestBuilder createRequestBuilder = this.intHttpClient.createRequestBuilder(HttpMethod.GET);
        HttpUriRequest request = createRequestBuilder.setUri(fileUrl).build();
        Response response = this.intHttpClient.execute(request);
        return (PhoneHomeCredentials)this.gson.fromJson(response.getContentString(), PhoneHomeCredentials.class);
    }

    private boolean isTestEnvironment() {
        String projectVersion = "";
        try {
            String versionFileContents = ResourceUtil.getResourceAsString(this.getClass(), (String)"/version.txt", (String)StandardCharsets.UTF_8.toString());
            projectVersion = String.valueOf(Arrays.asList(versionFileContents.split("\n")).stream().filter(s -> s.startsWith("version=")).map(s -> StringUtils.removeStart((String)s, (String)"version=")).findFirst().orElseThrow(() -> new RuntimeException("Error parsing version string from version file")));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return StringUtils.contains((CharSequence)projectVersion, (CharSequence)"SIGQA") || StringUtils.contains((CharSequence)projectVersion, (CharSequence)"SNAPSHOT");
    }
}

