/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.stepworkflow;

import com.blackduck.integration.function.ThrowingConsumer;
import com.blackduck.integration.function.ThrowingExecutor;
import com.blackduck.integration.function.ThrowingFunction;
import com.blackduck.integration.function.ThrowingSupplier;
import com.blackduck.integration.stepworkflow.SubStepResponse;

@FunctionalInterface
public interface SubStep<T, R> {
    public static <T, R, E extends Exception> SubStepResponse<R> defaultExecution(boolean runCondition, SubStepResponse<T> previousResponse, ThrowingSupplier<SubStepResponse<R>, E> successSupplier) {
        try {
            if (runCondition) {
                return (SubStepResponse)successSupplier.get();
            }
            return SubStepResponse.FAILURE(previousResponse);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return SubStepResponse.FAILURE(e);
        }
    }

    public static <T, R, E extends Exception> SubStep<T, R> ofFunction(ThrowingFunction<T, R, E> throwingFunction) {
        return previousResponse -> SubStep.defaultExecution(previousResponse.isSuccess() && previousResponse.hasData(), previousResponse, () -> {
            Object data = throwingFunction.apply(previousResponse.getData());
            return SubStepResponse.SUCCESS(data);
        });
    }

    public static <T, E extends Exception> SubStep<T, Object> ofConsumer(ThrowingConsumer<T, E> throwingConsumer) {
        return previousResponse -> SubStep.defaultExecution(previousResponse.isSuccess() && previousResponse.hasData(), previousResponse, () -> {
            throwingConsumer.accept(previousResponse.getData());
            return SubStepResponse.SUCCESS();
        });
    }

    public static <R, E extends Exception> SubStep<Object, R> ofSupplier(ThrowingSupplier<R, E> throwingSupplier) {
        return previousResponse -> SubStep.defaultExecution(previousResponse.isSuccess(), previousResponse, () -> {
            Object data = throwingSupplier.get();
            return SubStepResponse.SUCCESS(data);
        });
    }

    public static <E extends Exception> SubStep<Object, Object> ofExecutor(ThrowingExecutor<E> throwingExecutor) {
        return previousResponse -> SubStep.defaultExecution(previousResponse.isSuccess(), previousResponse, () -> {
            throwingExecutor.execute();
            return SubStepResponse.SUCCESS();
        });
    }

    public SubStepResponse<R> run(SubStepResponse<? extends T> var1);
}

