/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.stepworkflow;

import com.blackduck.integration.function.ThrowingConsumer;
import com.blackduck.integration.function.ThrowingFunction;
import com.blackduck.integration.stepworkflow.SubStepResponse;

public class StepWorkflowResponse<T> {
    private final boolean workflowSucceeded;
    private final Exception exception;
    private final T data;

    protected StepWorkflowResponse(SubStepResponse<T> lastSubStepResponse) {
        this.workflowSucceeded = lastSubStepResponse.isSuccess();
        this.exception = lastSubStepResponse.getException();
        this.data = lastSubStepResponse.getData();
    }

    public boolean wasSuccessful() {
        return this.workflowSucceeded;
    }

    public T getData() {
        return this.data;
    }

    public Exception getException() {
        return this.exception;
    }

    public <R, E extends Throwable> R handleResponse(ThrowingFunction<StepWorkflowResponse<T>, R, E> responseHandler) throws E {
        return (R)responseHandler.apply((Object)this);
    }

    public <E extends Throwable> void consumeResponse(ThrowingConsumer<StepWorkflowResponse<T>, E> responseHandler) throws E {
        responseHandler.accept((Object)this);
    }

    public T getDataOrThrowException() throws Exception {
        if (this.workflowSucceeded) {
            return this.data;
        }
        throw this.exception;
    }
}

