/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.jenkins.wrapper;

import com.blackduck.integration.jenkins.wrapper.BlackduckCredentialsHelper;
import com.blackduck.integration.jenkins.wrapper.JenkinsProxyHelper;
import com.blackduck.integration.jenkins.wrapper.JenkinsVersionHelper;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.matchers.IdMatcher;
import hudson.ProxyConfiguration;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.VersionNumber;
import java.util.Collections;
import java.util.Optional;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

public class JenkinsWrapper {
    private final Jenkins jenkins;

    public JenkinsWrapper(Jenkins jenkins) {
        this.jenkins = jenkins;
    }

    public static JenkinsWrapper initializeFromJenkinsJVM() {
        return new JenkinsWrapper(Jenkins.getInstanceOrNull());
    }

    public Optional<Jenkins> getJenkins() {
        return Optional.ofNullable(this.jenkins);
    }

    protected Optional<VersionNumber> getVersion() {
        return Optional.ofNullable(Jenkins.getVersion());
    }

    protected <T extends Credentials> Optional<T> getCredentialsById(IdMatcher idMatcher, Class<T> credentialsType) {
        return CredentialsProvider.lookupCredentials(credentialsType, (ItemGroup)this.jenkins, (Authentication)ACL.SYSTEM, Collections.emptyList()).stream().filter(arg_0 -> ((IdMatcher)idMatcher).matches(arg_0)).findAny();
    }

    protected Optional<ProxyConfiguration> getProxyConfiguration() {
        return Optional.ofNullable(this.jenkins).map(instance -> instance.proxy);
    }

    public JenkinsVersionHelper getVersionHelper() {
        return new JenkinsVersionHelper(this);
    }

    public JenkinsProxyHelper getProxyHelper() {
        return JenkinsProxyHelper.fromProxyConfiguration(this.getProxyConfiguration().orElse(null));
    }

    public BlackduckCredentialsHelper getCredentialsHelper() {
        return new BlackduckCredentialsHelper(this);
    }
}

