/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.jenkins.service;

import com.blackduck.integration.function.ThrowingSupplier;
import com.blackduck.integration.jenkins.extensions.JenkinsIntLogger;
import com.blackduck.integration.jenkins.service.JenkinsConfigService;
import com.blackduck.integration.jenkins.service.JenkinsRemotingService;
import com.blackduck.integration.jenkins.service.JenkinsRunService;
import com.blackduck.integration.jenkins.service.JenkinsWrapperContextService;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import jenkins.tasks.SimpleBuildWrapper;

public class JenkinsServicesFactory {
    protected final JenkinsIntLogger logger;
    protected final EnvVars envVars;
    protected final Launcher launcher;
    protected final Node node;
    protected final Run<?, ?> run;
    protected final ThrowingSupplier<FilePath, AbortException> validatedWorkspace;
    protected final TaskListener listener;

    public JenkinsServicesFactory(JenkinsIntLogger logger, EnvVars envVars, Launcher launcher, TaskListener listener, Node node, Run<?, ?> run, FilePath workspace) {
        this.logger = logger;
        this.envVars = envVars;
        this.launcher = launcher;
        this.node = node;
        this.run = run;
        this.validatedWorkspace = () -> this.validateWorkspace(workspace);
        this.listener = listener;
    }

    public JenkinsRemotingService createJenkinsRemotingService() throws AbortException {
        return new JenkinsRemotingService(this.launcher, (FilePath)this.validatedWorkspace.get(), this.listener);
    }

    public JenkinsConfigService createJenkinsConfigService() {
        return new JenkinsConfigService(this.envVars, this.node, this.listener);
    }

    public JenkinsRunService createJenkinsRunService() {
        return new JenkinsRunService(this.logger, this.run);
    }

    public JenkinsWrapperContextService createJenkinsWrapperContextService(SimpleBuildWrapper.Context context) {
        return new JenkinsWrapperContextService(context);
    }

    private FilePath validateWorkspace(FilePath workspace) throws AbortException {
        if (workspace == null) {
            throw new AbortException("Cannot execute this Blackduck integration: The workspace could not be determined.");
        }
        return workspace;
    }
}

