/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.jenkins.service;

import com.blackduck.integration.jenkins.extensions.ChangeBuildStatusTo;
import com.blackduck.integration.jenkins.extensions.JenkinsIntLogger;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;

public class JenkinsPipelineFlowService {
    private final JenkinsIntLogger logger;
    private final FlowNode flowNode;
    private final Run<?, ?> run;

    public JenkinsPipelineFlowService(JenkinsIntLogger logger, Run<?, ?> run, FlowNode flowNode) {
        this.logger = logger;
        this.flowNode = flowNode;
        this.run = run;
    }

    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public void markStageUnstable(String message) {
        this.logger.warn(message);
        this.flowNode.addOrReplaceAction((Action)new WarningAction(Result.UNSTABLE).withMessage(message));
        this.run.setResult(Result.UNSTABLE);
    }

    public void markStageAs(ChangeBuildStatusTo changeBuildStatusTo, String message) {
        Result result = changeBuildStatusTo.getResult();
        this.logger.alwaysLog("Setting stage status to " + result.toString());
        this.flowNode.addOrReplaceAction((Action)new WarningAction(result).withMessage(message));
        this.run.setResult(result);
    }
}

