/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.useragent;

import com.blackduck.integration.util.NameVersion;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class UserAgentItem {
    public static final String UNKNOWN = "unknown";
    private final NameVersion product;
    private final String comments;

    public UserAgentItem(NameVersion product, String comments) {
        this.product = product;
        this.comments = comments;
    }

    public UserAgentItem(NameVersion product) {
        this(product, null);
    }

    public NameVersion getProduct() {
        return this.product;
    }

    public Optional<String> getComments() {
        return Optional.ofNullable(this.comments);
    }

    public String createUserAgentString() {
        StringBuilder userAgent = new StringBuilder();
        userAgent.append(this.strip(this.clean(this.product.getName())));
        userAgent.append("/");
        userAgent.append(this.strip(this.clean(this.product.getVersion())));
        String cleaned = this.clean(this.comments);
        if (!UNKNOWN.equals(cleaned)) {
            userAgent.append(" (");
            userAgent.append(cleaned);
            userAgent.append(")");
        }
        return userAgent.toString();
    }

    private String strip(String original) {
        return original.replace(" ", "");
    }

    private String clean(String original) {
        String value = StringUtils.trimToEmpty((String)original);
        if (!value.isEmpty()) {
            return value;
        }
        return UNKNOWN;
    }
}

