/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.useragent;

import com.blackduck.integration.blackduck.useragent.UserAgentItem;
import com.blackduck.integration.util.NameVersion;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class BlackDuckCommon {
    public static final String NAME = "BlackDuckCommon";
    public static final String VERSION_RESOURCE_PATH = "com/blackduck/integration/blackduck/version.txt";
    public static final List<String> JAVA_PROPERTIES = Arrays.asList("java.vendor", "java.version", "os.arch", "os.name", "os.version");

    public static UserAgentItem createUserAgentItem() {
        String version = null;
        try (InputStream inputStream2 = BlackDuckCommon.class.getClassLoader().getResourceAsStream(VERSION_RESOURCE_PATH);){
            if (inputStream2 != null) {
                version = IOUtils.toString((InputStream)inputStream2, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException inputStream2) {
            // empty catch block
        }
        BlackDuckCommon blackDuckCommon = new BlackDuckCommon();
        return blackDuckCommon.createUserAgentItem(version, System::getProperty);
    }

    public UserAgentItem createUserAgentItem(String version, Function<String, String> valueLookup) {
        version = StringUtils.defaultString((String)StringUtils.trimToNull((String)version), (String)"unknown");
        NameVersion nameVersion = new NameVersion(NAME, version);
        String comments = JAVA_PROPERTIES.stream().map(valueLookup).collect(Collectors.joining(" "));
        return new UserAgentItem(nameVersion, comments);
    }
}

