/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.request;

import com.blackduck.integration.blackduck.api.core.BlackDuckResponse;
import com.blackduck.integration.blackduck.api.core.response.UrlMultipleResponses;
import com.blackduck.integration.blackduck.api.core.response.UrlResponse;
import com.blackduck.integration.blackduck.api.core.response.UrlSingleResponse;
import com.blackduck.integration.blackduck.api.generated.discovery.BlackDuckMediaTypeDiscovery;
import com.blackduck.integration.blackduck.http.BlackDuckRequestBuilder;
import com.blackduck.integration.blackduck.service.request.AcceptHeaderEditor;
import com.blackduck.integration.blackduck.service.request.BlackDuckMultipleRequest;
import com.blackduck.integration.blackduck.service.request.BlackDuckSingleRequest;
import com.blackduck.integration.blackduck.service.request.PagingDefaultsEditor;
import com.blackduck.integration.rest.HttpMethod;
import com.blackduck.integration.rest.HttpUrl;
import com.blackduck.integration.rest.request.Request;

public class BlackDuckRequest<T extends BlackDuckResponse, U extends UrlResponse<T>> {
    private static final PagingDefaultsEditor DEFAULT_PAGING_DEFAULTS_EDITOR = new PagingDefaultsEditor();
    private static final AcceptHeaderEditor DEFAULT_ACCEPT_HEADER_EDITOR = new AcceptHeaderEditor(new BlackDuckMediaTypeDiscovery());
    private final BlackDuckRequestBuilder blackDuckRequestBuilder;
    private final U urlResponse;

    public static <T extends BlackDuckResponse> BlackDuckRequest<T, UrlSingleResponse<T>> createSingleRequest(BlackDuckRequestBuilder blackDuckRequestBuilder, HttpUrl url, Class<T> responseClass) {
        return new BlackDuckSingleRequest(blackDuckRequestBuilder, new UrlSingleResponse(url, responseClass));
    }

    public static <T extends BlackDuckResponse> BlackDuckMultipleRequest<T> createMultipleRequest(BlackDuckRequestBuilder blackDuckRequestBuilder, HttpUrl url, Class<T> responseClass) {
        return new BlackDuckMultipleRequest(blackDuckRequestBuilder, new UrlMultipleResponses(url, responseClass));
    }

    public BlackDuckRequest(BlackDuckRequestBuilder blackDuckRequestBuilder, U urlResponse) {
        this(blackDuckRequestBuilder, urlResponse, DEFAULT_PAGING_DEFAULTS_EDITOR, DEFAULT_ACCEPT_HEADER_EDITOR);
    }

    public BlackDuckRequest(BlackDuckRequestBuilder blackDuckRequestBuilder, U urlResponse, PagingDefaultsEditor pagingDefaultsEditor, AcceptHeaderEditor acceptHeaderEditor) {
        this.blackDuckRequestBuilder = blackDuckRequestBuilder.url(urlResponse.getUrl());
        this.urlResponse = urlResponse;
        blackDuckRequestBuilder.apply(acceptHeaderEditor);
        if (HttpMethod.GET == blackDuckRequestBuilder.getMethod()) {
            blackDuckRequestBuilder.apply(pagingDefaultsEditor);
        }
    }

    public Request getRequest() {
        return this.blackDuckRequestBuilder.build();
    }

    public U getUrlResponse() {
        return this.urlResponse;
    }

    public HttpUrl getUrl() {
        return this.urlResponse.getUrl();
    }

    public Class<T> getResponseClass() {
        return this.urlResponse.getResponseClass();
    }
}

