/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.model;

import com.blackduck.integration.blackduck.api.generated.component.ProjectVersionComponentVersionActivityDataView;
import com.blackduck.integration.blackduck.api.generated.component.ProjectVersionComponentVersionLicensesView;
import com.blackduck.integration.blackduck.api.generated.component.ProjectVersionComponentVersionReviewedDetailsView;
import com.blackduck.integration.blackduck.api.generated.enumeration.MatchType;
import com.blackduck.integration.blackduck.api.generated.enumeration.ProjectVersionComponentPolicyStatusType;
import com.blackduck.integration.blackduck.api.generated.enumeration.ProjectVersionComponentReviewStatusType;
import com.blackduck.integration.blackduck.api.generated.enumeration.RiskPriorityType;
import com.blackduck.integration.blackduck.api.generated.enumeration.UsageType;
import com.blackduck.integration.blackduck.api.generated.view.ComponentMatchedFilesView;
import com.blackduck.integration.blackduck.api.generated.view.ProjectVersionComponentVersionView;
import com.blackduck.integration.blackduck.api.manual.temporary.component.VersionBomOriginView;
import com.blackduck.integration.blackduck.service.model.MatchedFilesModel;
import com.blackduck.integration.blackduck.service.model.RiskProfileCounts;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VersionBomComponentModel {
    private final ProjectVersionComponentVersionView component;
    private final List<MatchedFilesModel> matchedFiles;

    public VersionBomComponentModel(ProjectVersionComponentVersionView component, List<ComponentMatchedFilesView> matchedFiles) {
        this.component = component;
        this.matchedFiles = this.getMatchedFilesModel(matchedFiles);
    }

    public ProjectVersionComponentVersionActivityDataView getActivityData() {
        return this.component.getActivityData();
    }

    public RiskProfileCounts getActivityRiskProfile() {
        return new RiskProfileCounts(this.component.getActivityRiskProfile());
    }

    public boolean hasActivityRisk() {
        return this.hasRisk(this.getActivityRiskProfile());
    }

    public String getComponent() {
        return this.component.getComponent();
    }

    public String getComponentName() {
        return this.component.getComponentName();
    }

    public String getComponentVersion() {
        return this.component.getComponentVersion();
    }

    public String getComponentVersionName() {
        return this.component.getComponentVersionName();
    }

    public RiskProfileCounts getLicenseRiskProfile() {
        return new RiskProfileCounts(this.component.getLicenseRiskProfile());
    }

    public boolean hasLicenseRisk() {
        return this.hasRisk(this.getLicenseRiskProfile());
    }

    public List<ProjectVersionComponentVersionLicensesView> getLicenses() {
        return this.component.getLicenses();
    }

    public RiskProfileCounts getOperationalRiskProfile() {
        return new RiskProfileCounts(this.component.getOperationalRiskProfile());
    }

    public boolean hasOperationalRisk() {
        return this.hasRisk(this.getOperationalRiskProfile());
    }

    public List<VersionBomOriginView> getOrigins() {
        return this.component.getOrigins();
    }

    public List<MatchType> getMatchTypes() {
        return this.component.getMatchTypes();
    }

    public Date getReleasedOn() {
        return this.component.getReleasedOn();
    }

    public RiskProfileCounts getSecurityRiskProfile() {
        return new RiskProfileCounts(this.component.getSecurityRiskProfile());
    }

    public boolean hasSecurityRisk() {
        return this.hasRisk(this.getSecurityRiskProfile());
    }

    public List<UsageType> getUsages() {
        return this.component.getUsages();
    }

    public RiskProfileCounts getVersionRiskProfile() {
        return new RiskProfileCounts(this.component.getVersionRiskProfile());
    }

    public boolean hasVersionRisk() {
        return this.hasRisk(this.getVersionRiskProfile());
    }

    public ProjectVersionComponentReviewStatusType getReviewStatus() {
        return this.component.getReviewStatus();
    }

    public ProjectVersionComponentVersionReviewedDetailsView getReviewedDetails() {
        return this.component.getReviewedDetails();
    }

    public ProjectVersionComponentPolicyStatusType getApprovalStatus() {
        return this.component.getApprovalStatus();
    }

    public List<MatchedFilesModel> getMatchedFiles() {
        return this.matchedFiles;
    }

    private boolean hasRisk(RiskProfileCounts counts) {
        return counts.getCount(RiskPriorityType.LOW).intValue() + counts.getCount(RiskPriorityType.MEDIUM).intValue() + counts.getCount(RiskPriorityType.HIGH).intValue() > 0;
    }

    private List<MatchedFilesModel> getMatchedFilesModel(List<ComponentMatchedFilesView> matchedFiles) {
        ArrayList<MatchedFilesModel> matchedFileModels = new ArrayList<MatchedFilesModel>(matchedFiles.size());
        for (ComponentMatchedFilesView matchedFile : matchedFiles) {
            matchedFileModels.add(new MatchedFilesModel(matchedFile));
        }
        return matchedFileModels;
    }
}

