/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.blackduck.service.model;

import com.blackduck.integration.log.IntLogger;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class ScannerSplitStream
extends OutputStream {
    private static final int EOF = -1;
    private static final int ETX = 3;
    private static final int EOT = 4;
    private static final int LF = 10;
    private static final int CR = 13;
    private static final String EXCEPTION = "Exception:";
    private static final String FINISHED = "Finished in";
    private static final String ERROR = "ERROR:";
    private static final String WARN = "WARN:";
    private static final String INFO = "INFO:";
    private static final String DEBUG = "DEBUG:";
    private static final String TRACE = "TRACE:";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final OutputStream outputFileStream;
    private final IntLogger logger;
    private String output = "";
    private String lineBuffer = "";
    private String currentLine = "";
    private int previousCodePoint = -1;

    public ScannerSplitStream(IntLogger logger, OutputStream outputFileStream) {
        this.outputFileStream = outputFileStream;
        this.logger = logger;
    }

    public String getOutput() {
        return this.output;
    }

    public Boolean hasOutput() {
        return StringUtils.isNotBlank((CharSequence)this.output);
    }

    @Override
    public void write(int codePoint) throws IOException {
        this.outputFileStream.write(codePoint);
        if (-1 == codePoint) {
            throw new EOFException();
        }
        boolean atLineEnd = false;
        if (3 == codePoint || 4 == codePoint) {
            atLineEnd = true;
        } else if (10 == codePoint && 13 != this.previousCodePoint) {
            atLineEnd = true;
        } else if (10 == codePoint && 13 == this.previousCodePoint) {
            atLineEnd = true;
            this.currentLine = this.currentLine.substring(0, this.currentLine.length() - 1);
        } else if (10 != codePoint && 13 == this.previousCodePoint) {
            this.processLine(this.currentLine);
            this.currentLine = "";
        }
        this.previousCodePoint = codePoint;
        if (atLineEnd) {
            this.processLine(this.currentLine);
            this.currentLine = "";
        } else {
            String stringAscii = new String(Character.toChars(codePoint));
            this.currentLine = this.currentLine + stringAscii;
        }
    }

    private Boolean isLoggableLine(String line) {
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith(ERROR)) {
            return true;
        }
        if (trimmedLine.startsWith(WARN)) {
            return true;
        }
        if (trimmedLine.startsWith(INFO)) {
            return true;
        }
        if (trimmedLine.startsWith(DEBUG)) {
            return true;
        }
        if (trimmedLine.startsWith(TRACE)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase((CharSequence)trimmedLine, (CharSequence)EXCEPTION)) {
            return true;
        }
        return StringUtils.containsIgnoreCase((CharSequence)trimmedLine, (CharSequence)FINISHED);
    }

    private void processLine(String line) throws UnsupportedEncodingException {
        if (this.lineBuffer.length() == 0) {
            this.lineBuffer = line;
        } else if (this.isLoggableLine(line).booleanValue()) {
            this.writeToConsole(this.lineBuffer);
            this.lineBuffer = line;
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(this.lineBuffer);
            builder.append(LINE_SEPARATOR);
            builder.append(line);
            this.lineBuffer = builder.toString();
        }
    }

    @Override
    public void write(byte[] byteArray) throws IOException {
        this.outputFileStream.write(byteArray);
        String currentLine = new String(byteArray, StandardCharsets.UTF_8);
        if (currentLine.contains(LINE_SEPARATOR)) {
            String[] splitLines;
            for (String line : splitLines = currentLine.split(LINE_SEPARATOR)) {
                this.processLine(line);
            }
        } else {
            this.processLine(currentLine);
        }
    }

    @Override
    public void write(byte[] byteArray, int offset, int length) throws IOException {
        this.outputFileStream.write(byteArray, offset, length);
        String currentLine = new String(byteArray, offset, length, StandardCharsets.UTF_8);
        if (currentLine.contains(LINE_SEPARATOR)) {
            String[] splitLines;
            for (String line : splitLines = currentLine.split(LINE_SEPARATOR)) {
                this.processLine(line);
            }
        } else {
            this.processLine(currentLine);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputFileStream.flush();
        this.writeToConsole(this.lineBuffer);
        this.lineBuffer = "";
        if (StringUtils.isNotBlank((CharSequence)this.currentLine)) {
            this.writeToConsole(this.currentLine);
            this.currentLine = "";
        }
    }

    @Override
    public void close() throws IOException {
        this.outputFileStream.close();
    }

    private void writeToConsole(String line) {
        String trimmedLine = line.trim();
        if (trimmedLine.startsWith(DEBUG) || trimmedLine.startsWith(TRACE)) {
            return;
        }
        StringBuilder outputBuilder = new StringBuilder();
        outputBuilder.append(this.output);
        if (trimmedLine.startsWith(ERROR)) {
            outputBuilder.append(trimmedLine);
            outputBuilder.append(LINE_SEPARATOR);
            this.logger.error(trimmedLine);
        } else if (trimmedLine.startsWith(WARN)) {
            outputBuilder.append(trimmedLine);
            outputBuilder.append(LINE_SEPARATOR);
            this.logger.warn(trimmedLine);
        } else if (trimmedLine.startsWith(INFO)) {
            outputBuilder.append(trimmedLine);
            outputBuilder.append(LINE_SEPARATOR);
            this.logger.info(trimmedLine);
        } else if (StringUtils.containsIgnoreCase((CharSequence)trimmedLine, (CharSequence)EXCEPTION)) {
            outputBuilder.append(trimmedLine);
            outputBuilder.append(LINE_SEPARATOR);
            this.logger.error(trimmedLine);
        } else if (StringUtils.containsIgnoreCase((CharSequence)trimmedLine, (CharSequence)FINISHED)) {
            outputBuilder.append(trimmedLine);
            outputBuilder.append(LINE_SEPARATOR);
            this.logger.info(trimmedLine);
        }
        this.output = outputBuilder.toString();
    }
}

